/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.repository;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.Repository;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class UsernameRepository
extends Repository {
    private final Database database;

    public UsernameRepository(Database database) {
        this.database = database;
    }

    @Override
    public void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS usernames (\n\tid integer PRIMARY KEY,\n\ttime integer NOT NULL,\n\tuuid text NOT NULL,\n\tname text NOT NULL,\n\tUNIQUE(uuid, name)\n);\n";
        if (this.isMysql()) {
            sql = "CREATE TABLE IF NOT EXISTS usernames (\n\tid int PRIMARY KEY AUTO_INCREMENT,\n\ttime bigint NOT NULL,\n\tuuid varchar(36) NOT NULL,\n\tname varchar(16) NOT NULL,\n\tUNIQUE(uuid, name)\n)\nENGINE=InnoDB DEFAULT CHARACTER SET utf8mb4;\n";
        }
        this.database.createTable(sql);
    }

    public void insert(long time, String uuid, String name) {
        String query = "INSERT OR IGNORE INTO usernames(time, uuid, name)\nVALUES(?, ?, ?);\n";
        if (this.isMysql()) {
            query = "INSERT IGNORE INTO usernames(time, uuid, name)\nVALUES(?, ?, ?);\n";
        }
        try {
            PreparedStatement preparedStatement = this.database.prepareStatement(query);
            preparedStatement.setLong(1, time);
            preparedStatement.setString(2, uuid);
            preparedStatement.setString(3, name);
            this.database.queue.add(preparedStatement);
        }
        catch (SQLException exception) {
            GriefLogger.LOGGER.error("Failed to insert username into database", (Throwable)exception);
        }
    }
}

