/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.model.history;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.model.BlockPosition;
import com.daqem.grieflogger.model.SimpleItemStack;
import com.daqem.grieflogger.model.Time;
import com.daqem.grieflogger.model.User;
import com.daqem.grieflogger.model.action.IAction;
import com.daqem.grieflogger.model.action.ItemAction;
import com.daqem.grieflogger.model.history.History;
import java.util.UUID;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemHistory
extends History {
    protected final SimpleItemStack itemStack;

    public ItemHistory(long time, String name, String uuid, int x, int y, int z, String material, DataComponentPatch data, int amount, int action) {
        this(new Time(time), new User(name, UUID.fromString(uuid)), new BlockPosition(x, y, z), new SimpleItemStack(ResourceLocation.parse((String)material), amount, data), ItemAction.fromId(action));
    }

    public ItemHistory(Time time, User user, BlockPosition position, SimpleItemStack itemStack, IAction action) {
        super(time, user, position, action);
        this.itemStack = itemStack;
    }

    public SimpleItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public Component getComponent() {
        return this.getTime().getFormattedTimeAgo().append(" ").append(this.getAction().getPrefix()).append(" ").append(this.getUser().getNameComponent()).append(" ").append(this.getAction().getPastTense()).append(" ").append((Component)Component.literal((String)String.valueOf(this.getItemStack().getCount()))).append(" ").append(this.getMaterialComponent());
    }

    @Override
    public Component getMaterialComponent() {
        int cappedCount = Math.min(this.itemStack.getCount(), 64);
        ItemStack cappedItemStack = this.itemStack.toItemStack().copyWithCount(cappedCount);
        MutableComponent mutableComponent = GriefLogger.themedLiteral(this.itemStack.getItem().arch$registryName().toString().replace("minecraft:", ""));
        return mutableComponent.withStyle(mutableComponent.getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(cappedItemStack))));
    }
}

