/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger;

import com.daqem.grieflogger.config.GriefLoggerConfig;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.service.Services;
import com.daqem.grieflogger.event.ChatEvent;
import com.daqem.grieflogger.event.CommandEvent;
import com.daqem.grieflogger.event.EntityEvents;
import com.daqem.grieflogger.event.LevelLoadEvent;
import com.daqem.grieflogger.event.PlayerJoinEvent;
import com.daqem.grieflogger.event.PlayerQuitEvent;
import com.daqem.grieflogger.event.RegisterCommandEvent;
import com.daqem.grieflogger.event.TickEvents;
import com.daqem.grieflogger.event.block.BlockEvents;
import com.daqem.grieflogger.event.item.ItemEvents;
import com.mojang.logging.LogUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.slf4j.Logger;

public class GriefLogger {
    public static final String MOD_ID = "grieflogger";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static Database DATABASE;

    public static void init() {
        GriefLogger.initConfigs();
        boolean databaseReady = GriefLogger.prepareDatabase();
        if (!databaseReady) {
            return;
        }
        GriefLogger.registerEvents();
    }

    private static void initConfigs() {
        GriefLoggerConfig.init();
    }

    private static void registerEvents() {
        BlockEvents.registerEvents();
        TickEvents.registerEvents();
        EntityEvents.registerEvents();
        ItemEvents.registerEvents();
        PlayerJoinEvent.registerEvent();
        PlayerQuitEvent.registerEvent();
        LevelLoadEvent.registerEvent();
        RegisterCommandEvent.registerEvent();
        ChatEvent.registerEvent();
        CommandEvent.registerEvent();
    }

    private static boolean prepareDatabase() {
        LOGGER.info("Preparing GriefLogger database...");
        long start = System.currentTimeMillis();
        try {
            DATABASE = new Database();
            boolean connected = DATABASE.createConnection();
            if (!connected) {
                LOGGER.error("Failed to connect to database, disabling GriefLogger...");
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to connect to database, disabling GriefLogger...", (Throwable)e);
            return false;
        }
        Services.MATERIAL.createTable();
        Services.USER.createTable();
        Services.USERNAME.createTable();
        Services.LEVEL.createTable();
        Services.ENTITY.createTable();
        Services.BLOCK.createTable();
        Services.CONTAINER.createTable();
        Services.SESSION.createTable();
        Services.CHAT.createTable();
        Services.COMMAND.createTable();
        Services.ITEM.createTable();
        if (((Boolean)GriefLoggerConfig.useIndexes.get()).booleanValue()) {
            Services.BLOCK.createIndexes();
            Services.CHAT.createIndexes();
            Services.COMMAND.createIndexes();
            Services.CONTAINER.createIndexes();
            Services.ITEM.createIndexes();
            Services.SESSION.createIndexes();
        }
        long end = System.currentTimeMillis();
        LOGGER.info("Database prepared in {}ms.", (Object)(end - start));
        return true;
    }

    public static Database getDatabase() {
        return DATABASE;
    }

    public static class_5250 translate(String str) {
        class_5250 component = GriefLogger.translate(str, class_2588.field_24367);
        if (((Boolean)GriefLoggerConfig.serverSideOnlyMode.get()).booleanValue()) {
            component = class_2561.method_43470((String)component.getString()).method_27696(component.method_10866());
        }
        return component;
    }

    public static class_5250 translate(String str, Object ... args) {
        class_5250 component = class_2561.method_43469((String)("grieflogger." + str), (Object[])args);
        if (((Boolean)GriefLoggerConfig.serverSideOnlyMode.get()).booleanValue()) {
            component = class_2561.method_43470((String)component.getString()).method_27696(component.method_10866());
        }
        return component;
    }

    public static class_5250 literal(String str) {
        return class_2561.method_43470((String)str);
    }

    public static class_5250 themedTranslate(String str) {
        class_5250 component = GriefLogger.themedTranslate(str, class_2588.field_24367);
        if (((Boolean)GriefLoggerConfig.serverSideOnlyMode.get()).booleanValue()) {
            component = class_2561.method_43470((String)component.getString()).method_27696(component.method_10866());
        }
        return component;
    }

    public static class_5250 themedTranslate(String str, Object ... args) {
        class_5250 component = class_2561.method_43469((String)("grieflogger." + str), (Object[])args).method_27696(GriefLogger.getTheme());
        if (((Boolean)GriefLoggerConfig.serverSideOnlyMode.get()).booleanValue()) {
            component = class_2561.method_43470((String)component.getString()).method_27696(component.method_10866());
        }
        return component;
    }

    public static class_5250 themedLiteral(String str) {
        class_5250 component = class_2561.method_43470((String)str).method_27696(GriefLogger.getTheme());
        if (((Boolean)GriefLoggerConfig.serverSideOnlyMode.get()).booleanValue()) {
            component = class_2561.method_43470((String)component.getString()).method_27696(component.method_10866());
        }
        return component;
    }

    public static class_2561 getName() {
        class_5250 component = GriefLogger.translate("name").method_27696(GriefLogger.getTheme());
        if (((Boolean)GriefLoggerConfig.serverSideOnlyMode.get()).booleanValue()) {
            component = class_2561.method_43470((String)component.getString()).method_27696(component.method_10866());
        }
        return component;
    }

    public static class_2583 getTheme() {
        return class_2583.field_24360.method_36139(16562691);
    }

    public static class_2960 getId(String id) {
        return class_2960.method_60655((String)MOD_ID, (String)id);
    }
}

