/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.GriefLoggerExpectPlatform;
import com.daqem.grieflogger.config.GriefLoggerConfig;
import com.daqem.grieflogger.database.queue.IQueue;
import com.daqem.grieflogger.database.queue.Queue;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Database {
    @Nullable
    private Connection connection;
    @Nullable
    private Statement statement;
    public final IQueue queue = new Queue(this, false);
    public final IQueue batchQueue = new Queue(this, true);

    public boolean createConnection() {
        boolean connected = (Boolean)GriefLoggerConfig.useMysql.get() != false ? this.createMysqlConnection() : this.createSqliteConnection();
        if (this.connection != null) {
            GriefLogger.LOGGER.info("Connected to database");
            try {
                this.statement = this.connection.createStatement();
            }
            catch (SQLException e) {
                GriefLogger.LOGGER.error("Failed to create statement", (Throwable)e);
                return false;
            }
            try {
                this.connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                GriefLogger.LOGGER.error("Failed to set auto commit", (Throwable)e);
                return false;
            }
        }
        return connected && this.connection != null && this.statement != null;
    }

    public boolean createMysqlConnection() {
        String host = (String)GriefLoggerConfig.mysqlHost.get();
        int port = (Integer)GriefLoggerConfig.mysqlPort.get();
        String database = (String)GriefLoggerConfig.mysqlDatabase.get();
        String user = (String)GriefLoggerConfig.mysqlUsername.get();
        String password = (String)GriefLoggerConfig.mysqlPassword.get();
        String url = "jdbc:mysql://" + host + ":" + port + "/" + database + "?allowReconnect=true&autoReconnect=true&connectTimeout=" + String.valueOf(GriefLoggerConfig.mysqlTimeout.get());
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            GriefLogger.LOGGER.error("Failed to load MySQL driver", (Throwable)e);
            return false;
        }
        try {
            this.connection = DriverManager.getConnection(url, user, password);
        }
        catch (SQLException e) {
            GriefLogger.LOGGER.error("Failed to connect to MySQL database", (Throwable)e);
            return false;
        }
        return this.connection != null;
    }

    public boolean createSqliteConnection() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            GriefLogger.LOGGER.error("Failed to load SQLite driver", (Throwable)e);
            return false;
        }
        Path path = GriefLoggerExpectPlatform.getConfigDirectory().resolve("grieflogger");
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        try {
            String dbPath = path.resolve("database.db").toString();
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbPath);
        }
        catch (SQLException e) {
            GriefLogger.LOGGER.error("Failed to connect to SQLite database", (Throwable)e);
            return false;
        }
        return this.connection != null;
    }

    public void createTable(String sql) {
        try {
            if (this.statement != null) {
                this.statement.execute(sql);
            }
        }
        catch (SQLException e) {
            GriefLogger.LOGGER.error("Failed to create table", (Throwable)e);
        }
    }

    public void execute(String sql, boolean logError) {
        block3: {
            try {
                if (this.statement != null) {
                    this.statement.execute(sql);
                }
            }
            catch (SQLException e) {
                if (!logError) break block3;
                GriefLogger.LOGGER.error("Failed to execute statement", (Throwable)e);
            }
        }
    }

    public PreparedStatement prepareStatement(String query) throws SQLException {
        if (this.connection != null) {
            return this.connection.prepareStatement(query);
        }
        throw new SQLException("Connection is null");
    }

    public void executeStatements(List<PreparedStatement> statements, boolean isBatch) {
        try {
            for (PreparedStatement statement : statements) {
                if (statement == null) {
                    GriefLogger.LOGGER.error("Statement is null");
                    continue;
                }
                if (statement.isClosed()) {
                    GriefLogger.LOGGER.error("Statement is closed");
                    continue;
                }
                PreparedStatement preparedStatement = statement;
                try {
                    if (isBatch) {
                        statement.executeBatch();
                        continue;
                    }
                    statement.executeUpdate();
                }
                finally {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                }
            }
            if (!statements.isEmpty() && this.connection != null) {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            GriefLogger.LOGGER.error("Failed to execute statements", (Throwable)e);
        }
    }
}

