/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.repository;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.command.filter.FilterList;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.Repository;
import com.daqem.grieflogger.model.history.BlockHistory;
import com.daqem.grieflogger.model.history.IHistory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class BlockRepository
extends Repository {
    private final Database database;

    public BlockRepository(Database database) {
        this.database = database;
    }

    @Override
    public void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS blocks (\n\ttime integer NOT NULL,\n\tuser integer NOT NULL,\n\tlevel integer NOT NULL,\n\tx integer NOT NULL,\n\ty integer NOT NULL,\n\tz integer NOT NULL,\n\ttype integer NOT NULL,\n\taction integer NOT NULL,\n\tFOREIGN KEY(user) REFERENCES users(id),\n\tFOREIGN KEY(level) REFERENCES levels(id),\n\tFOREIGN KEY(type) REFERENCES materials(id)\n);\n";
        if (this.isMysql()) {
            sql = "CREATE TABLE IF NOT EXISTS blocks (\n\ttime bigint NOT NULL,\n\tuser int NOT NULL,\n\tlevel int NOT NULL,\n\tx int NOT NULL,\n\ty int NOT NULL,\n\tz int NOT NULL,\n\ttype int NOT NULL,\n\taction int NOT NULL,\n\tFOREIGN KEY(user) REFERENCES users(id),\n\tFOREIGN KEY(level) REFERENCES levels(id),\n\tFOREIGN KEY(type) REFERENCES materials(id)\n)\nENGINE=InnoDB DEFAULT CHARACTER SET utf8mb4;\n";
        }
        this.database.createTable(sql);
    }

    public void createIndexes() {
        String sql = "CREATE INDEX IF NOT EXISTS coordinates ON blocks (x, y, z);\n";
        if (this.isMysql()) {
            sql = "ALTER TABLE blocks ADD INDEX coordinates (x, y, z);\n";
        }
        this.database.execute(sql, false);
    }

    public void insertMaterial(long time, String userUuid, String levelName, int x, int y, int z, String material, int blockAction) {
        String materialQuery = "INSERT OR IGNORE INTO materials(name)\nVALUES(?);\n";
        if (this.isMysql()) {
            materialQuery = "INSERT IGNORE INTO materials(name)\nVALUES(?);\n";
        }
        String blockQuery = "INSERT OR IGNORE INTO blocks(time, user, level, x, y, z, type, action)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, (\n    SELECT id FROM materials WHERE name = ?\n), ?);\n";
        if (this.isMysql()) {
            blockQuery = "INSERT IGNORE INTO blocks(time, user, level, x, y, z, type, action)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, (\n    SELECT id FROM materials WHERE name = ?\n), ?);\n";
        }
        try {
            PreparedStatement materialStatement = this.database.prepareStatement(materialQuery);
            materialStatement.setString(1, material);
            this.database.queue.add(materialStatement);
            PreparedStatement blockStatement = this.database.prepareStatement(blockQuery);
            blockStatement.setLong(1, time);
            blockStatement.setString(2, userUuid);
            blockStatement.setString(3, levelName);
            blockStatement.setInt(4, x);
            blockStatement.setInt(5, y);
            blockStatement.setInt(6, z);
            blockStatement.setString(7, material);
            blockStatement.setInt(8, blockAction);
            this.database.queue.add(blockStatement);
        }
        catch (SQLException exception) {
            GriefLogger.LOGGER.error("Failed to insert block into database", (Throwable)exception);
        }
    }

    public void insertEntity(long time, String userUuid, String levelName, int x, int y, int z, String entity, int blockAction) {
        String materialQuery = "INSERT OR IGNORE INTO entities(name)\nVALUES(?);\n";
        if (this.isMysql()) {
            materialQuery = "INSERT IGNORE INTO entities(name)\nVALUES(?);\n";
        }
        String blockQuery = "INSERT OR IGNORE INTO blocks(time, user, level, x, y, z, type, action)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, (\n    SELECT id FROM entities WHERE name = ?\n), ?);\n";
        if (this.isMysql()) {
            blockQuery = "INSERT IGNORE INTO blocks(time, user, level, x, y, z, type, action)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, (\n    SELECT id FROM entities WHERE name = ?\n), ?);\n";
        }
        try {
            PreparedStatement materialStatement = this.database.prepareStatement(materialQuery);
            PreparedStatement blockStatement = this.database.prepareStatement(blockQuery);
            materialStatement.setString(1, entity);
            this.database.queue.add(materialStatement);
            blockStatement.setLong(1, time);
            blockStatement.setString(2, userUuid);
            blockStatement.setString(3, levelName);
            blockStatement.setInt(4, x);
            blockStatement.setInt(5, y);
            blockStatement.setInt(6, z);
            blockStatement.setString(7, entity);
            blockStatement.setInt(8, blockAction);
            this.database.queue.add(blockStatement);
        }
        catch (SQLException exception) {
            GriefLogger.LOGGER.error("Failed to insert block into database", (Throwable)exception);
        }
    }

    public List<IHistory> getBlockHistory(String levelName, int x, int y, int z) {
        ArrayList<IHistory> blockHistory = new ArrayList<IHistory>();
        String query = "SELECT blocks.time, users.name, users.uuid, blocks.x, blocks.y, blocks.z, materials.name, blocks.action\nFROM blocks\nINNER JOIN users ON blocks.user = users.id\nINNER JOIN levels ON blocks.level = (\n    SELECT id FROM levels WHERE name = ?\n)\nINNER JOIN materials ON blocks.type = materials.id\nWHERE blocks.level = levels.id AND blocks.x = ? AND blocks.y = ? AND blocks.z = ? AND (blocks.action = 0 OR blocks.action = 1)\nORDER BY blocks.time DESC\n";
        try (PreparedStatement preparedStatement = this.database.prepareStatement(query);){
            preparedStatement.setString(1, levelName);
            preparedStatement.setInt(2, x);
            preparedStatement.setInt(3, y);
            preparedStatement.setInt(4, z);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                blockHistory.add(new BlockHistory(resultSet.getLong(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4), resultSet.getInt(5), resultSet.getInt(6), resultSet.getString(7), resultSet.getInt(8)));
            }
        }
        catch (SQLException e) {
            GriefLogger.LOGGER.error("Failed to get block history", (Throwable)e);
        }
        return blockHistory;
    }

    public List<IHistory> getInteractionHistory(String levelName, int x, int y, int z) {
        ArrayList<IHistory> blockHistory = new ArrayList<IHistory>();
        String query = "SELECT blocks.time, users.name, users.uuid, blocks.x, blocks.y, blocks.z, materials.name, blocks.action\nFROM blocks\nINNER JOIN users ON blocks.user = users.id\nINNER JOIN levels ON blocks.level = (\n    SELECT id FROM levels WHERE name = ?\n)\nINNER JOIN materials ON blocks.type = materials.id\nWHERE blocks.level = levels.id AND blocks.x = ? AND blocks.y = ? AND blocks.z = ? AND blocks.action = 2\nORDER BY blocks.time DESC\n";
        try (PreparedStatement preparedStatement = this.database.prepareStatement(query);){
            preparedStatement.setString(1, levelName);
            preparedStatement.setInt(2, x);
            preparedStatement.setInt(3, y);
            preparedStatement.setInt(4, z);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                blockHistory.add(new BlockHistory(resultSet.getLong(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4), resultSet.getInt(5), resultSet.getInt(6), resultSet.getString(7), resultSet.getInt(8)));
            }
        }
        catch (SQLException e) {
            GriefLogger.LOGGER.error("Failed to get block history", (Throwable)e);
        }
        return blockHistory;
    }

    public void removeInteractionsForPosition(String levelName, int x, int y, int z) {
        String query = "DELETE FROM blocks\nWHERE level = (\n    SELECT id FROM levels WHERE name = ?\n) AND x = ? AND y = ? AND z = ? AND action = 2\n";
        try {
            PreparedStatement preparedStatement = this.database.prepareStatement(query);
            preparedStatement.setString(1, levelName);
            preparedStatement.setInt(2, x);
            preparedStatement.setInt(3, y);
            preparedStatement.setInt(4, z);
            this.database.queue.add(preparedStatement);
        }
        catch (SQLException e) {
            GriefLogger.LOGGER.error("Failed to remove interactions for position", (Throwable)e);
        }
    }

    public List<IHistory> getFilteredBlockHistory(String levelName, FilterList filterList) {
        ArrayList<IHistory> arrayList;
        block17: {
            @Nullable String actions = filterList.getActionString();
            @Nullable String users = filterList.getUserString();
            @Nullable String includeMaterials = filterList.getIncludeMaterialsString();
            @Nullable String excludeMaterials = filterList.getExcludeMaterialsString();
            String query = "SELECT\n    blocks.time,\n    users.name,\n    users.uuid,\n    blocks.x,\n    blocks.y,\n    blocks.z,\n    CASE\n        WHEN blocks.action = 3 THEN entities.name\n        ELSE materials.name\n    END AS type_name,\n    blocks.action\nFROM\n    blocks\nINNER JOIN users ON blocks.user = users.id\nINNER JOIN levels ON blocks.level = levels.id\nLEFT JOIN materials ON blocks.type = materials.id AND blocks.action != 3\nLEFT JOIN entities ON blocks.type = entities.id AND blocks.action = 3\nWHERE\n    levels.name = ?\n    AND blocks.time > ?\n    AND (? IS NULL OR blocks.action IN (%s))\n    AND (? IS NULL OR users.id IN (%s))\n    AND (? IS NULL OR materials.name IN ('%s'))\n    AND (? IS NULL OR materials.name NOT IN ('%s'))\n    AND blocks.x BETWEEN ? AND ?\n    AND blocks.y BETWEEN ? AND ?\n    AND blocks.z BETWEEN ? AND ?\nORDER BY\n    blocks.time DESC\nLIMIT 1000;\n".formatted(actions, users, includeMaterials, excludeMaterials);
            PreparedStatement preparedStatement = this.database.prepareStatement(query);
            try {
                preparedStatement.setString(1, levelName);
                preparedStatement.setLong(2, filterList.getTime());
                if (actions == null || actions.isEmpty()) {
                    preparedStatement.setNull(3, 12);
                } else {
                    preparedStatement.setString(3, "not null");
                }
                if (users == null || users.isEmpty()) {
                    preparedStatement.setNull(4, 12);
                } else {
                    preparedStatement.setString(4, "not null");
                }
                if (includeMaterials == null || includeMaterials.isEmpty()) {
                    preparedStatement.setNull(5, 12);
                } else {
                    preparedStatement.setString(5, "not null");
                }
                if (excludeMaterials == null || excludeMaterials.isEmpty()) {
                    preparedStatement.setNull(6, 12);
                } else {
                    preparedStatement.setString(6, "not null");
                }
                preparedStatement.setInt(7, filterList.getRadiusMinX());
                preparedStatement.setInt(8, filterList.getRadiusMaxX());
                preparedStatement.setInt(9, filterList.getRadiusMinY());
                preparedStatement.setInt(10, filterList.getRadiusMaxY());
                preparedStatement.setInt(11, filterList.getRadiusMinZ());
                preparedStatement.setInt(12, filterList.getRadiusMaxZ());
                ArrayList<IHistory> blockHistory = new ArrayList<IHistory>();
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    blockHistory.add(new BlockHistory(resultSet.getLong(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4), resultSet.getInt(5), resultSet.getInt(6), resultSet.getString(7), resultSet.getInt(8)));
                }
                arrayList = blockHistory;
                if (preparedStatement == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    GriefLogger.LOGGER.error("Failed to get block history from database", (Throwable)exception);
                    return List.of();
                }
            }
            preparedStatement.close();
        }
        return arrayList;
    }
}

