package com.daqem.grieflogger.fabric.mixin;

import com.daqem.grieflogger.event.block.PlaceBlockEvent;
import net.minecraft.class_1309;
import net.minecraft.class_1755;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1755.class)
public class MixinBucketItem {

    @Inject(
            method = "emptyContents",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z",
                    shift = At.Shift.AFTER
            )
    )
    private void onLiquidPlaced(class_1309 livingEntity, class_1937 level, class_2338 blockPos, class_3965 blockHitResult, CallbackInfoReturnable<Boolean> cir) {
        if (livingEntity instanceof class_3222 serverPlayer) {
            PlaceBlockEvent.placeBlock(level, blockPos, level.method_8320(blockPos), serverPlayer);
        }
    }
}