/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.command.filter;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.command.filter.IFilter;
import com.daqem.grieflogger.model.TimeUnit;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;

public class TimeFilter
implements IFilter {
    private static final List<Integer> numbers = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9));
    private final long time;

    public TimeFilter() {
        this(0L, TimeUnit.MINUTE);
    }

    public TimeFilter(long time, TimeUnit timeUnit) {
        this.time = System.currentTimeMillis() - timeUnit.getMilliseconds() * time;
    }

    @Override
    public String getName() {
        return GriefLogger.translate("filter.time").getString();
    }

    @Override
    public List<String> getOptions() {
        return new ArrayList<String>();
    }

    @Override
    public String[] listSuggestions(SuggestionsBuilder builder, String prefix, String suffix) {
        if (suffix.isEmpty()) {
            return (String[])numbers.stream().map(s -> this.getName() + "." + s).toArray(String[]::new);
        }
        if (TimeUnit.getAbbreviations().stream().anyMatch(suffix::endsWith)) {
            String number = suffix.substring(0, suffix.length() - 1);
            try {
                Integer.parseInt(number);
                return new String[]{this.getName() + "." + number + suffix.substring(suffix.length() - 1)};
            }
            catch (NumberFormatException e) {
                return new String[0];
            }
        }
        try {
            Integer.parseInt(suffix);
            return (String[])TimeUnit.getAbbreviations().stream().map(s -> this.getName() + "." + suffix + s).toArray(String[]::new);
        }
        catch (NumberFormatException e) {
            return new String[0];
        }
    }

    @Override
    public IFilter parse(StringReader reader, String suffix) {
        TimeUnit timeUnit = TimeUnit.values()[TimeUnit.getAbbreviations().indexOf(suffix.substring(suffix.length() - 1))];
        int time = Integer.parseInt(suffix.substring(0, suffix.length() - timeUnit.getComponent().getString().length()));
        return new TimeFilter(time, timeUnit);
    }

    public String toString() {
        return "TimeFilter{time=" + this.time + "}";
    }

    public long getTime() {
        return this.time;
    }
}

