/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.repository;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.command.filter.FilterList;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.Repository;
import com.daqem.grieflogger.model.SimpleItemStack;
import com.daqem.grieflogger.model.action.ItemAction;
import com.daqem.grieflogger.model.history.ContainerHistory;
import com.daqem.grieflogger.model.history.IHistory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public class ContainerRepository
extends Repository {
    private final Database database;

    public ContainerRepository(Database database) {
        this.database = database;
    }

    @Override
    public void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS containers (\n    time integer NOT NULL,\n\tuser integer NOT NULL,\n\tlevel integer NOT NULL,\n\tx integer NOT NULL,\n\ty integer NOT NULL,\n\tz integer NOT NULL,\n\ttype integer NOT NULL,\n\tdata blob DEFAULT NULL,\n\tamount integer NOT NULL,\n\taction integer NOT NULL,\n\tFOREIGN KEY(user) REFERENCES users(id),\n\tFOREIGN KEY(level) REFERENCES levels(id),\n\tFOREIGN KEY(type) REFERENCES materials(id)\n);\n";
        if (this.isMysql()) {
            sql = "CREATE TABLE IF NOT EXISTS containers (\n    time bigint NOT NULL,\n\tuser int NOT NULL,\n\tlevel int NOT NULL,\n\tx int NOT NULL,\n\ty int NOT NULL,\n\tz int NOT NULL,\n\ttype int NOT NULL,\n\tdata blob DEFAULT NULL,\n\tamount int NOT NULL,\n\taction int NOT NULL,\n\tFOREIGN KEY(user) REFERENCES users(id),\n\tFOREIGN KEY(level) REFERENCES levels(id),\n\tFOREIGN KEY(type) REFERENCES materials(id)\n)\nENGINE=InnoDB DEFAULT CHARACTER SET utf8mb4;\n";
        }
        this.database.createTable(sql);
    }

    public void createIndexes() {
        String sql = "CREATE INDEX IF NOT EXISTS coordinates ON containers (x, y, z);\n";
        if (this.isMysql()) {
            sql = "ALTER TABLE containers ADD INDEX coordinates (x, y, z);\n";
        }
        this.database.execute(sql, false);
    }

    public void insert(long time, String userUuid, class_1937 level, int x, int y, int z, SimpleItemStack item, int itemAction) {
        if (item.isEmpty()) {
            return;
        }
        String insertMaterialQuery = "INSERT OR IGNORE INTO materials(name)\nVALUES(?);\n";
        if (this.isMysql()) {
            insertMaterialQuery = "INSERT IGNORE INTO materials(name)\nVALUES(?);\n";
        }
        String insertItemQuery = "INSERT INTO containers(time, user, level, x, y, z, type, data, amount, action)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, (\n    SELECT id FROM materials WHERE name = ?\n), ?, ?, ?);\n";
        class_2960 itemLocation = item.getItem().arch$registryName();
        if (itemLocation != null) {
            try {
                PreparedStatement itemStatement = this.database.prepareStatement(insertItemQuery);
                PreparedStatement materialStatement = this.database.prepareStatement(insertMaterialQuery);
                materialStatement.setString(1, itemLocation.toString().replace("minecraft:", ""));
                this.database.queue.add(materialStatement);
                itemStatement.setLong(1, time);
                itemStatement.setString(2, userUuid);
                itemStatement.setString(3, level.method_27983().method_29177().toString());
                itemStatement.setInt(4, x);
                itemStatement.setInt(5, y);
                itemStatement.setInt(6, z);
                itemStatement.setString(7, itemLocation.toString().replace("minecraft:", ""));
                itemStatement.setBytes(8, item.getTagBytes(level));
                itemStatement.setInt(9, item.getCount());
                itemStatement.setInt(10, itemAction);
                this.database.queue.add(itemStatement);
            }
            catch (SQLException e) {
                GriefLogger.LOGGER.error("Failed to insert item", (Throwable)e);
            }
        }
    }

    public void insertList(long time, String userUuid, class_1937 level, int x, int y, int z, List<SimpleItemStack> items, int itemAction) {
        String insertMaterialQuery = "INSERT OR IGNORE INTO materials(name)\nVALUES(?);\n";
        if (this.isMysql()) {
            insertMaterialQuery = "INSERT IGNORE INTO materials(name)\nVALUES(?);\n";
        }
        String insertItemQuery = "INSERT INTO containers(time, user, level, x, y, z, type, data, amount, action)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, (\n    SELECT id FROM materials WHERE name = ?\n), ?, ?, ?);\n";
        try {
            PreparedStatement itemStatement = this.database.prepareStatement(insertItemQuery);
            PreparedStatement materialStatement = this.database.prepareStatement(insertMaterialQuery);
            for (SimpleItemStack item : items) {
                class_2960 itemLocation;
                if (item.isEmpty() || (itemLocation = item.getItem().arch$registryName()) == null) continue;
                materialStatement.setString(1, itemLocation.toString().replace("minecraft:", ""));
                materialStatement.addBatch();
                itemStatement.setLong(1, time);
                itemStatement.setString(2, userUuid);
                itemStatement.setString(3, level.method_27983().method_29177().toString());
                itemStatement.setInt(4, x);
                itemStatement.setInt(5, y);
                itemStatement.setInt(6, z);
                itemStatement.setString(7, itemLocation.toString().replace("minecraft:", ""));
                itemStatement.setBytes(8, item.getTagBytes(level));
                itemStatement.setInt(9, item.getCount());
                itemStatement.setInt(10, itemAction);
                itemStatement.addBatch();
            }
            this.database.batchQueue.add(materialStatement);
            this.database.batchQueue.add(itemStatement);
        }
        catch (SQLException e) {
            GriefLogger.LOGGER.error("Failed to insert item", (Throwable)e);
        }
    }

    public void insertMap(long time, String userUuid, class_1937 level, int x, int y, int z, Map<ItemAction, List<SimpleItemStack>> itemsMap) {
        String insertMaterialQuery = "INSERT OR IGNORE INTO materials(name)\nVALUES(?);\n";
        if (this.isMysql()) {
            insertMaterialQuery = "INSERT IGNORE INTO materials(name)\nVALUES(?);\n";
        }
        String insertItemQuery = "INSERT INTO containers(time, user, level, x, y, z, type, data, amount, action)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, (\n    SELECT id FROM materials WHERE name = ?\n), ?, ?, ?);\n";
        try {
            PreparedStatement itemStatement = this.database.prepareStatement(insertItemQuery);
            PreparedStatement materialStatement = this.database.prepareStatement(insertMaterialQuery);
            for (Map.Entry<ItemAction, List<SimpleItemStack>> entry : itemsMap.entrySet()) {
                for (SimpleItemStack item : entry.getValue()) {
                    class_2960 itemLocation;
                    if (item.isEmpty() || (itemLocation = item.getItem().arch$registryName()) == null) continue;
                    materialStatement.setString(1, itemLocation.toString().replace("minecraft:", ""));
                    materialStatement.addBatch();
                    itemStatement.setLong(1, time);
                    itemStatement.setString(2, userUuid);
                    itemStatement.setString(3, level.method_27983().method_29177().toString());
                    itemStatement.setInt(4, x);
                    itemStatement.setInt(5, y);
                    itemStatement.setInt(6, z);
                    itemStatement.setString(7, itemLocation.toString().replace("minecraft:", ""));
                    itemStatement.setBytes(8, item.getTagBytes(level));
                    itemStatement.setInt(9, item.getCount());
                    itemStatement.setInt(10, entry.getKey().getId());
                    itemStatement.addBatch();
                }
            }
            this.database.batchQueue.add(materialStatement);
            this.database.batchQueue.add(itemStatement);
        }
        catch (SQLException e) {
            GriefLogger.LOGGER.error("Failed to insert item", (Throwable)e);
        }
    }

    public List<IHistory> getHistory(class_1937 level, int x, int y, int z) {
        ArrayList<IHistory> containerHistory = new ArrayList<IHistory>();
        String query = "SELECT containers.time, users.name, users.uuid, containers.x, containers.y, containers.z, materials.name, containers.data, containers.amount, containers.action\nFROM containers\nINNER JOIN users ON containers.user = users.id\nINNER JOIN levels ON containers.level = (\n    SELECT id FROM levels WHERE name = ?\n)\nINNER JOIN materials ON containers.type = materials.id\nWHERE containers.level = levels.id AND containers.x = ? AND containers.y = ? AND containers.z = ? AND (containers.action = 0 OR containers.action = 1)\nORDER BY containers.time DESC\n";
        try (PreparedStatement preparedStatement = this.database.prepareStatement(query);){
            preparedStatement.setString(1, level.method_27983().method_29177().toString());
            preparedStatement.setInt(2, x);
            preparedStatement.setInt(3, y);
            preparedStatement.setInt(4, z);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ByteBuf buf1 = Unpooled.wrappedBuffer((byte[])resultSet.getBytes(8));
                class_9129 buf = new class_9129(buf1, level.method_30349());
                class_9326 patch = (class_9326)class_9326.field_49590.decode((Object)buf);
                containerHistory.add(new ContainerHistory(resultSet.getLong(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4), resultSet.getInt(5), resultSet.getInt(6), resultSet.getString(7), patch, resultSet.getInt(9), resultSet.getInt(10)));
            }
        }
        catch (SQLException e) {
            GriefLogger.LOGGER.error("Failed to get container history", (Throwable)e);
        }
        return containerHistory;
    }

    public List<IHistory> getHistory(class_1937 level, int x, int y, int z, int x2, int y2, int z2) {
        ArrayList<IHistory> containerHistory = new ArrayList<IHistory>();
        String query = "SELECT containers.time, users.name, users.uuid, containers.x, containers.y, containers.z, materials.name, containers.data, containers.amount, containers.action\nFROM containers\nINNER JOIN users ON containers.user = users.id\nINNER JOIN levels ON containers.level = (\n    SELECT id FROM levels WHERE name = ?\n)\nINNER JOIN materials ON containers.type = materials.id\nWHERE containers.level = levels.id AND containers.x BETWEEN ? AND ? AND containers.y BETWEEN ? AND ? AND containers.z BETWEEN ? AND ? AND (containers.action = 0 OR containers.action = 1)\nORDER BY containers.time DESC\n";
        try (PreparedStatement preparedStatement = this.database.prepareStatement(query);){
            preparedStatement.setString(1, level.method_27983().method_29177().toString());
            preparedStatement.setInt(2, x);
            preparedStatement.setInt(3, x2);
            preparedStatement.setInt(4, y);
            preparedStatement.setInt(5, y2);
            preparedStatement.setInt(6, z);
            preparedStatement.setInt(7, z2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ByteBuf buf1 = Unpooled.wrappedBuffer((byte[])resultSet.getBytes(8));
                class_9129 buf = new class_9129(buf1, level.method_30349());
                class_9326 patch = (class_9326)class_9326.field_49590.decode((Object)buf);
                containerHistory.add(new ContainerHistory(resultSet.getLong(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4), resultSet.getInt(5), resultSet.getInt(6), resultSet.getString(7), patch, resultSet.getInt(9), resultSet.getInt(10)));
            }
        }
        catch (SQLException e) {
            GriefLogger.LOGGER.error("Failed to get container history", (Throwable)e);
        }
        return containerHistory;
    }

    public List<IHistory> getFilteredContainerHistory(class_1937 level, FilterList filterList) {
        ArrayList<IHistory> arrayList;
        block17: {
            @Nullable String actions = filterList.getActionString();
            @Nullable String users = filterList.getUserString();
            @Nullable String includeMaterials = filterList.getIncludeMaterialsString();
            @Nullable String excludeMaterials = filterList.getExcludeMaterialsString();
            String query = "SELECT containers.time, users.name, users.uuid, containers.x, containers.y, containers.z, materials.name, containers.data, containers.amount, containers.action\nFROM containers\nINNER JOIN users ON containers.user = users.id\nINNER JOIN levels ON containers.level = levels.id\nINNER JOIN materials ON containers.type = materials.id\nWHERE levels.name = ?\nAND containers.time > ?\nAND (? IS NULL OR containers.action IN (%s))\nAND (? IS NULL OR users.id IN (%s))\nAND (? IS NULL OR materials.name IN ('%s'))\nAND (? IS NULL OR materials.name NOT IN ('%s'))\nAND containers.x BETWEEN ? AND ?\nAND containers.y BETWEEN ? AND ?\nAND containers.z BETWEEN ? AND ?\nORDER BY containers.time DESC\nLIMIT 1000;\n".formatted(actions, users, includeMaterials, excludeMaterials);
            PreparedStatement preparedStatement = this.database.prepareStatement(query);
            try {
                preparedStatement.setString(1, level.method_27983().method_29177().toString());
                preparedStatement.setLong(2, filterList.getTime());
                if (actions == null || actions.isEmpty()) {
                    preparedStatement.setNull(3, 12);
                } else {
                    preparedStatement.setString(3, "not null");
                }
                if (users == null || users.isEmpty()) {
                    preparedStatement.setNull(4, 12);
                } else {
                    preparedStatement.setString(4, "not null");
                }
                if (includeMaterials == null || includeMaterials.isEmpty()) {
                    preparedStatement.setNull(5, 12);
                } else {
                    preparedStatement.setString(5, "not null");
                }
                if (excludeMaterials == null || excludeMaterials.isEmpty()) {
                    preparedStatement.setNull(6, 12);
                } else {
                    preparedStatement.setString(6, "not null");
                }
                preparedStatement.setInt(7, filterList.getRadiusMinX());
                preparedStatement.setInt(8, filterList.getRadiusMaxX());
                preparedStatement.setInt(9, filterList.getRadiusMinY());
                preparedStatement.setInt(10, filterList.getRadiusMaxY());
                preparedStatement.setInt(11, filterList.getRadiusMinZ());
                preparedStatement.setInt(12, filterList.getRadiusMaxZ());
                ArrayList<IHistory> blockHistory = new ArrayList<IHistory>();
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    ByteBuf buf1 = Unpooled.wrappedBuffer((byte[])resultSet.getBytes(8));
                    class_9129 buf = new class_9129(buf1, level.method_30349());
                    class_9326 patch = (class_9326)class_9326.field_49590.decode((Object)buf);
                    blockHistory.add(new ContainerHistory(resultSet.getLong(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4), resultSet.getInt(5), resultSet.getInt(6), resultSet.getString(7), patch, resultSet.getInt(9), resultSet.getInt(10)));
                }
                arrayList = blockHistory;
                if (preparedStatement == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    GriefLogger.LOGGER.error("Failed to get block history from database", (Throwable)exception);
                    return List.of();
                }
            }
            preparedStatement.close();
        }
        return arrayList;
    }
}

