/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.service;

import com.daqem.grieflogger.command.filter.FilterList;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.BlockRepository;
import com.daqem.grieflogger.model.action.BlockAction;
import com.daqem.grieflogger.model.history.IHistory;
import com.daqem.grieflogger.thread.OnComplete;
import com.daqem.grieflogger.thread.ThreadManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class BlockService {
    private final BlockRepository blockRepository;

    public BlockService(Database database) {
        this.blockRepository = new BlockRepository(database);
    }

    public void createTable() {
        this.blockRepository.createTable();
    }

    public void createIndexes() {
        this.blockRepository.createIndexes();
    }

    public void insertMaterial(UUID userUuid, String levelName, class_2338 pos, String material, BlockAction blockAction) {
        material = material.replace("minecraft:", "");
        this.blockRepository.insertMaterial(System.currentTimeMillis(), userUuid.toString(), levelName, pos.method_10263(), pos.method_10264(), pos.method_10260(), material, blockAction.getId());
    }

    public void insertEntity(UUID userUuid, String levelName, class_2338 pos, String entity, BlockAction blockAction) {
        entity = entity.replace("minecraft:", "");
        this.blockRepository.insertEntity(System.currentTimeMillis(), userUuid.toString(), levelName, pos.method_10263(), pos.method_10264(), pos.method_10260(), entity, blockAction.getId());
    }

    public List<IHistory> getBlockHistory(class_1937 level, class_2338 pos) {
        return this.blockRepository.getBlockHistory(level.method_27983().method_29177().toString(), pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public void getBlockHistoryAsync(class_1937 level, class_2338 pos, OnComplete<List<IHistory>> onComplete) {
        ThreadManager.submit(() -> this.getBlockHistory(level, pos), onComplete);
    }

    public List<IHistory> getBlockHistory(class_1937 level, List<class_2338> pos) {
        ArrayList<IHistory> blockHistories = new ArrayList<IHistory>();
        for (class_2338 blockPos : pos) {
            blockHistories.addAll(this.getBlockHistory(level, blockPos));
        }
        return blockHistories.stream().sorted((o1, o2) -> (int)(o2.getTime().time() - o1.getTime().time())).toList();
    }

    public void getBlockHistoryAsync(class_1937 level, List<class_2338> pos, OnComplete<List<IHistory>> onComplete) {
        ThreadManager.submit(() -> this.getBlockHistory(level, pos), onComplete);
    }

    public List<IHistory> getInteractionHistory(class_1937 level, class_2338 pos) {
        return this.blockRepository.getInteractionHistory(level.method_27983().method_29177().toString(), pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public List<IHistory> getInteractionHistory(class_1937 level, List<class_2338> pos) {
        ArrayList<IHistory> blockHistories = new ArrayList<IHistory>();
        for (class_2338 blockPos : pos) {
            blockHistories.addAll(this.getInteractionHistory(level, blockPos));
        }
        return blockHistories.stream().sorted((o1, o2) -> (int)(o2.getTime().time() - o1.getTime().time())).toList();
    }

    public void getInteractionHistoryAsync(class_1937 level, List<class_2338> pos, OnComplete<List<IHistory>> onComplete) {
        ThreadManager.submit(() -> this.getInteractionHistory(level, pos), onComplete);
    }

    public void removeInteractionsForPosition(class_1937 level, class_2338 secondPos) {
        this.blockRepository.removeInteractionsForPosition(level.method_27983().method_29177().toString(), secondPos.method_10263(), secondPos.method_10264(), secondPos.method_10260());
    }

    public List<IHistory> getFilteredBlockHistory(class_1937 level, FilterList filterList) {
        return this.blockRepository.getFilteredBlockHistory(level.method_27983().method_29177().toString(), filterList);
    }
}

