/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.mixin;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.block.container.ContainerHandler;
import com.daqem.grieflogger.block.container.ContainerTransactionManager;
import com.daqem.grieflogger.block.container.ContainersTransactionManager;
import com.daqem.grieflogger.block.container.IContainerTransactionManager;
import com.daqem.grieflogger.command.page.Page;
import com.daqem.grieflogger.database.service.Services;
import com.daqem.grieflogger.event.item.DropItemEvent;
import com.daqem.grieflogger.model.SimpleItemStack;
import com.daqem.grieflogger.model.action.ItemAction;
import com.daqem.grieflogger.model.history.IHistory;
import com.daqem.grieflogger.player.GriefLoggerServerPlayer;
import com.mojang.authlib.GameProfile;
import dev.architectury.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2624;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class MixinServerPlayer
extends class_1657
implements GriefLoggerServerPlayer {
    @Unique
    private boolean grieflogger$inspecting = false;
    @Unique
    private IContainerTransactionManager grieflogger$containerTransactionManager;
    @Unique
    private final Map<ItemAction, List<SimpleItemStack>> grieflogger$itemQueue = new HashMap<ItemAction, List<SimpleItemStack>>();
    @Unique
    private final List<Page> grieflogger$pages = new ArrayList<Page>();

    public MixinServerPlayer(class_1937 level, class_2338 blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Override
    @Unique
    public boolean grieflogger$isInspecting() {
        return this.grieflogger$inspecting;
    }

    @Override
    @Unique
    public void grieflogger$setInspecting(boolean inspecting) {
        this.grieflogger$inspecting = inspecting;
    }

    @Override
    @Unique
    public void grieflogger$sendInspectMessage(List<IHistory> historyList) {
        if (historyList.isEmpty()) {
            MixinServerPlayer mixinServerPlayer = this;
            if (mixinServerPlayer instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)mixinServerPlayer;
                serverPlayer.method_64398((class_2561)GriefLogger.translate("lookup.no_history", GriefLogger.getName()));
            }
        } else {
            List<Page> pages = Page.convertToPages(historyList, true);
            this.grieflogger$setPages(pages);
            Page pageToDisplay = pages.getFirst();
            pageToDisplay.sendToPlayer(this.grieflogger$asServerPlayer());
        }
    }

    @Override
    @Unique
    public class_3222 grieflogger$asServerPlayer() {
        return (class_3222)this;
    }

    @Override
    public List<Page> grieflogger$getPages() {
        return this.grieflogger$pages;
    }

    @Override
    public void grieflogger$setPages(List<Page> pages) {
        this.grieflogger$pages.clear();
        this.grieflogger$pages.addAll(pages);
    }

    @Inject(at={@At(value="HEAD")}, method={"openMenu"})
    public void openMenu(class_3908 menuProvider, CallbackInfoReturnable<OptionalInt> cir) {
        EnvExecutor.getInEnv((EnvType)EnvType.SERVER, () -> () -> {
            Optional<class_2624> container = ContainerHandler.getContainer(menuProvider);
            if (container.isPresent()) {
                this.grieflogger$containerTransactionManager = new ContainerTransactionManager(container.get());
            } else {
                ContainerHandler.getContainers(menuProvider).ifPresent(containers -> {
                    this.grieflogger$containerTransactionManager = new ContainersTransactionManager((List<class_2624>)containers);
                });
            }
            return null;
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"doCloseContainer()V"})
    public void grieflogger$doCloseContainer(CallbackInfo ci) {
        EnvExecutor.getInEnv((EnvType)EnvType.SERVER, () -> () -> {
            if (this.grieflogger$containerTransactionManager != null) {
                this.grieflogger$containerTransactionManager.finalize(this.grieflogger$asServerPlayer());
                this.grieflogger$containerTransactionManager = null;
            }
            return null;
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void grieflogger$tick(CallbackInfo ci) {
        EnvExecutor.getInEnv((EnvType)EnvType.SERVER, () -> () -> {
            if (!this.grieflogger$itemQueue.isEmpty()) {
                Services.ITEM.insertMap(this.method_5667(), this.method_37908(), this.method_24515(), new HashMap<ItemAction, List<SimpleItemStack>>(this.grieflogger$itemQueue));
                this.grieflogger$itemQueue.clear();
            }
            return null;
        });
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="RETURN")})
    private void drop(class_1799 itemStack, boolean bl, boolean bl2, CallbackInfoReturnable<class_1542> cir) {
        EnvExecutor.getInEnv((EnvType)EnvType.SERVER, () -> () -> {
            if (cir.getReturnValue() != null) {
                DropItemEvent.onDropItem(this, (class_1542)cir.getReturnValue());
            }
            return null;
        });
    }

    @Override
    public void griefLogger$addItemToQueue(ItemAction action, SimpleItemStack itemStack) {
        List<SimpleItemStack> itemStacks = this.grieflogger$itemQueue.get(action);
        if (itemStacks != null) {
            SimpleItemStack existingItemStack = itemStacks.stream().filter(itemStack::equals).findFirst().orElse(null);
            if (existingItemStack != null) {
                existingItemStack.setCount(existingItemStack.getCount() + itemStack.getCount());
                return;
            }
        }
        this.grieflogger$itemQueue.computeIfAbsent(action, k -> new ArrayList()).add(itemStack);
    }
}

