/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.block.container;

import com.daqem.grieflogger.block.container.IContainerTransactionManager;
import com.daqem.grieflogger.database.service.Services;
import com.daqem.grieflogger.model.SimpleItemStack;
import com.daqem.grieflogger.model.action.ItemAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2624;
import net.minecraft.class_3222;

public class ContainerTransactionManager
implements IContainerTransactionManager {
    private final class_2624 blockEntity;
    private final List<SimpleItemStack> initialItems = new ArrayList<SimpleItemStack>();
    private final List<SimpleItemStack> finalItems = new ArrayList<SimpleItemStack>();

    public ContainerTransactionManager(class_2624 blockEntity) {
        this.blockEntity = blockEntity;
        for (int i = 0; i < blockEntity.method_5439(); ++i) {
            this.addItem(blockEntity.method_5438(i), this.initialItems);
        }
    }

    @Override
    public void finalize(class_3222 serverPlayer) {
        this.constructFinalItems();
        List<SimpleItemStack> removedItems = this.getRemovedItems();
        List<SimpleItemStack> addedItems = this.getAddedItems();
        Services.CONTAINER.insertMap(serverPlayer.method_5667(), this.blockEntity.method_10997() != null ? this.blockEntity.method_10997() : serverPlayer.method_37908(), this.blockEntity.method_11016(), Map.of(ItemAction.REMOVE_ITEM, removedItems, ItemAction.ADD_ITEM, addedItems));
    }

    private void constructFinalItems() {
        for (int i = 0; i < this.blockEntity.method_5439(); ++i) {
            this.addItem(this.blockEntity.method_5438(i), this.finalItems);
        }
    }

    private List<SimpleItemStack> getRemovedItems() {
        return new ArrayList<SimpleItemStack>(this.getDifference(this.initialItems, this.finalItems));
    }

    private List<SimpleItemStack> getDifference(List<SimpleItemStack> x, List<SimpleItemStack> y) {
        ArrayList<SimpleItemStack> difference = new ArrayList<SimpleItemStack>();
        for (SimpleItemStack xItem : x) {
            y.stream().filter(xItem::equals).findFirst().ifPresentOrElse(yItem -> {
                if (yItem.getCount() < xItem.getCount()) {
                    difference.add(new SimpleItemStack(xItem.getItem(), xItem.getCount() - yItem.getCount(), xItem.getTag()));
                }
            }, () -> difference.add(xItem));
        }
        return difference;
    }

    private List<SimpleItemStack> getAddedItems() {
        return new ArrayList<SimpleItemStack>(this.getDifference(this.finalItems, this.initialItems));
    }

    private void addItem(class_1799 itemStack, List<SimpleItemStack> itemStackList) {
        if (itemStack.method_7909().equals(class_1802.field_8162)) {
            return;
        }
        if (itemStack.method_7947() == 0) {
            return;
        }
        for (SimpleItemStack simpleItemStack : itemStackList) {
            if (simpleItemStack.getItem() != itemStack.method_7909()) continue;
            if (simpleItemStack.hasTag() && !itemStack.method_57380().method_57848() && simpleItemStack.getTag().equals((Object)itemStack.method_57380())) {
                simpleItemStack.addCount(itemStack.method_7947());
                return;
            }
            if (!simpleItemStack.hasNoTag() || !itemStack.method_57380().method_57848()) continue;
            simpleItemStack.addCount(itemStack.method_7947());
            return;
        }
        itemStackList.add(new SimpleItemStack(itemStack));
    }
}

