/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.command.filter;

import com.daqem.grieflogger.command.filter.ActionFilter;
import com.daqem.grieflogger.command.filter.ExcludeFilter;
import com.daqem.grieflogger.command.filter.IFilter;
import com.daqem.grieflogger.command.filter.IncludeFilter;
import com.daqem.grieflogger.command.filter.ItemFilter;
import com.daqem.grieflogger.command.filter.RadiusFilter;
import com.daqem.grieflogger.command.filter.TimeFilter;
import com.daqem.grieflogger.command.filter.UserFilter;
import java.util.List;

public interface Filters {
    public static final IFilter ACTION = new ActionFilter();
    public static final IFilter EXCLUDE = new ExcludeFilter();
    public static final IFilter INCLUDE = new IncludeFilter();
    public static final IFilter RADIUS = new RadiusFilter();
    public static final IFilter TIME = new TimeFilter();
    public static final IFilter USER = new UserFilter();
    public static final List<IFilter> FILTERS = List.of(ACTION, EXCLUDE, INCLUDE, RADIUS, TIME, USER);

    public static IFilter fromPrefix(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return null;
        }
        if (prefix.length() == 1) {
            return FILTERS.stream().filter(x -> x.getPrefix() == prefix.charAt(0)).findFirst().orElse(null);
        }
        return FILTERS.stream().filter(x -> x.getName().toLowerCase().startsWith(prefix)).findFirst().orElse(null);
    }

    public static String[] getFilteredSuggestions(List<IFilter> filters, boolean hasItemFilter) {
        return (String[])FILTERS.stream().filter(x -> !hasItemFilter || !(x instanceof ItemFilter)).filter(x -> filters.stream().noneMatch(y -> y.getClass() == x.getClass())).map(x -> x.getName() + ".").toArray(String[]::new);
    }
}

