/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.command.page;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.model.history.IHistory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class Page {
    public static final int MAX_PAGE_SIZE = 10;
    private final List<IHistory> history;
    private final int page;
    private final int maxPage;
    private final boolean singleLocation;

    public Page(List<IHistory> history, int page, int maxPage, boolean singleLocation) {
        this.history = history;
        this.page = page;
        this.maxPage = maxPage;
        this.singleLocation = singleLocation;
    }

    public List<class_2561> getHistory() {
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        components.add(this.getHeader());
        for (IHistory history : this.history) {
            if (this.singleLocation) {
                components.add(history.getComponent());
                continue;
            }
            components.add(history.getComponentWithPos());
        }
        if (this.maxPage > 1) {
            components.add(this.getFooter());
        }
        return components;
    }

    private class_2561 getHeader() {
        class_5250 header = GriefLogger.translate("lookup.history_header", GriefLogger.themedTranslate("lookup.history_title"));
        if (this.singleLocation && !this.history.isEmpty()) {
            header.method_27693(" ").method_10852(this.history.get(0).getPosition().getComponent());
        }
        return header;
    }

    private class_2561 getFooter() {
        return this.getArrowLeft().method_27693(" ").method_10852((class_2561)GriefLogger.themedTranslate("lookup.page")).method_27693(" ").method_10852((class_2561)GriefLogger.translate("lookup.pages", this.page, this.maxPage).method_27692(class_124.field_1068)).method_27693(" ").method_10852((class_2561)this.getArrowRight());
    }

    private class_5250 getArrowLeft() {
        return GriefLogger.literal("\u2bc7").method_27696(this.getStyle(this.page - 1, this.page > 1));
    }

    private class_5250 getArrowRight() {
        return GriefLogger.literal("\u2bc8").method_27696(this.getStyle(this.page + 1, this.page < this.maxPage));
    }

    private class_2558 getClickEvent(int page) {
        return new class_2558(class_2558.class_2559.field_11750, "/grieflogger page " + page);
    }

    private class_2583 getStyle(int page, boolean enabled) {
        class_2583 style = class_2583.field_24360.method_10958(this.getClickEvent(page)).method_10977(class_124.field_1068);
        if (!enabled) {
            style = class_2583.field_24360.method_10977(class_124.field_1080);
        }
        return style;
    }

    public void sendToPlayer(class_3222 serverPlayer) {
        this.getHistory().forEach(arg_0 -> ((class_3222)serverPlayer).method_43496(arg_0));
    }

    public static List<Page> convertToPages(List<IHistory> history, boolean singleLocation) {
        ArrayList<Page> pages = new ArrayList<Page>();
        int maxPage = (int)Math.ceil((double)history.size() / 10.0);
        int page = 1;
        for (int i = 0; i < history.size(); i += 10) {
            int finalPage = page++;
            pages.add(history.subList(i, Math.min(i + 10, history.size())).stream().collect(Collectors.collectingAndThen(Collectors.toList(), x -> new Page((List<IHistory>)x, finalPage, maxPage, singleLocation))));
        }
        return pages;
    }
}

