/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.service;

import com.daqem.grieflogger.command.filter.FilterList;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.ContainerRepository;
import com.daqem.grieflogger.model.SimpleItemStack;
import com.daqem.grieflogger.model.action.ItemAction;
import com.daqem.grieflogger.model.history.IHistory;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;

public class ContainerService {
    private final ContainerRepository containerRepository;

    public ContainerService(Database database) {
        this.containerRepository = new ContainerRepository(database);
    }

    public void createTable() {
        this.containerRepository.createTable();
    }

    public void createIndexes() {
        this.containerRepository.createIndexes();
    }

    public void insert(UUID userUuid, class_1937 level, class_2338 pos, SimpleItemStack item, ItemAction itemAction) {
        class_2960 itemLocation = item.getItem().arch$registryName();
        if (itemLocation != null) {
            this.containerRepository.insert(System.currentTimeMillis(), userUuid.toString(), level, pos.method_10263(), pos.method_10264(), pos.method_10260(), item, itemAction.getId());
        }
    }

    public void insertList(UUID userUuid, class_1937 level, class_2338 pos, List<SimpleItemStack> items, ItemAction itemAction) {
        this.containerRepository.insertList(System.currentTimeMillis(), userUuid.toString(), level, pos.method_10263(), pos.method_10264(), pos.method_10260(), items, itemAction.getId());
    }

    public void insertMap(UUID userUuid, class_1937 level, class_2338 pos, Map<ItemAction, List<SimpleItemStack>> itemsMap) {
        this.containerRepository.insertMap(System.currentTimeMillis(), userUuid.toString(), level, pos.method_10263(), pos.method_10264(), pos.method_10260(), itemsMap);
    }

    public List<IHistory> getHistory(class_1937 level, class_2338 pos) {
        return this.containerRepository.getHistory(level, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public List<IHistory> getHistory(class_1937 level, class_2338 pos, class_2338 connectionPos) {
        return this.containerRepository.getHistory(level, pos.method_10263(), pos.method_10264(), pos.method_10260(), connectionPos.method_10263(), connectionPos.method_10264(), connectionPos.method_10260());
    }

    public List<IHistory> getFilteredContainerHistory(class_1937 level, FilterList filterList) {
        return this.containerRepository.getFilteredContainerHistory(level, filterList);
    }
}

