/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager;

import com.alan.VillagerTradeManager.commands.VillagerTradeCommand;
import com.alan.VillagerTradeManager.database.DatabaseManager;
import com.alan.VillagerTradeManager.exception.DatabaseException;
import com.alan.VillagerTradeManager.hooks.TradeHookManager;
import com.alan.VillagerTradeManager.listeners.CustomEventListener;
import com.alan.VillagerTradeManager.listeners.VillagerTradeListener;
import com.alan.VillagerTradeManager.listeners.WanderingTraderListener;
import com.alan.VillagerTradeManager.metrics.HealthCheckService;
import com.alan.VillagerTradeManager.metrics.MetricsEndpoint;
import com.alan.VillagerTradeManager.metrics.MetricsService;
import com.alan.VillagerTradeManager.platform.PlatformService;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import com.alan.VillagerTradeManager.services.DatabaseService;
import com.alan.VillagerTradeManager.services.DynamicTradeStorageService;
import com.alan.VillagerTradeManager.services.PerformanceMonitorService;
import com.alan.VillagerTradeManager.services.ReputationService;
import com.alan.VillagerTradeManager.services.RestockService;
import com.alan.VillagerTradeManager.services.SettingsService;
import com.alan.VillagerTradeManager.services.SimpleTradeMapper;
import com.alan.VillagerTradeManager.services.StockService;
import com.alan.VillagerTradeManager.services.TradeCompletionService;
import com.alan.VillagerTradeManager.services.TradeEnhancementService;
import com.alan.VillagerTradeManager.services.TradeRegistry;
import com.alan.VillagerTradeManager.services.TradeService;
import com.alan.VillagerTradeManager.services.VillagerLevelService;
import com.alan.VillagerTradeManager.services.WanderingTraderService;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class VillagerTradeManager
extends JavaPlugin {
    private PlatformService platformService;
    private TaskScheduler taskScheduler;
    private DatabaseManager databaseManager;
    private DatabaseService databaseService;
    private TradeService tradeService;
    private RestockService restockService;
    private StockService stockService;
    private SettingsService settingsService;
    private DynamicTradeStorageService dynamicTradeStorageService;
    private TradeCompletionService tradeCompletionService;
    private PerformanceMonitorService performanceMonitorService;
    private VillagerLevelService villagerLevelService;
    private ReputationService reputationService;
    private TradeHookManager tradeHookManager;
    private TradeEnhancementService tradeEnhancementService;
    private WanderingTraderService wanderingTraderService;
    private CustomEventListener customEventListener;
    private MetricsService metricsService;
    private HealthCheckService healthCheckService;
    private MetricsEndpoint metricsEndpoint;
    private File pricesFile;

    public void onEnable() {
        TradeRegistry.initialize();
        SimpleTradeMapper.initialize();
        this.initializePlatform();
        this.initializeConfiguration();
        this.initializeDatabaseSystems();
        this.initializeCoreServices();
        this.initializeDynamicTradeServices();
        this.initializeBusinessServices();
        this.initializeMetricsAndMonitoring();
        this.loadPluginData();
        this.registerEventHandlers();
        this.registerCommands();
        this.startMonitoringTasks();
        this.logStartupComplete();
    }

    private void initializePlatform() {
        this.platformService = new PlatformService((Plugin)this);
        this.taskScheduler = this.platformService.getScheduler();
    }

    private void initializeConfiguration() {
        this.pricesFile = new File(this.getDataFolder(), "prices.dat");
        this.getDataFolder().mkdirs();
        this.saveDefaultConfig();
        this.reloadConfig();
    }

    private void initializeDatabaseSystems() {
        try {
            this.databaseManager = new DatabaseManager((Plugin)this);
            this.databaseManager.initialize(this.getConfig().getConfigurationSection("database"));
            this.databaseService = new DatabaseService(this, this.databaseManager.getProvider());
            this.settingsService = new SettingsService(this, this.databaseService);
            if (this.getConfig().getBoolean("logging.startup_verbose", false)) {
                this.getLogger().info("Database system initialized successfully");
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize database system: " + e.getMessage());
        }
        this.initializeSchema();
    }

    private void initializeCoreServices() {
        this.performanceMonitorService = new PerformanceMonitorService(this, this.taskScheduler);
        if (this.getConfig().getBoolean("logging.startup_verbose", false)) {
            this.getLogger().info("Performance monitoring service initialized successfully");
        }
    }

    private void initializeDynamicTradeServices() {
        try {
            this.dynamicTradeStorageService = new DynamicTradeStorageService(this, this.databaseManager.getProvider(), this.databaseService);
            this.tradeCompletionService = new TradeCompletionService(this, new TradeRegistry(), new SimpleTradeMapper(), this.dynamicTradeStorageService);
            this.tradeCompletionService.refreshCache();
            if (this.getConfig().getBoolean("logging.startup_verbose", false)) {
                this.getLogger().info("Dynamic Trade Detection services initialized successfully");
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize Dynamic Trade Detection services: " + e.getMessage());
            this.getLogger().severe("Plugin will continue with basic functionality only");
        }
    }

    private void initializeBusinessServices() {
        this.stockService = new StockService(this, this.databaseService, this.settingsService);
        this.reputationService = new ReputationService(this, this.databaseService);
        this.tradeHookManager = new TradeHookManager(this);
        this.tradeService = new TradeService(this, this.settingsService, this.dynamicTradeStorageService, this.performanceMonitorService, this.stockService, this.reputationService, this.taskScheduler);
        this.restockService = new RestockService(this, this.databaseService, this.settingsService);
        this.villagerLevelService = new VillagerLevelService(this, this.databaseService, this.taskScheduler);
        this.tradeEnhancementService = new TradeEnhancementService(this, this.databaseService, this.settingsService, this.reputationService, this.tradeService);
        this.wanderingTraderService = new WanderingTraderService(this, this.databaseService, this.taskScheduler);
        this.customEventListener = new CustomEventListener(this);
    }

    private void initializeMetricsAndMonitoring() {
        try {
            this.metricsService = new MetricsService(this);
            this.healthCheckService = new HealthCheckService(this, this.metricsService);
            this.metricsEndpoint = new MetricsEndpoint(this, this.metricsService, this.healthCheckService);
            this.metricsEndpoint.initialize();
            if (this.getConfig().getBoolean("logging.startup_verbose", false)) {
                this.getLogger().info("V11 Enterprise metrics and monitoring initialized successfully");
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to initialize V11 enterprise features: " + e.getMessage());
            this.getLogger().severe("Plugin will continue without metrics and monitoring");
        }
    }

    private void loadPluginData() {
        this.loadCustomPricesFromFile();
    }

    private void registerEventHandlers() {
        this.getServer().getPluginManager().registerEvents((Listener)new VillagerTradeListener(this, this.tradeService, this.restockService, this.platformService, this.reputationService), (Plugin)this);
        if (this.customEventListener != null) {
            this.getServer().getPluginManager().registerEvents((Listener)this.customEventListener, (Plugin)this);
        }
        if (this.wanderingTraderService != null) {
            this.getServer().getPluginManager().registerEvents((Listener)new WanderingTraderListener(this, this.wanderingTraderService, this.taskScheduler), (Plugin)this);
        }
    }

    private void registerCommands() {
        this.getCommand("vtrade").setExecutor((CommandExecutor)new VillagerTradeCommand(this, this.settingsService, this.tradeService, this.restockService, this.taskScheduler));
        this.getCommand("vtrade").setTabCompleter((TabCompleter)new VillagerTradeCommand(this, this.settingsService, this.tradeService, this.restockService, this.taskScheduler));
    }

    private void startMonitoringTasks() {
        this.startTradeMonitor();
        this.startRestockMonitor();
        this.startStockRestockMonitor();
        this.startDynamicTradeCacheCleanup();
        this.startDynamicTradeCacheCleanup();
    }

    private void startDynamicTradeCacheCleanup() {
        if (this.tradeService != null && this.tradeService.getDynamicTradeDetector() != null) {
            this.taskScheduler.runAsyncRepeating(() -> {
                try {
                    this.tradeService.getDynamicTradeDetector().cleanupExpiredCache();
                    if (this.getConfig().getBoolean("logging.cache_cleanup", false)) {
                        this.getLogger().info("Dynamic trade cache cleanup completed");
                    }
                }
                catch (Exception e) {
                    this.getLogger().warning("Error during dynamic trade cache cleanup: " + e.getMessage());
                }
            }, 36000L, 36000L);
        }
    }

    private void logStartupComplete() {
        if (this.getConfig().getBoolean("logging.startup_verbose", false)) {
            this.getLogger().info("Minecraft Villager Trade Manager plugin enabled!");
            this.getLogger().info("Complete control over villager trading economics.");
            this.getLogger().info("Compatible with Minecraft versions 1.20.x - 1.21.x");
            this.getLogger().info("Platform: " + String.valueOf((Object)this.platformService.getDetectedPlatform()) + " | Scheduler: " + this.taskScheduler.getSchedulerName());
        }
    }

    public void onDisable() {
        this.getLogger().info("Minecraft Villager Trade Manager plugin disabling...");
        if (this.taskScheduler != null) {
            this.taskScheduler.cancelAllTasks();
        }
        if (this.tradeService != null) {
            this.tradeService.shutdown();
        }
        if (this.restockService != null) {
            this.restockService.shutdown();
        }
        if (this.stockService != null) {
            this.stockService.shutdown();
        }
        if (this.villagerLevelService != null) {
            this.villagerLevelService.cleanupCache();
        }
        TradeRegistry.clearAllStaticReferences();
        SimpleTradeMapper.clearAllStaticReferences();
        if (this.metricsEndpoint != null) {
            this.metricsEndpoint.shutdown();
        }
        if (this.tradeEnhancementService != null) {
            this.tradeEnhancementService.shutdown();
        }
        if (this.tradeService != null) {
            this.saveCustomPricesToFile();
        }
        this.getLogger().info("Minecraft Villager Trade Manager plugin disabled successfully!");
    }

    private void initializeSchema() {
        try {
            this.databaseService.executeUpdate("CREATE TABLE IF NOT EXISTS settings (key TEXT PRIMARY KEY, value TEXT)", null, "initializeSchema");
            this.databaseService.executeUpdate("CREATE TABLE IF NOT EXISTS custom_prices (item_key TEXT PRIMARY KEY, price INTEGER NOT NULL)", null, "initializeSchema");
            this.databaseService.executeUpdate("CREATE TABLE IF NOT EXISTS villager_restock_data (villager_uuid TEXT PRIMARY KEY, last_restock_time INTEGER, restock_count_today INTEGER, last_reset_day INTEGER)", null, "initializeSchema");
            this.databaseService.executeUpdate("CREATE TABLE IF NOT EXISTS villager_progression (villager_uuid TEXT PRIMARY KEY, current_xp INTEGER NOT NULL DEFAULT 0, current_level INTEGER NOT NULL DEFAULT 1, total_xp_earned INTEGER NOT NULL DEFAULT 0, profession TEXT, last_updated INTEGER NOT NULL DEFAULT 0, created_at INTEGER NOT NULL DEFAULT 0)", null, "initializeSchema");
            this.databaseService.executeUpdate("CREATE INDEX IF NOT EXISTS idx_villager_progression_level ON villager_progression(current_level)", null, "initializeSchema");
            this.databaseService.executeUpdate("CREATE INDEX IF NOT EXISTS idx_villager_progression_profession ON villager_progression(profession)", null, "initializeSchema");
            this.databaseService.executeUpdate("DROP TABLE IF EXISTS dynamic_trades", null, "initializeSchema");
            this.databaseService.executeUpdate("CREATE TABLE IF NOT EXISTS dynamic_trades (trade_id TEXT PRIMARY KEY, profession TEXT, level INTEGER, input_item TEXT, input_amount INTEGER, output_item TEXT, output_amount INTEGER, simple_name TEXT, detected_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, last_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP, custom_price INTEGER)", null, "initializeSchema");
            this.databaseService.executeUpdate("CREATE INDEX IF NOT EXISTS idx_dynamic_trades_profession ON dynamic_trades(profession)", null, "initializeSchema");
            this.databaseService.executeUpdate("CREATE TABLE IF NOT EXISTS wandering_trader_trades (trade_id TEXT PRIMARY KEY, item_type TEXT NOT NULL, item_quantity INTEGER NOT NULL, emerald_cost INTEGER NOT NULL, created_at INTEGER NOT NULL)", null, "initializeSchema");
            if (this.getConfig().getBoolean("logging.startup_verbose", false)) {
                this.getLogger().info("Database schema initialized successfully");
            }
        }
        catch (DatabaseException e) {
            this.getLogger().severe("Failed to initialize database schema: " + e.getMessage());
        }
    }

    private void startTradeMonitor() {
        if (this.tradeService != null) {
            this.tradeService.startTradeMonitor(this.platformService, this.taskScheduler);
        }
    }

    private void startRestockMonitor() {
        if (this.restockService != null) {
            this.restockService.startRestockMonitor(this.platformService, this.taskScheduler);
        }
    }

    private void startStockRestockMonitor() {
        if (this.stockService != null) {
            this.stockService.startRestockScheduler(this.platformService, this.taskScheduler);
        }
    }

    private void saveCustomPricesToFile() {
        block3: {
            if (this.tradeService != null) {
                try {
                    this.tradeService.saveCustomPricesToFile(this.pricesFile);
                }
                catch (DatabaseException e) {
                    this.getLogger().severe("Failed to save custom prices to file: " + e.getMessage());
                    if (e.getTableName() == null) break block3;
                    this.getLogger().severe("Table: " + e.getTableName() + " | Operation: " + e.getOperation());
                }
            }
        }
    }

    private void loadCustomPricesFromFile() {
        block3: {
            if (this.tradeService != null) {
                try {
                    this.tradeService.loadCustomPricesFromFile(this.pricesFile);
                }
                catch (DatabaseException e) {
                    this.getLogger().severe("Failed to load custom prices from file: " + e.getMessage());
                    if (e.getTableName() == null) break block3;
                    this.getLogger().severe("Table: " + e.getTableName() + " | Operation: " + e.getOperation());
                }
            }
        }
    }

    public PlatformService getPlatformService() {
        return this.platformService;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public DatabaseService getDatabaseService() {
        return this.databaseService;
    }

    public TradeService getTradeService() {
        return this.tradeService;
    }

    public RestockService getRestockService() {
        return this.restockService;
    }

    public StockService getStockService() {
        return this.stockService;
    }

    public SettingsService getSettingsService() {
        return this.settingsService;
    }

    public DynamicTradeStorageService getDynamicTradeStorageService() {
        return this.dynamicTradeStorageService;
    }

    public TradeCompletionService getTradeCompletionService() {
        return this.tradeCompletionService;
    }

    public PerformanceMonitorService getPerformanceMonitorService() {
        return this.performanceMonitorService;
    }

    public VillagerLevelService getVillagerLevelService() {
        return this.villagerLevelService;
    }

    public ReputationService getReputationService() {
        return this.reputationService;
    }

    public TradeHookManager getTradeHookManager() {
        return this.tradeHookManager;
    }

    public CustomEventListener getCustomEventListener() {
        return this.customEventListener;
    }

    public MetricsService getMetricsService() {
        return this.metricsService;
    }

    public HealthCheckService getHealthCheckService() {
        return this.healthCheckService;
    }

    public MetricsEndpoint getMetricsEndpoint() {
        return this.metricsEndpoint;
    }

    public TradeEnhancementService getTradeEnhancementService() {
        return this.tradeEnhancementService;
    }

    public WanderingTraderService getWanderingTraderService() {
        return this.wanderingTraderService;
    }

    public File getPricesFile() {
        return this.pricesFile;
    }
}

