/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.api;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.api.VillagerTradeAPI;
import com.alan.VillagerTradeManager.exception.DatabaseException;
import com.alan.VillagerTradeManager.services.VillagerLevelService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TradeManager {
    private final VillagerTradeManager plugin;

    public TradeManager(@NotNull VillagerTradeManager plugin) {
        this.plugin = plugin;
    }

    @Nullable
    public static TradeManager getInstance() {
        VillagerTradeAPI api = VillagerTradeAPI.getInstance();
        if (api == null) {
            return null;
        }
        return new TradeManager((VillagerTradeManager)Bukkit.getPluginManager().getPlugin("Minecraft-Villager-Trade-Manager"));
    }

    @NotNull
    public MerchantRecipe createCustomRecipe(@NotNull ItemStack result, @NotNull List<ItemStack> ingredients, int maxUses, boolean experienceReward, int villagerExperience) {
        return new MerchantRecipe(result, maxUses);
    }

    public void applyCustomPricing(@NotNull Villager villager, @NotNull Map<String, Double> priceMultipliers) {
        this.plugin.getTradeService().processVillagerTrades(villager);
    }

    public void resetVillagerTrades(@NotNull Villager villager) {
        this.plugin.getLogger().info("Trade reset requested for villager: " + String.valueOf(villager.getUniqueId()));
    }

    public void applyProfessionPricing(@NotNull String profession, @NotNull Map<String, Integer> prices) {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            player.getNearbyEntities(32.0, 32.0, 32.0).stream().filter(entity -> entity instanceof Villager).map(entity -> (Villager)entity).filter(villager -> this.getVillagerProfession((Villager)villager).equals(profession)).forEach(villager -> {
                for (Map.Entry entry : prices.entrySet()) {
                    String tradeKey = profession + "_" + (String)entry.getKey();
                    this.plugin.getTradeService().getCustomPrices().put(tradeKey, (Integer)entry.getValue());
                }
                this.plugin.getTradeService().processVillagerTrades((Villager)villager);
            });
        }
    }

    public void banItemGlobally(@NotNull Material material) {
        this.plugin.getSettingsService().banItem(material.name(), "API");
    }

    public void unbanItemGlobally(@NotNull Material material) {
        this.plugin.getSettingsService().unbanItem(material.name());
    }

    @NotNull
    public List<Villager> findVillagersNearby(@NotNull Location location, double radius) {
        return location.getWorld().getEntitiesByClass(Villager.class).stream().filter(villager -> villager.getLocation().distance(location) <= radius).collect(Collectors.toList());
    }

    @NotNull
    public VillagerTradeInfo getVillagerTradeInfo(@NotNull Villager villager) {
        VillagerLevelService.VillagerProgression progression = null;
        if (this.plugin.getVillagerLevelService() != null) {
            try {
                progression = this.plugin.getVillagerLevelService().getVillagerProgression(villager);
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        return new VillagerTradeInfo(villager, this.getVillagerProfession(villager), this.plugin.getTradeService().getCacheStatistics(), progression);
    }

    private String getVillagerProfession(Villager villager) {
        if (villager.getProfession() == null) {
            return "none";
        }
        try {
            return villager.getProfession().getKey().getKey().toLowerCase();
        }
        catch (Exception e) {
            return villager.getProfession().toString().toLowerCase();
        }
    }

    public static class VillagerTradeInfo {
        private final Villager villager;
        private final String profession;
        private final Map<String, Object> cacheStats;
        private final VillagerLevelService.VillagerProgression progression;

        public VillagerTradeInfo(Villager villager, String profession, Map<String, Object> cacheStats, VillagerLevelService.VillagerProgression progression) {
            this.villager = villager;
            this.profession = profession;
            this.cacheStats = cacheStats;
            this.progression = progression;
        }

        public Villager getVillager() {
            return this.villager;
        }

        public String getProfession() {
            return this.profession;
        }

        public Map<String, Object> getCacheStats() {
            return this.cacheStats;
        }

        public VillagerLevelService.VillagerProgression getProgression() {
            return this.progression;
        }

        public int getLevel() {
            return this.progression != null ? this.progression.getCurrentLevel() : 1;
        }

        public int getXP() {
            return this.progression != null ? this.progression.getCurrentXp() : 0;
        }
    }
}

