/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.api;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.hooks.LevelUpEventData;
import com.alan.VillagerTradeManager.hooks.StockEventData;
import com.alan.VillagerTradeManager.hooks.TradeEventData;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerTradeAPI {
    private static VillagerTradeAPI instance;
    private final VillagerTradeManager plugin;

    private VillagerTradeAPI(VillagerTradeManager plugin) {
        this.plugin = plugin;
    }

    @Nullable
    public static VillagerTradeAPI getInstance() {
        if (instance == null) {
            try {
                VillagerTradeManager plugin = (VillagerTradeManager)Bukkit.getPluginManager().getPlugin("Minecraft-Villager-Trade-Manager");
                if (plugin != null) {
                    instance = new VillagerTradeAPI(plugin);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return instance;
    }

    @NotNull
    public Map<String, Integer> getCustomPrices() {
        return this.plugin.getTradeService().getCustomPrices();
    }

    public void setCustomPrice(@NotNull String tradeKey, int price) {
        this.plugin.getTradeService().setCustomPrice(tradeKey, price);
    }

    public void removeCustomPrice(@NotNull String tradeKey) {
        this.plugin.getTradeService().removeCustomPrice(tradeKey);
    }

    public boolean isTradeManagementEnabled() {
        return this.plugin.getTradeService().isTradeManagementEnabled();
    }

    public int getVillagerLevel(@NotNull Villager villager) {
        try {
            return this.plugin.getVillagerLevelService().getVillagerProgression(villager).getCurrentLevel();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public int getVillagerXP(@NotNull Villager villager) {
        try {
            return this.plugin.getVillagerLevelService().getVillagerProgression(villager).getCurrentXp();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getVillagerTotalXP(@NotNull Villager villager) {
        try {
            return this.plugin.getVillagerLevelService().getVillagerProgression(villager).getTotalXpEarned();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setVillagerLevel(@NotNull Villager villager, int level) {
        try {
            this.plugin.getVillagerLevelService().setVillagerLevel(villager, level);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to set villager level: " + e.getMessage());
        }
    }

    public void awardVillagerXP(@NotNull Villager villager, int xpAmount) {
        try {
            this.plugin.getVillagerLevelService().addVillagerXp(villager, xpAmount);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to award villager XP: " + e.getMessage());
        }
    }

    public int getTradeStock(@NotNull Villager villager, @NotNull String profession, @NotNull String tradeId) {
        if (this.plugin.getStockService() == null) {
            return -1;
        }
        return this.plugin.getStockService().getCurrentStock(villager, profession, tradeId);
    }

    public void setTradeStock(@NotNull Villager villager, @NotNull String profession, @NotNull String tradeId, int stockLevel) {
        if (this.plugin.getStockService() != null) {
            this.plugin.getStockService().setMaxStock(villager, profession, tradeId, stockLevel);
        }
    }

    public boolean isTradeAvailable(@NotNull Villager villager, @NotNull String profession, @NotNull String tradeId) {
        if (this.plugin.getStockService() == null) {
            return true;
        }
        return this.plugin.getStockService().isTradeAvailable(villager, profession, tradeId);
    }

    @NotNull
    public String getPlayerReputationTier(@NotNull Player player) {
        if (this.plugin.getReputationService() == null) {
            return "neutral";
        }
        return this.plugin.getReputationService().getReputationTier(player.getUniqueId()).name().toLowerCase();
    }

    public int getPlayerReputationScore(@NotNull Player player) {
        if (this.plugin.getReputationService() == null) {
            return 0;
        }
        return this.plugin.getReputationService().getPlayerReputation(player.getUniqueId());
    }

    public void adjustPlayerReputation(@NotNull Player player, int amount) {
        if (this.plugin.getReputationService() != null) {
            this.plugin.getReputationService().addReputationPoints(player.getUniqueId(), amount);
        }
    }

    public void registerTradeHook(@NotNull Consumer<TradeEventData> hook) {
        if (this.plugin.getTradeHookManager() != null) {
            this.plugin.getTradeHookManager().registerTradeHook(hook);
        }
    }

    public void registerLevelUpHook(@NotNull Consumer<LevelUpEventData> hook) {
        if (this.plugin.getTradeHookManager() != null) {
            this.plugin.getTradeHookManager().registerLevelUpHook(hook);
        }
    }

    public void registerStockHook(@NotNull Consumer<StockEventData> hook) {
        if (this.plugin.getTradeHookManager() != null) {
            this.plugin.getTradeHookManager().registerStockHook(hook);
        }
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }

    public boolean isPluginEnabled() {
        return this.plugin.isEnabled();
    }

    @NotNull
    public Map<String, Object> getCacheStatistics() {
        return this.plugin.getTradeService().getCacheStatistics();
    }
}

