/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.cache;

import java.util.concurrent.atomic.AtomicLong;

public class CacheMetrics {
    private final AtomicLong hits = new AtomicLong(0L);
    private final AtomicLong misses = new AtomicLong(0L);
    private final AtomicLong evictions = new AtomicLong(0L);
    private final AtomicLong currentSize = new AtomicLong(0L);
    private final AtomicLong maxSize = new AtomicLong(0L);
    private final AtomicLong totalRequests = new AtomicLong(0L);
    private final AtomicLong totalHitTime = new AtomicLong(0L);
    private final AtomicLong totalMissTime = new AtomicLong(0L);
    private final AtomicLong totalEvictionTime = new AtomicLong(0L);
    private final AtomicLong estimatedMemoryUsage = new AtomicLong(0L);
    private final AtomicLong sizeAdjustments = new AtomicLong(0L);
    private final AtomicLong lastSizeAdjustment = new AtomicLong(System.currentTimeMillis());
    private volatile long lastResetTime = System.currentTimeMillis();

    public void recordHit(long accessTime) {
        this.hits.incrementAndGet();
        this.totalRequests.incrementAndGet();
        this.totalHitTime.addAndGet(accessTime);
    }

    public void recordMiss(long accessTime) {
        this.misses.incrementAndGet();
        this.totalRequests.incrementAndGet();
        this.totalMissTime.addAndGet(accessTime);
    }

    public long getHits() {
        return this.hits.get();
    }

    public long getMisses() {
        return this.misses.get();
    }

    public void recordEviction(long evictionTime) {
        this.evictions.incrementAndGet();
        this.totalEvictionTime.addAndGet(evictionTime);
    }

    public void updateSize(int newSize) {
        this.currentSize.set(newSize);
        if ((long)newSize > this.maxSize.get()) {
            this.maxSize.set(newSize);
        }
    }

    public void recordSizeAdjustment() {
        this.sizeAdjustments.incrementAndGet();
        this.lastSizeAdjustment.set(System.currentTimeMillis());
    }

    public void updateMemoryUsage(long memoryBytes) {
        this.estimatedMemoryUsage.set(memoryBytes);
    }

    public double getHitRate() {
        long total = this.totalRequests.get();
        if (total == 0L) {
            return 0.0;
        }
        return (double)this.hits.get() / (double)total * 100.0;
    }

    public double getMissRate() {
        long total = this.totalRequests.get();
        if (total == 0L) {
            return 0.0;
        }
        return (double)this.misses.get() / (double)total * 100.0;
    }

    public double getAverageHitTime() {
        long hitCount = this.hits.get();
        if (hitCount == 0L) {
            return 0.0;
        }
        return (double)this.totalHitTime.get() / (double)hitCount;
    }

    public double getAverageMissTime() {
        long missCount = this.misses.get();
        if (missCount == 0L) {
            return 0.0;
        }
        return (double)this.totalMissTime.get() / (double)missCount;
    }

    public double getAverageEvictionTime() {
        long evictionCount = this.evictions.get();
        if (evictionCount == 0L) {
            return 0.0;
        }
        return (double)this.totalEvictionTime.get() / (double)evictionCount;
    }

    public double getEvictionRate() {
        long total = this.totalRequests.get();
        if (total == 0L) {
            return 0.0;
        }
        return (double)this.evictions.get() / (double)total;
    }

    public double getUtilization() {
        long max = this.maxSize.get();
        if (max == 0L) {
            return 0.0;
        }
        return (double)this.currentSize.get() / (double)max * 100.0;
    }

    public boolean isHitRateAboveTarget(double targetPercentage) {
        return this.getHitRate() >= targetPercentage;
    }

    public CacheMetricsSnapshot getSnapshot() {
        return new CacheMetricsSnapshot(this.hits.get(), this.misses.get(), this.evictions.get(), this.currentSize.get(), this.maxSize.get(), this.totalRequests.get(), this.getHitRate(), this.getAverageHitTime(), this.getAverageMissTime(), this.getAverageEvictionTime(), this.estimatedMemoryUsage.get(), this.sizeAdjustments.get(), this.lastSizeAdjustment.get(), System.currentTimeMillis() - this.lastResetTime);
    }

    public void reset() {
        this.hits.set(0L);
        this.misses.set(0L);
        this.evictions.set(0L);
        this.totalRequests.set(0L);
        this.totalHitTime.set(0L);
        this.totalMissTime.set(0L);
        this.totalEvictionTime.set(0L);
        this.maxSize.set(this.currentSize.get());
        this.sizeAdjustments.set(0L);
        this.lastResetTime = System.currentTimeMillis();
    }

    public static class CacheMetricsSnapshot {
        public final long hits;
        public final long misses;
        public final long evictions;
        public final long currentSize;
        public final long maxSize;
        public final long totalRequests;
        public final double hitRate;
        public final double averageHitTime;
        public final double averageMissTime;
        public final double averageEvictionTime;
        public final long estimatedMemoryUsage;
        public final long sizeAdjustments;
        public final long lastSizeAdjustment;
        public final long uptimeMillis;

        public CacheMetricsSnapshot(long hits, long misses, long evictions, long currentSize, long maxSize, long totalRequests, double hitRate, double averageHitTime, double averageMissTime, double averageEvictionTime, long estimatedMemoryUsage, long sizeAdjustments, long lastSizeAdjustment, long uptimeMillis) {
            this.hits = hits;
            this.misses = misses;
            this.evictions = evictions;
            this.currentSize = currentSize;
            this.maxSize = maxSize;
            this.totalRequests = totalRequests;
            this.hitRate = hitRate;
            this.averageHitTime = averageHitTime;
            this.averageMissTime = averageMissTime;
            this.averageEvictionTime = averageEvictionTime;
            this.estimatedMemoryUsage = estimatedMemoryUsage;
            this.sizeAdjustments = sizeAdjustments;
            this.lastSizeAdjustment = lastSizeAdjustment;
            this.uptimeMillis = uptimeMillis;
        }
    }
}

