/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.commands.CommandHandler;
import com.alan.VillagerTradeManager.services.RestockService;
import com.alan.VillagerTradeManager.services.SettingsService;
import com.alan.VillagerTradeManager.services.TradeService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class AdminCommandHandler
implements CommandHandler {
    private final VillagerTradeManager plugin;
    private final TradeService tradeService;
    private final RestockService restockService;
    private final SettingsService settingsService;

    public AdminCommandHandler(VillagerTradeManager plugin, TradeService tradeService, RestockService restockService, SettingsService settingsService) {
        this.plugin = plugin;
        this.tradeService = tradeService;
        this.restockService = restockService;
        this.settingsService = settingsService;
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length == 0) {
            return false;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "on": {
                return this.handleOnCommand(sender);
            }
            case "off": {
                return this.handleOffCommand(sender);
            }
            case "status": {
                return this.handleStatusCommand(sender);
            }
            case "memory": {
                return this.handleMemoryCommand(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        return false;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 1) {
            List<String> completions = Arrays.asList("on", "off", "status", "memory");
            ArrayList<String> matches = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[0], completions, matches);
            Collections.sort(matches);
            return matches;
        }
        return null;
    }

    private boolean handleOnCommand(CommandSender sender) {
        if (this.tradeService.isTradeManagementEnabled()) {
            sender.sendMessage("\u00a7cVillager trade management is already active!");
            return true;
        }
        this.tradeService.setTradeManagementEnabled(true);
        this.settingsService.saveSettingToDatabase("trade_management_enabled", "true");
        sender.sendMessage("\u00a7aVillager trade management activated!");
        return true;
    }

    private boolean handleOffCommand(CommandSender sender) {
        if (!this.tradeService.isTradeManagementEnabled()) {
            sender.sendMessage("\u00a7cVillager trade management is already inactive!");
            return true;
        }
        this.tradeService.setTradeManagementEnabled(false);
        this.settingsService.saveSettingToDatabase("trade_management_enabled", "false");
        sender.sendMessage("\u00a7aVillager trade management deactivated!");
        return true;
    }

    private boolean handleStatusCommand(CommandSender sender) {
        sender.sendMessage("\u00a77Villager trade management is currently: " + (this.tradeService.isTradeManagementEnabled() ? "\u00a7aActive" : "\u00a7cInactive"));
        sender.sendMessage("\u00a77Dynamic Trade Detection: \u00a7aEnabled \u00a77(All villager trades supported)");
        sender.sendMessage("\u00a77Custom prices:");
        if (this.tradeService.getCustomPrices().isEmpty()) {
            sender.sendMessage("  \u00a77No custom prices set");
        } else {
            for (Map.Entry<String, Integer> entry : this.tradeService.getCustomPrices().entrySet()) {
                String userFriendlyKey = this.tradeService.convertToUserFriendlyFormat(entry.getKey());
                sender.sendMessage("  \u00a77" + userFriendlyKey + ": \u00a7a" + String.valueOf(entry.getValue()) + " \u00a77emeralds");
            }
        }
        sender.sendMessage("\u00a77Restock Settings:");
        sender.sendMessage("  \u00a77Custom Restock: " + (this.restockService.isCustomRestockEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        sender.sendMessage("  \u00a77Restock Interval: \u00a7a" + this.restockService.getRestockIntervalMinutes() + " \u00a77minutes");
        sender.sendMessage("  \u00a77Restock Limit: \u00a7a" + this.restockService.getRestockLimitPerDay() + " \u00a77per day");
        sender.sendMessage("  \u00a77Unlimited Restock: " + (this.restockService.isUnlimitedRestock() ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        sender.sendMessage("  \u00a77Instant Restock: " + (this.restockService.isInstantRestockEnabled() ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        sender.sendMessage("\u00a77Banned Items:");
        List<String> bannedItems = this.settingsService.getAllBannedItems();
        sender.sendMessage("  \u00a77Total Banned Items: \u00a7c" + bannedItems.size());
        if (!bannedItems.isEmpty()) {
            sender.sendMessage("  \u00a77Banned item types:");
            for (String itemType : bannedItems) {
                sender.sendMessage("    \u00a77- \u00a7c" + itemType.toLowerCase());
            }
        }
        sender.sendMessage("\u00a77Platform Info:");
        sender.sendMessage("  \u00a77Platform: \u00a7a" + String.valueOf((Object)this.plugin.getPlatformService().getDetectedPlatform()));
        sender.sendMessage("  \u00a77Scheduler: \u00a7a" + this.plugin.getTaskScheduler().getSchedulerName());
        return true;
    }

    private boolean handleMemoryCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("villagertrade.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        sender.sendMessage("\u00a76=== Memory Usage Statistics ===");
        Map<String, Object> tradeStats = this.tradeService.getCacheStatistics();
        Map<String, Object> restockStats = this.restockService.getCacheStatistics();
        sender.sendMessage("\u00a77Trade Service Caches:");
        sender.sendMessage("  \u00a77Villager Cache: \u00a7a" + String.valueOf(tradeStats.get("villagerCacheSize")) + " \u00a77/ \u00a7c" + String.valueOf(tradeStats.get("villagerCacheMax")));
        sender.sendMessage("  \u00a77Player Cache: \u00a7a" + String.valueOf(tradeStats.get("playerCacheSize")) + " \u00a77/ \u00a7c" + String.valueOf(tradeStats.get("playerCacheMax")));
        sender.sendMessage("  \u00a77Detected Trade Cache: \u00a7a" + String.valueOf(tradeStats.get("detectedTradeCacheSize")) + " \u00a77/ \u00a7c" + String.valueOf(tradeStats.get("detectedTradeCacheMax")));
        sender.sendMessage("  \u00a77Custom Prices: \u00a7a" + String.valueOf(tradeStats.get("customPricesSize")) + " \u00a77/ \u00a7c" + String.valueOf(tradeStats.get("customPricesMax")));
        sender.sendMessage("\u00a77Restock Service Caches:");
        sender.sendMessage("  \u00a77Restock Data Cache: \u00a7a" + String.valueOf(restockStats.get("restockCacheSize")) + " \u00a77/ \u00a7c" + String.valueOf(restockStats.get("restockCacheMax")));
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = (runtime.totalMemory() - runtime.freeMemory()) / 1024L / 1024L;
        long maxMemory = runtime.maxMemory() / 1024L / 1024L;
        long freeMemory = runtime.freeMemory() / 1024L / 1024L;
        long totalMemory = runtime.totalMemory() / 1024L / 1024L;
        sender.sendMessage("\u00a77JVM Memory Usage:");
        sender.sendMessage("  \u00a77Used: \u00a7a" + usedMemory + "MB \u00a77/ Total: \u00a7e" + totalMemory + "MB \u00a77/ Max: \u00a7c" + maxMemory + "MB");
        sender.sendMessage("  \u00a77Free: \u00a7a" + freeMemory + "MB");
        sender.sendMessage("\u00a77Use \u00a7f/memory gc \u00a77if you want to force garbage collection (admin only).");
        return true;
    }
}

