/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.commands.CommandHandler;
import com.alan.VillagerTradeManager.services.TradeRegistry;
import com.alan.VillagerTradeManager.services.TradeService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.bukkit.command.CommandSender;

public class AnalyzeTradesCommandHandler
implements CommandHandler {
    private final VillagerTradeManager plugin;
    private final TradeService tradeService;

    public AnalyzeTradesCommandHandler(VillagerTradeManager plugin, TradeService tradeService) {
        this.plugin = plugin;
        this.tradeService = tradeService;
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        sender.sendMessage("\u00a76=== Trade Analysis ===");
        try {
            Map<String, Integer> stats = this.plugin.getDynamicTradeStorageService().getTradeStatistics().get();
            sender.sendMessage("\u00a77Dynamic Trade Detection:");
            sender.sendMessage("  \u00a77Total Detected Trades: \u00a7a" + String.valueOf(stats.getOrDefault("total", 0)));
            sender.sendMessage("  \u00a77Active Trades: \u00a7a" + String.valueOf(stats.getOrDefault("total", 0)));
            sender.sendMessage("  \u00a77Unique Trade Types: \u00a7a" + stats.size());
            sender.sendMessage("  \u00a77Last Detection: \u00a7aReal-time");
            if (!stats.isEmpty()) {
                sender.sendMessage("");
                sender.sendMessage("\u00a77Trades by Profession:");
                stats.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("total")).sorted(Map.Entry.comparingByValue().reversed()).forEach(entry -> {
                    String professionDisplay = TradeRegistry.getProfessionDisplayName((String)entry.getKey());
                    sender.sendMessage("  \u00a77" + professionDisplay + ": \u00a7a" + String.valueOf(entry.getValue()));
                });
            }
        }
        catch (InterruptedException | ExecutionException e) {
            sender.sendMessage("\u00a7cFailed to retrieve trade statistics: " + e.getMessage());
        }
        Map<String, Integer> customPrices = this.tradeService.getCustomPrices();
        sender.sendMessage("");
        sender.sendMessage("\u00a77Custom Pricing:");
        sender.sendMessage("  \u00a77Total Custom Prices: \u00a7a" + customPrices.size());
        if (!customPrices.isEmpty()) {
            HashMap<String, Integer> professionPrices = new HashMap<String, Integer>();
            for (String key : customPrices.keySet()) {
                String profession = key.split("_")[0];
                professionPrices.put(profession, professionPrices.getOrDefault(profession, 0) + 1);
            }
            sender.sendMessage("  \u00a77Prices by Profession:");
            professionPrices.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(entry -> {
                String professionDisplay = TradeRegistry.getProfessionDisplayName((String)entry.getKey());
                sender.sendMessage("    \u00a77" + professionDisplay + ": \u00a7a" + String.valueOf(entry.getValue()));
            });
        }
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        return Collections.emptyList();
    }
}

