/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.commands.CommandHandler;
import com.alan.VillagerTradeManager.services.SettingsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class BanItemCommandHandler
implements CommandHandler {
    private final SettingsService settingsService;

    public BanItemCommandHandler(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length == 0) {
            return false;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "banitem": {
                return this.handleBanItem(sender, args);
            }
            case "unbanitem": {
                return this.handleUnbanItem(sender, args);
            }
            case "listbanneditems": {
                return this.handleListBannedItems(sender, args);
            }
        }
        return false;
    }

    private boolean handleBanItem(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /vtrade banitem <item_type>");
            sender.sendMessage("\u00a77Example: /vtrade banitem diamond_helmet");
            sender.sendMessage("\u00a77This will disable ALL trades that result in diamond helmets (including enchanted ones).");
            return true;
        }
        String itemType = args[1].toUpperCase();
        try {
            Material.valueOf((String)itemType);
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage("\u00a7cInvalid item type! \u00a7f" + itemType + " \u00a7cis not a valid Minecraft item.");
            sender.sendMessage("\u00a77Use item names like: DIAMOND_HELMET, ENCHANTED_GOLDEN_APPLE, etc.");
            return true;
        }
        if (this.settingsService.isItemBanned(itemType)) {
            sender.sendMessage("\u00a7cItem \u00a7f" + itemType.toLowerCase() + " \u00a7cis already banned!");
            return true;
        }
        String bannedBy = sender.getName();
        this.settingsService.banItem(itemType, bannedBy);
        sender.sendMessage("\u00a7aSuccessfully banned item \u00a7f" + itemType.toLowerCase() + "\u00a7a from villager trades.");
        sender.sendMessage("\u00a77All villagers will no longer offer trades for this item.");
        sender.sendMessage("\u00a77Banned by: \u00a7f" + bannedBy);
        return true;
    }

    private boolean handleUnbanItem(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /vtrade unbanitem <item_type>");
            sender.sendMessage("\u00a77Use \u00a7f/vtrade listbanneditems \u00a77to see banned items.");
            return true;
        }
        String itemType = args[1].toUpperCase();
        if (!this.settingsService.isItemBanned(itemType)) {
            sender.sendMessage("\u00a7cItem \u00a7f" + itemType.toLowerCase() + " \u00a7cis not currently banned!");
            return true;
        }
        this.settingsService.unbanItem(itemType);
        sender.sendMessage("\u00a7aSuccessfully unbanned item \u00a7f" + itemType.toLowerCase() + "\u00a7a.");
        sender.sendMessage("\u00a77Villagers can now offer trades for this item again.");
        sender.sendMessage("\u00a77Unbanned by: \u00a7f" + sender.getName());
        return true;
    }

    private boolean handleListBannedItems(CommandSender sender, String[] args) {
        List<String> bannedItems = this.settingsService.getAllBannedItems();
        if (bannedItems.isEmpty()) {
            sender.sendMessage("\u00a76=== Banned Items ===");
            sender.sendMessage("\u00a77No items are currently banned from villager trades.");
            return true;
        }
        sender.sendMessage("\u00a76=== Banned Items ===");
        sender.sendMessage("\u00a77These items cannot be obtained through villager trades:");
        for (String itemType : bannedItems) {
            sender.sendMessage("  \u00a77- \u00a7c" + itemType.toLowerCase());
        }
        sender.sendMessage("");
        sender.sendMessage("\u00a77Use \u00a7f/vtrade unbanitem <item> \u00a77to allow trades for an item again.");
        sender.sendMessage("\u00a77Total banned items: \u00a7c" + bannedItems.size());
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 2 && (args[0].equalsIgnoreCase("banitem") || args[0].equalsIgnoreCase("unbanitem"))) {
            List itemCompletions = Arrays.stream(Material.values()).map(material -> material.name().toLowerCase()).collect(Collectors.toList());
            ArrayList<String> matches = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[1], itemCompletions, matches);
            Collections.sort(matches);
            return matches;
        }
        return Collections.emptyList();
    }
}

