/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.commands.CommandHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.CommandSender;

public class CommandRegistry {
    private final Map<String, CommandHandler> handlers = new HashMap<String, CommandHandler>();

    public void registerHandler(String command, CommandHandler handler) {
        this.handlers.put(command.toLowerCase(), handler);
    }

    public boolean handleCommand(CommandSender sender, String command, String[] args) {
        CommandHandler handler = this.handlers.get(command.toLowerCase());
        if (handler != null) {
            return handler.handle(sender, args);
        }
        return false;
    }

    public List<String> getTabCompletions(CommandSender sender, String command, String[] args) {
        CommandHandler handler = this.handlers.get(command.toLowerCase());
        if (handler != null) {
            return handler.getTabCompletions(sender, args);
        }
        return null;
    }

    public boolean isCommandRegistered(String command) {
        return this.handlers.containsKey(command.toLowerCase());
    }

    public Set<String> getRegisteredCommands() {
        return this.handlers.keySet();
    }
}

