/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.commands.CommandHandler;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import com.alan.VillagerTradeManager.services.GroqApiService;
import com.alan.VillagerTradeManager.services.PluginContextService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class HelpCommandHandler
implements CommandHandler {
    private final VillagerTradeManager plugin;
    private final TaskScheduler taskScheduler;
    private final Map<String, String> knowledgeBase;
    private final GroqApiService groqApiService;
    private final PluginContextService pluginContextService;

    public HelpCommandHandler(VillagerTradeManager plugin, TaskScheduler taskScheduler) {
        this.plugin = plugin;
        this.taskScheduler = taskScheduler;
        this.knowledgeBase = this.initializeKnowledgeBase();
        this.groqApiService = new GroqApiService(plugin);
        this.pluginContextService = new PluginContextService(plugin);
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length < 1 || !args[0].equalsIgnoreCase("help")) {
            return false;
        }
        if (args.length == 1) {
            this.showGeneralHelp(sender);
            return true;
        }
        switch (subCommand = args[1].toLowerCase()) {
            case "askquestion": {
                return this.handleAskQuestion(sender, Arrays.copyOfRange(args, 2, args.length));
            }
        }
        this.showGeneralHelp(sender);
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            List<String> completions = Arrays.asList("askquestion");
            ArrayList<String> matches = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[1], completions, matches);
            Collections.sort(matches);
            return matches;
        }
        return null;
    }

    private void showGeneralHelp(CommandSender sender) {
        sender.sendMessage("\u00a76=== Villager Trade Manager Help ===");
        sender.sendMessage("\u00a77Available commands:");
        sender.sendMessage("\u00a7e/vtrade on \u00a77- Enable trade management");
        sender.sendMessage("\u00a7e/vtrade off \u00a77- Disable trade management");
        sender.sendMessage("\u00a7e/vtrade status \u00a77- Show current plugin status");
        sender.sendMessage("\u00a7e/vtrade memory \u00a77- Show memory usage statistics");
        sender.sendMessage("\u00a7e/vtrade setprice <profession> <item> <price> \u00a77- Set custom price for a trade");
        sender.sendMessage("\u00a7e/vtrade listtrades \u00a77- List all current custom prices");
        sender.sendMessage("\u00a7e/vtrade resetprice <profession> <item> \u00a77- Reset price to default");
        sender.sendMessage("\u00a7e/vtrade inspectvillager \u00a77- Inspect villager trades (look at villager)");
        sender.sendMessage("\u00a7e/vtrade analyzetrades \u00a77- Analyze villager trade patterns");
        sender.sendMessage("\u00a7e/vtrade exporttrades \u00a77- Export trade data to file");
        sender.sendMessage("\u00a7e/vtrade importtrades \u00a77- Import trade data from file");
        sender.sendMessage("\u00a7e/vtrade cleardynamictrades \u00a77- Clear all dynamically detected trades");
        sender.sendMessage("\u00a7e/vtrade tradedetection <on|off> \u00a77- Enable/disable trade detection");
        sender.sendMessage("\u00a7e/vtrade restock \u00a77- Manually restock villager trades");
        sender.sendMessage("\u00a7e/vtrade restocktime <minutes> \u00a77- Set restock interval");
        sender.sendMessage("\u00a7e/vtrade restocklimit <limit> \u00a77- Set daily restock limit");
        sender.sendMessage("\u00a7e/vtrade unlimitedrestock <on|off> \u00a77- Enable/disable unlimited restocking");
        sender.sendMessage("\u00a7e/vtrade instantrestock <on|off> \u00a77- Enable/disable instant restocking");
        sender.sendMessage("\u00a7e/vtrade banitem <item> \u00a77- Ban an item from trades");
        sender.sendMessage("\u00a7e/vtrade unbanitem <item> \u00a77- Unban an item from trades");
        sender.sendMessage("\u00a7e/vtrade listbanneditems \u00a77- List all banned items");
        sender.sendMessage("\u00a7e/vtrade wanderer <add|list|remove|clear> \u00a77- Manage wandering trader trades");
        sender.sendMessage("\u00a7e/vtrade help askquestion <question> \u00a77- Ask the AI assistant a question");
        sender.sendMessage("\u00a77For detailed help on any command, use \u00a7e/vtrade help askquestion <your question>");
    }

    private boolean handleAskQuestion(CommandSender sender, String[] questionArgs) {
        String question;
        if (questionArgs.length == 0) {
            sender.sendMessage("\u00a7cUsage: /vtrade help askquestion <question>");
            sender.sendMessage("\u00a77Example: /vtrade help askquestion How do I set custom prices?");
            return true;
        }
        String originalQuestion = question = String.join((CharSequence)" ", questionArgs);
        sender.sendMessage("\u00a76=== AI Assistant Answer ===");
        sender.sendMessage("\u00a77Question: \u00a7f" + question);
        String kbAnswer = this.findAnswer(question.toLowerCase());
        if (this.isGoodKnowledgeBaseAnswer(kbAnswer, question.toLowerCase())) {
            sender.sendMessage("\u00a77Answer: \u00a7f" + kbAnswer);
            sender.sendMessage("\u00a77\u00a7o(Answered from knowledge base)");
        } else {
            this.handleGroqFallback(sender, originalQuestion);
        }
        return true;
    }

    private void handleGroqFallback(CommandSender sender, String question) {
        if (!this.groqApiService.isAvailable()) {
            sender.sendMessage("\u00a77Answer: \u00a7fAI assistant is not configured. Please set up Groq API key in config.yml for advanced AI responses.");
            sender.sendMessage("\u00a77\u00a7o(Knowledge base fallback)");
            return;
        }
        sender.sendMessage("\u00a77Processing with AI assistant...");
        ((CompletableFuture)this.groqApiService.generateResponse(question).thenAccept(aiResponse -> this.taskScheduler.runSync(() -> {
            if (aiResponse.startsWith("Sorry") || aiResponse.contains("error")) {
                sender.sendMessage("\u00a77Answer: \u00a7f" + aiResponse);
                sender.sendMessage("\u00a77\u00a7o(AI service unavailable - using knowledge base)");
            } else {
                sender.sendMessage("\u00a77Answer: \u00a7f" + aiResponse);
                sender.sendMessage("\u00a77\u00a7o(Powered by Groq AI with plugin context)");
            }
        }))).exceptionally(throwable -> {
            this.plugin.getLogger().warning("Error in Groq API call: " + throwable.getMessage());
            this.taskScheduler.runSync(() -> {
                sender.sendMessage("\u00a77Answer: \u00a7fSorry, the AI service encountered an error. Please try again later.");
                sender.sendMessage("\u00a77\u00a7o(AI service error)");
            });
            return null;
        });
    }

    private String findAnswer(String question) {
        String normalizedQuestion = this.normalizeText(question);
        String bestMatch = null;
        double bestScore = 0.0;
        for (Map.Entry<String, String> entry : this.knowledgeBase.entrySet()) {
            String normalizedKey = this.normalizeText(entry.getKey());
            double score = this.calculateSimilarity(normalizedQuestion, normalizedKey);
            if (!(score > bestScore) || !(score > 0.3)) continue;
            bestScore = score;
            bestMatch = entry.getValue();
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        for (Map.Entry<String, String> entry : this.knowledgeBase.entrySet()) {
            String[] keywords;
            for (String keyword : keywords = this.normalizeText(entry.getKey()).split("\\s+")) {
                if (!normalizedQuestion.contains(keyword) || keyword.length() <= 3) continue;
                return entry.getValue();
            }
        }
        return "I'm sorry, I couldn't find a specific answer to your question in my knowledge base. Let me check with the advanced AI assistant.";
    }

    private boolean isGoodKnowledgeBaseAnswer(String answer, String question) {
        String[] complexIndicators;
        if (answer.contains("couldn't find a specific answer") || answer.contains("knowledge base")) {
            return false;
        }
        for (String indicator : complexIndicators = new String[]{"how does", "why", "explain", "analyze", "function", "method", "service", "architecture", "performance", "optimization"}) {
            if (!question.contains(indicator)) continue;
            return false;
        }
        return !question.contains("config") && !question.contains("troubleshoot") && !question.contains("error") && !question.contains("problem");
    }

    private String normalizeText(String text) {
        if (text == null) {
            return "";
        }
        String normalized = text.toLowerCase().replaceAll("[^a-zA-Z0-9\\s]", " ").replaceAll("\\s+", " ").trim();
        return normalized;
    }

    private double calculateSimilarity(String text1, String text2) {
        if (text1.isEmpty() || text2.isEmpty()) {
            return 0.0;
        }
        String[] words1 = text1.split("\\s+");
        String[] words2 = text2.split("\\s+");
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(words1));
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(words2));
        HashSet<String> intersection = new HashSet<String>(set1);
        intersection.retainAll(set2);
        HashSet<String> union = new HashSet<String>(set1);
        union.addAll(set2);
        if (union.isEmpty()) {
            return 0.0;
        }
        return (double)intersection.size() / (double)union.size();
    }

    private Map<String, String> initializeKnowledgeBase() {
        HashMap<String, String> kb = new HashMap<String, String>();
        kb.put("setprice", "Use /vtrade setprice <profession> <item> <price> to set a custom emerald price for a specific trade. For example: /vtrade setprice farmer wheat 5. Professions include: farmer, librarian, priest, blacksmith, butcher, leatherworker. Items should match Minecraft item names.");
        kb.put("listtrades", "Use /vtrade listtrades to see all currently set custom prices. This shows all modified trade prices with their profession and item details.");
        kb.put("resetprice", "Use /vtrade resetprice <profession> <item> to remove a custom price and return to the default price for that trade.");
        kb.put("inspectvillager", "Look at a villager and use /vtrade inspectvillager to see detailed information about their current trades, including prices, stock levels, and profession details.");
        kb.put("analyzetrades", "Use /vtrade analyzetrades to get statistical analysis of villager trades across the server, including most profitable trades and trade patterns.");
        kb.put("restock", "Use /vtrade restock to manually restock all villager trades. The plugin also has automatic restocking based on configurable intervals.");
        kb.put("restocktime", "Use /vtrade restocktime <minutes> to set how often villagers automatically restock their trades. Default is usually 30 minutes.");
        kb.put("restocklimit", "Use /vtrade restocklimit <number> to set the maximum number of times a villager can restock per day. This prevents abuse.");
        kb.put("unlimitedrestock", "Use /vtrade unlimitedrestock <on|off> to enable or disable unlimited restocking. When enabled, villagers can restock without daily limits.");
        kb.put("instantrestock", "Use /vtrade instantrestock <on|off> to enable or disable instant restocking. When enabled, trades restock immediately when used up.");
        kb.put("banitem", "Use /vtrade banitem <item> to prevent a specific item from appearing in villager trades. Useful for balancing or removing unwanted items.");
        kb.put("unbanitem", "Use /vtrade unbanitem <item> to remove an item from the banned list, allowing it to appear in trades again.");
        kb.put("listbanneditems", "Use /vtrade listbanneditems to see all currently banned items that cannot appear in villager trades.");
        kb.put("wanderer", "Use /vtrade wanderer add <item> <quantity> <price> to add custom trades for wandering traders. Use /vtrade wanderer list to see all custom trades, /vtrade wanderer remove <item> to remove trades, and /vtrade wanderer clear to remove all custom trades.");
        kb.put("exporttrades", "Use /vtrade exporttrades to save all trade data to a file for backup or transfer to another server.");
        kb.put("importtrades", "Use /vtrade importtrades to load trade data from a previously exported file.");
        kb.put("cleardynamictrades", "Use /vtrade cleardynamictrades to remove all dynamically detected trades, resetting to default trade detection.");
        kb.put("tradedetection", "Use /vtrade tradedetection <on|off> to enable or disable automatic detection of new villager trades. When enabled, the plugin learns new trades as they occur.");
        kb.put("on off status", "Use /vtrade on to enable the plugin, /vtrade off to disable it, and /vtrade status to check current settings and statistics.");
        kb.put("memory", "Use /vtrade memory to view detailed memory usage statistics for the plugin's caches and JVM memory.");
        kb.put("not working", "If the plugin isn't working: 1) Check /vtrade status to see if it's enabled. 2) Ensure you have permission (villagertrade.use). 3) Check console for errors. 4) Verify database connection if using external database. 5) Try /vtrade on to enable it.");
        kb.put("permission", "The plugin uses permissions: villagertrade.use (basic commands), villagertrade.admin (admin commands), villagertrade.inspect (inspection commands). Make sure you have the appropriate permissions.");
        kb.put("error", "Common errors: Database connection issues (check config.yml), insufficient permissions, or plugin conflicts. Check the console for detailed error messages and ensure the plugin is compatible with your server version.");
        kb.put("database", "Database issues: Ensure your database credentials in config.yml are correct. The plugin supports SQLite (default), PostgreSQL, and Supabase. For SQLite, no additional setup needed. For others, configure host, port, database name, username, and password.");
        kb.put("lag", "Performance issues: The plugin is optimized for performance. If experiencing lag, check /vtrade memory for cache sizes, reduce cache sizes in config.yml, or disable features like trade detection if not needed.");
        kb.put("trade not changing", "If custom prices aren't applying: 1) Ensure the plugin is enabled (/vtrade on). 2) Check the exact profession and item names. 3) Use /vtrade listtrades to verify the price is set. 4) Try restarting or reloading the villager's trades.");
        kb.put("config", "Configuration is in config.yml. Key settings: database type and credentials, cache sizes, restock intervals, banned items list. After changes, restart the server for most settings to take effect.");
        kb.put("database config", "Database configuration in config.yml: Set 'database.type' to 'sqlite', 'postgresql', or 'supabase'. For PostgreSQL/Supabase, configure host, port, database, username, password. SQLite uses a local file and needs no additional config.");
        kb.put("cache", "Cache settings control memory usage. Adjust 'cache.villager_cache_size', 'cache.player_cache_size', etc. in config.yml. Larger caches improve performance but use more memory.");
        kb.put("restock config", "Restock settings: 'restock.interval_minutes' (default 30), 'restock.limit_per_day' (default 3), 'restock.unlimited' (default false), 'restock.instant' (default false).");
        kb.put("banned items config", "Banned items are configured in config.yml under 'banned_items' list. Add Minecraft item names to prevent them from appearing in trades.");
        kb.put("wandering trader", "Wandering traders have special trades that can be managed separately. Use /vtrade inspectvillager while looking at a wandering trader to see their trades. The plugin tracks wandering trader spawns and their trade offers.");
        kb.put("wandering trader spawn", "The plugin automatically detects when wandering traders spawn and logs their trade offers. Use /vtrade analyzetrades to see wandering trader statistics alongside regular villager data.");
        kb.put("wandering trader trades", "Wandering trader trades are handled the same as villager trades. You can set custom prices, ban items, and analyze their trade patterns. They typically offer rare items and have different restock mechanics.");
        kb.put("trade enhancement", "Trade enhancement allows creating complex trade chains and prerequisites. Use /vtrade tradeenhancement to access enhancement features. This includes multi-step trades and conditional trade unlocks.");
        kb.put("trade chain", "Trade chains are sequences of trades that must be completed in order. For example, you might need to complete basic trades before unlocking advanced ones. Configure chains in the enhancement system.");
        kb.put("trade prerequisite", "Trade prerequisites are requirements that must be met before certain trades become available. This can include completing other trades, reaching certain levels, or having specific items.");
        kb.put("enhancement config", "Trade enhancement settings are configured in config.yml under 'trade_enhancement' section. Enable/disable enhancement features, set chain requirements, and configure prerequisite conditions.");
        kb.put("villager level", "Villagers progress through 5 levels: Novice, Apprentice, Journeyman, Expert, Master. Higher levels unlock better trades. The plugin tracks villager progression and can influence level-up mechanics.");
        kb.put("level up", "Villagers level up by completing trades. The plugin can accelerate or modify level-up requirements. Use /vtrade level to manage villager leveling features.");
        kb.put("level progression", "Level progression is automatic but can be configured. Set experience multipliers, trade requirements per level, and special rewards for reaching higher levels.");
        kb.put("level command", "Use /vtrade level <villager> <level> to manually set a villager's level. Use /vtrade level info to see level progression statistics across all villagers.");
        kb.put("stock management", "Stock management controls how many times each trade can be used before restocking. Configure stock limits per trade, profession, or globally. Use /vtrade stock to manage stock settings.");
        kb.put("stock limit", "Set stock limits to prevent trade farming. Use /vtrade stock set <profession> <item> <limit> to set specific limits. Use /vtrade stock global <limit> for server-wide limits.");
        kb.put("stock tracking", "The plugin tracks stock levels for all trades. Use /vtrade inspectvillager to see current stock levels. Stock automatically replenishes based on restock settings.");
        kb.put("stock reset", "Stock resets according to restock settings. Use /vtrade restock to manually reset all stock levels. Configure automatic reset intervals and limits.");
        kb.put("metrics", "The plugin provides comprehensive metrics via /vtrade metrics. Monitor trade volumes, player activity, villager statistics, and system performance. Metrics are exposed via HTTP endpoint for external monitoring.");
        kb.put("performance monitoring", "Performance monitoring tracks CPU usage, memory consumption, and database query times. Use /vtrade memory for memory statistics and /vtrade status for overall performance metrics.");
        kb.put("health check", "Health checks ensure the plugin is functioning properly. The /health endpoint provides system status. Automatic health monitoring alerts administrators to issues.");
        kb.put("monitoring endpoint", "The plugin exposes monitoring endpoints: /metrics for Prometheus metrics, /health for health status, and /status for detailed system information.");
        kb.put("cache configuration", "Cache settings optimize performance: villager_cache_size (default 1000), player_cache_size (default 500), trade_cache_size (default 2000). Adjust based on server size and available memory.");
        kb.put("database optimization", "Database optimization: Use connection pooling, prepared statements, and proper indexing. Configure query timeouts and connection validation. Monitor slow queries in logs.");
        kb.put("performance tuning", "Performance tuning: Adjust cache sizes, enable/disable features, configure database settings. Use /vtrade memory to monitor impact. Consider server hardware limitations.");
        kb.put("server compatibility", "Compatible with Spigot, Paper, Purpur, and other Bukkit derivatives. Supports Minecraft 1.16+. Check plugin.yml for specific version requirements. Folia support for modern servers.");
        kb.put("plugin conflict", "Plugin conflicts: Disable other economy/trade plugins temporarily. Check for conflicting permissions or event handlers. Use /vtrade status to verify plugin isolation.");
        kb.put("memory leak", "Memory leaks: Monitor with /vtrade memory. Clear caches with /vtrade clearcache. Check for circular references in custom configurations. Restart server if needed.");
        kb.put("database corruption", "Database corruption: Backup data first, then repair with database tools. For SQLite, use sqlite3 .dump and .read commands. Consider migrating to PostgreSQL for better reliability.");
        kb.put("trade detection issues", "Trade detection problems: Ensure trade detection is enabled (/vtrade tradedetection on). Check for plugin conflicts. Clear dynamic trades (/vtrade cleardynamictrades) and restart detection.");
        kb.put("restock not working", "Restock issues: Check restock settings (/vtrade restocktime, /vtrade restocklimit). Ensure unlimited restock is disabled. Verify villager is loaded and active. Try manual restock.");
        kb.put("level up not working", "Level progression issues: Check level configuration. Ensure trades are being completed properly. Use /vtrade level info to debug. Verify no plugin conflicts blocking experience gain.");
        kb.put("database migration", "Database migration: Export data (/vtrade exporttrades), change database type in config.yml, restart server, import data (/vtrade importtrades). Test thoroughly before going live.");
        kb.put("config migration", "Configuration migration: Backup old config.yml, update to new format, restart server. Check for deprecated settings. Use /vtrade status to verify new configuration.");
        kb.put("server migration", "Server migration: Export all data, copy plugin JAR and config, import data on new server. Update database credentials if needed. Test all features before opening to players.");
        kb.put("version", "Check the plugin version in plugin.yml or use /version VillagerTradeManager. Update by downloading the latest JAR from the official source.");
        kb.put("update", "To update: 1) Download the new JAR file. 2) Stop the server. 3) Replace the old JAR in plugins folder. 4) Start the server. 5) Check /vtrade status to verify.");
        kb.put("backup", "Regularly backup your data: Use /vtrade exporttrades to save trade data. Also backup config.yml and database files if using SQLite.");
        kb.put("support", "For support: Check the console for errors, verify configuration, ensure server compatibility. If issues persist, provide detailed error logs and server information.");
        kb.put("documentation", "Full documentation available in README.md. Includes setup guides, configuration reference, command reference, and troubleshooting tips.");
        kb.put("changelog", "Check CHANGELOG.md for version history, new features, bug fixes, and breaking changes. Always review changelog before updating.");
        kb.put("license", "This plugin is open source. Check LICENSE file for usage terms. Commercial use may require separate licensing.");
        kb.put("who created this plugin", "This plugin was created by AlanTheDev. Join our Discord community at https://discord.gg/alan");
        kb.put("creator", "This plugin was created by AlanTheDev. Join our Discord community at https://discord.gg/alan");
        kb.put("developer", "This plugin was created by AlanTheDev. Join our Discord community at https://discord.gg/alan");
        kb.put("author", "This plugin was created by AlanTheDev. Join our Discord community at https://discord.gg/alan");
        kb.put("who made this plugin", "This plugin was created by AlanTheDev. Join our Discord community at https://discord.gg/alan");
        kb.put("ai assistant", "The AI assistant provides intelligent answers about plugin features. Use /vtrade help askquestion <question> to ask questions. Simple questions use the knowledge base, complex questions use Groq AI with plugin context.");
        kb.put("groq ai", "Groq AI integration provides advanced AI responses with plugin-specific context. Configure the API key in config.yml under ai_assistant.groq.api_key for enhanced AI capabilities.");
        kb.put("askquestion", "Use /vtrade help askquestion <your question> to get AI-powered answers about the plugin. The assistant uses both knowledge base and Groq AI for comprehensive responses.");
        return kb;
    }
}

