/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.commands.CommandHandler;
import com.alan.VillagerTradeManager.services.DynamicTradeDetector;
import com.alan.VillagerTradeManager.services.SimpleTradeMapper;
import com.alan.VillagerTradeManager.services.TradeRegistry;
import com.alan.VillagerTradeManager.services.TradeService;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.util.RayTraceResult;

public class InspectVillagerCommandHandler
implements CommandHandler {
    private final VillagerTradeManager plugin;
    private final TradeService tradeService;

    public InspectVillagerCommandHandler(VillagerTradeManager plugin, TradeService tradeService) {
        this.plugin = plugin;
        this.tradeService = tradeService;
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        Villager targetVillager = this.findTargetVillager(player);
        if (targetVillager == null) {
            sender.sendMessage("\u00a7cNo villager found! Look directly at a villager and try again.");
            sender.sendMessage("\u00a77Make sure you're within 5 blocks of the villager.");
            return true;
        }
        this.inspectVillager(player, targetVillager);
        return true;
    }

    private Villager findTargetVillager(Player player) {
        RayTraceResult rayTrace;
        Villager targetVillager = null;
        Block targetBlock = player.getTargetBlockExact(5);
        if (targetBlock != null && targetBlock.getState() instanceof CreatureSpawner) {
            for (Entity entity2 : targetBlock.getWorld().getNearbyEntities(targetBlock.getLocation(), 3.0, 3.0, 3.0)) {
                if (!(entity2 instanceof Villager)) continue;
                targetVillager = (Villager)entity2;
                break;
            }
        }
        if (targetVillager == null && (rayTrace = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getEyeLocation().getDirection(), 5.0, entity -> entity instanceof Villager)) != null && rayTrace.getHitEntity() instanceof Villager) {
            targetVillager = (Villager)rayTrace.getHitEntity();
        }
        return targetVillager;
    }

    private void inspectVillager(Player sender, Villager targetVillager) {
        String profession = null;
        try {
            if (targetVillager.getProfession() != null && targetVillager.getProfession().getKey() != null) {
                profession = targetVillager.getProfession().getKey().getKey().toLowerCase();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get villager profession: " + e.getMessage());
        }
        String professionDisplay = "Unknown";
        if (profession != null) {
            professionDisplay = TradeRegistry.getProfessionDisplayName(profession);
        }
        sender.sendMessage("\u00a76=== Villager Inspection ===");
        sender.sendMessage("\u00a77Profession: \u00a7a" + professionDisplay);
        sender.sendMessage("\u00a77Location: \u00a7a" + targetVillager.getLocation().getBlockX() + ", " + targetVillager.getLocation().getBlockY() + ", " + targetVillager.getLocation().getBlockZ());
        sender.sendMessage("\u00a77UUID: \u00a77" + targetVillager.getUniqueId().toString().substring(0, 8) + "...");
        sender.sendMessage("");
        List recipes = targetVillager.getRecipes();
        if (recipes.isEmpty()) {
            sender.sendMessage("\u00a77This villager has no trades available.");
            return;
        }
        sender.sendMessage("\u00a76Current Trades (" + recipes.size() + "):");
        for (int i = 0; i < recipes.size(); ++i) {
            Integer customPrice;
            MerchantRecipe recipe = (MerchantRecipe)recipes.get(i);
            ItemStack result = recipe.getResult();
            List ingredients = recipe.getIngredients();
            String tradeId = TradeRegistry.identifyTrade(profession, result, ingredients);
            String simpleName = null;
            String tradeType = "\u00a7cUnknown";
            if (tradeId != null) {
                tradeType = "\u00a7aRegistry";
                simpleName = SimpleTradeMapper.getSimpleName(profession, tradeId);
            } else {
                try {
                    DynamicTradeDetector.DetectedTrade detectedTrade = this.plugin.getDynamicTradeStorageService().getDetectedTrade(profession, result, ingredients).get();
                    if (detectedTrade != null) {
                        tradeId = detectedTrade.getTradeId();
                        simpleName = detectedTrade.getSimpleName();
                        tradeType = "\u00a7eDynamic";
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    this.plugin.getLogger().warning("Failed to check for dynamic trade: " + e.getMessage());
                }
            }
            StringBuilder ingredientsStr = new StringBuilder();
            for (int j = 0; j < ingredients.size(); ++j) {
                if (j > 0) {
                    ingredientsStr.append(" + ");
                }
                ItemStack ingredient = (ItemStack)ingredients.get(j);
                ingredientsStr.append(ingredient.getAmount()).append(" ").append(ingredient.getType().name().toLowerCase().replace("_", " "));
            }
            sender.sendMessage("\u00a77" + (i + 1) + ". \u00a7f" + result.getAmount() + " " + result.getType().name().toLowerCase().replace("_", " ") + " \u00a77\u2190 \u00a7e" + ingredientsStr.toString());
            StringBuilder metaInfo = new StringBuilder();
            metaInfo.append("     \u00a77Type: ").append(tradeType);
            if (simpleName != null) {
                metaInfo.append(" \u00a77| \u00a77Simple: \u00a7a").append(simpleName);
            }
            if (tradeId != null && (customPrice = this.tradeService.getCustomPrices().get(profession + "_" + tradeId)) != null) {
                metaInfo.append(" \u00a77| \u00a77Price: \u00a7e").append(customPrice).append(" emeralds");
            }
            sender.sendMessage(metaInfo.toString());
        }
        sender.sendMessage("");
        sender.sendMessage("\u00a77Use \u00a7f/vtrade setprice \u00a77to customize prices for these trades.");
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        return Collections.emptyList();
    }
}

