/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.commands.CommandHandler;
import com.alan.VillagerTradeManager.exception.DatabaseException;
import com.alan.VillagerTradeManager.services.SimpleTradeMapper;
import com.alan.VillagerTradeManager.services.TradeRegistry;
import com.alan.VillagerTradeManager.services.TradeService;
import com.alan.VillagerTradeManager.validation.InputValidator;
import com.alan.VillagerTradeManager.validation.ValidationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class PriceCommandHandler
implements CommandHandler {
    private final VillagerTradeManager plugin;
    private final TradeService tradeService;

    public PriceCommandHandler(VillagerTradeManager plugin, TradeService tradeService) {
        this.plugin = plugin;
        this.tradeService = tradeService;
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        String subCommand = args[0].toLowerCase();
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (subCommand) {
            case "setprice": {
                return this.handleSetPriceCommand(sender, subArgs);
            }
            case "listtrades": {
                return this.handleListTradesCommand(sender, subArgs);
            }
            case "resetprice": {
                return this.handleResetPriceCommand(sender, subArgs);
            }
        }
        return false;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 0) {
            return this.getProfessionCompletions("");
        }
        if (args.length == 1) {
            return this.getProfessionCompletions(args[0]);
        }
        if (args.length == 2) {
            String potentialProfession = args[0].toLowerCase();
            if (TradeRegistry.isValidProfession(potentialProfession)) {
                return this.getTradeCompletions(potentialProfession, args[1]);
            }
            if (args[0].equalsIgnoreCase("setprice") || args[0].equalsIgnoreCase("listtrades") || args[0].equalsIgnoreCase("resetprice")) {
                return this.getProfessionCompletions(args[1]);
            }
        } else if (args.length == 3) {
            if (args[0].equalsIgnoreCase("setprice") || args[0].equalsIgnoreCase("resetprice")) {
                String profession = args[1].toLowerCase();
                return this.getTradeCompletions(profession, args[2]);
            }
        } else {
            if (args.length == 4 && args[0].equalsIgnoreCase("setprice")) {
                List<String> completions = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60", "64");
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[3], completions, matches);
                Collections.sort(matches);
                return matches;
            }
            if (args.length == 5 && args[0].equalsIgnoreCase("setprice")) {
                List<String> completions = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60", "64");
                ArrayList<String> matches = new ArrayList<String>();
                StringUtil.copyPartialMatches((String)args[4], completions, matches);
                Collections.sort(matches);
                return matches;
            }
        }
        return null;
    }

    private boolean handleSetPriceCommand(CommandSender sender, String[] args) {
        if (args.length == 3) {
            ValidationResult<String> profRes = InputValidator.validateProfession(args[0]);
            if (profRes.isValid()) {
                return this.handleSimpleSetPriceCommand(sender, args);
            }
            return this.handleLegacySetPriceCommand(sender, args);
        }
        if (args.length == 5) {
            return this.handleUniversalSetPriceCommand(sender, args);
        }
        sender.sendMessage("\u00a7cUsage:");
        sender.sendMessage("\u00a77Simple: /vtrade setprice <profession> <item_name> <emerald_cost>");
        sender.sendMessage("\u00a77Legacy: /vtrade setprice <enchant> <level> <price>");
        sender.sendMessage("\u00a77Universal: /vtrade setprice <profession> <trade_id> <price> <emerald_cost>");
        sender.sendMessage("\u00a77Examples:");
        sender.sendMessage("  \u00a77/vtrade setprice armorer diamond_leggings 30");
        sender.sendMessage("  \u00a77/vtrade setprice efficiency 1 20");
        sender.sendMessage("  \u00a77/vtrade setprice armorer armorer_l1_coal_15_emerald_1 5 10");
        return true;
    }

    private boolean handleLegacySetPriceCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /vtrade setprice <enchant> <level> <price>");
            return true;
        }
        String enchantName = args[0].toLowerCase();
        ValidationResult<Integer> levelResult = InputValidator.validateEnchantmentLevel(args[1]);
        if (levelResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + levelResult.getFirstError().orElse("Invalid enchantment level"));
            return true;
        }
        ValidationResult<Integer> priceResult = InputValidator.validateEmeraldCost(args[2]);
        if (priceResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + priceResult.getFirstError().orElse("Invalid price"));
            return true;
        }
        int level = levelResult.getValue();
        int price = priceResult.getValue();
        String itemKey = "enchanted_book_" + enchantName + "_" + level;
        this.tradeService.getCustomPrices().put(itemKey, price);
        try {
            this.tradeService.saveCustomPricesToFile(this.plugin.getPricesFile());
            sender.sendMessage("\u00a7aSet custom price for \u00a77" + enchantName + " " + level + " \u00a7ato \u00a7e" + price + " \u00a7aemeralds.");
        }
        catch (DatabaseException e) {
            sender.sendMessage("\u00a7cFailed to save custom price: " + e.getMessage());
            this.plugin.getLogger().severe("Failed to save custom price for " + enchantName + " " + level + ": " + e.getMessage());
        }
        return true;
    }

    private boolean handleUniversalSetPriceCommand(CommandSender sender, String[] args) {
        ValidationResult<String> professionResult = InputValidator.validateProfession(args[1]);
        if (professionResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + professionResult.getFirstError().orElse("Invalid profession"));
            return true;
        }
        ValidationResult<String> tradeIdResult = InputValidator.validateTradeIdForProfession(args[2], professionResult.getValue());
        if (tradeIdResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + tradeIdResult.getFirstError().orElse("Invalid trade ID"));
            return true;
        }
        ValidationResult<Integer> priceResult = InputValidator.validateEmeraldCost(args[3]);
        if (priceResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + priceResult.getFirstError().orElse("Invalid price"));
            return true;
        }
        ValidationResult<Integer> emeraldCostResult = InputValidator.validateEmeraldCost(args[4]);
        if (emeraldCostResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + emeraldCostResult.getFirstError().orElse("Invalid emerald cost"));
            return true;
        }
        String profession = professionResult.getValue();
        String tradeId = tradeIdResult.getValue();
        int emeraldCost = emeraldCostResult.getValue();
        String priceKey = profession + "_" + tradeId;
        this.tradeService.getCustomPrices().put(priceKey, emeraldCost);
        try {
            this.tradeService.saveCustomPricesToFile(this.plugin.getPricesFile());
            String tradeDescription = TradeRegistry.getTradeDescription(tradeId);
            sender.sendMessage("\u00a7aSet custom price for \u00a77" + TradeRegistry.getProfessionDisplayName(profession) + " \u00a7f" + tradeDescription + " \u00a7ato \u00a7e" + emeraldCost + " \u00a7aemeralds.");
        }
        catch (DatabaseException e) {
            sender.sendMessage("\u00a7cFailed to save custom price: " + e.getMessage());
            this.plugin.getLogger().severe("Failed to save custom price for " + profession + " " + tradeId + ": " + e.getMessage());
        }
        return true;
    }

    private boolean handleSimpleSetPriceCommand(CommandSender sender, String[] args) {
        ValidationResult<String> professionResult = InputValidator.validateProfession(args[0]);
        if (professionResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + professionResult.getFirstError().orElse("Invalid profession"));
            return true;
        }
        ValidationResult<String> tradeResult = InputValidator.validateSimpleTradeName(args[1], professionResult.getValue());
        if (tradeResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + tradeResult.getFirstError().orElse("Invalid trade"));
            sender.sendMessage("\u00a77You can use either simple names (e.g., 'diamond_leggings') or technical IDs.");
            String simpleName = args[1].toLowerCase();
            if (simpleName.matches("^(efficiency|fortune|silk_touch|unbreaking|sharpness|smite|bane_of_arthropods|knockback|fire_aspect|looting|sweeping|protection|fire_protection|feather_falling|blast_protection|projectile_protection|respiration|aqua_affinity|thorns|depth_strider|frost_walker|mending|curse_of_vanishing|curse_of_binding|power|punch|flame|infinity|mending|loyalty|impaling|riptide|channeling|multishot|piercing|quick_charge|soul_speed|swift_sneak)$")) {
                sender.sendMessage("\u00a77For enchantments, you must specify the level: \u00a7f" + simpleName + "_1\u00a77, \u00a7f" + simpleName + "_2\u00a77, etc.");
            }
            return true;
        }
        ValidationResult<Integer> costResult = InputValidator.validateEmeraldCost(args[2]);
        if (costResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + costResult.getFirstError().orElse("Invalid emerald cost"));
            return true;
        }
        String profession = professionResult.getValue();
        String technicalId = tradeResult.getValue();
        int emeraldCost = costResult.getValue();
        String displayName = SimpleTradeMapper.getSimpleName(profession, technicalId);
        if (displayName == null) {
            displayName = technicalId;
        }
        String priceKey = profession + "_" + technicalId;
        this.tradeService.getCustomPrices().put(priceKey, emeraldCost);
        try {
            this.tradeService.saveCustomPricesToFile(this.plugin.getPricesFile());
            sender.sendMessage("\u00a7aSet custom price for \u00a77" + profession + " " + displayName + " \u00a7ato \u00a7e" + emeraldCost + " \u00a7aemeralds.");
        }
        catch (DatabaseException e) {
            sender.sendMessage("\u00a7cFailed to save custom price: " + e.getMessage());
            this.plugin.getLogger().severe("Failed to save custom price for " + profession + " " + displayName + ": " + e.getMessage());
        }
        return true;
    }

    private boolean handleListTradesCommand(CommandSender sender, String[] args) {
        Object priceInfo;
        Integer customPrice;
        if (args.length < 1) {
            sender.sendMessage("\u00a76Available Professions and Trade Counts:");
            for (String profession : TradeRegistry.getAllProfessions()) {
                List<String> tradeIds = TradeRegistry.getTradesForProfession(profession);
                String displayName = TradeRegistry.getProfessionDisplayName(profession);
                sender.sendMessage("  \u00a7a" + displayName + "\u00a77: " + tradeIds.size() + " trades");
            }
            sender.sendMessage("");
            sender.sendMessage("\u00a77Use \u00a7f/vtrade listtrades <profession> \u00a77to see detailed trades for a specific profession.");
            return true;
        }
        ValidationResult<String> professionResult = InputValidator.validateProfession(args[0]);
        if (professionResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + professionResult.getFirstError().orElse("Invalid profession"));
            sender.sendMessage("\u00a77Available professions: " + TradeRegistry.getAllProfessions().stream().map(TradeRegistry::getProfessionDisplayName).collect(Collectors.joining(", ")));
            return true;
        }
        String profession = professionResult.getValue();
        List<String> tradeIds = TradeRegistry.getTradesForProfession(profession);
        sender.sendMessage("\u00a76" + TradeRegistry.getProfessionDisplayName(profession) + " Trades:");
        Set<String> simpleNames = SimpleTradeMapper.getSimpleNames(profession);
        if (!simpleNames.isEmpty()) {
            sender.sendMessage("\u00a77Simple Names (recommended):");
            for (String simpleName : simpleNames) {
                String technicalId = SimpleTradeMapper.getTechnicalId(profession, simpleName);
                customPrice = this.tradeService.getCustomPrices().get(profession + "_" + technicalId);
                priceInfo = customPrice != null ? " \u00a77(Custom: \u00a7e" + customPrice + "\u00a77)" : "";
                sender.sendMessage("  \u00a7a" + simpleName + (String)priceInfo);
            }
            sender.sendMessage("");
        }
        sender.sendMessage("\u00a77Technical IDs:");
        for (String tradeId : tradeIds) {
            String description = TradeRegistry.getTradeDescription(tradeId);
            customPrice = this.tradeService.getCustomPrices().get(profession + "_" + tradeId);
            priceInfo = customPrice != null ? " \u00a77(Custom: \u00a7e" + customPrice + "\u00a77)" : "";
            sender.sendMessage("  \u00a77" + tradeId + ": \u00a7f" + description + (String)priceInfo);
        }
        sender.sendMessage("\u00a77Use \u00a7f/vtrade setprice " + profession + " <simple_name> <emerald_cost> \u00a77for simple commands.");
        sender.sendMessage("\u00a77Or \u00a7f/vtrade setprice " + profession + " <trade_id> <price> <emerald_cost> \u00a77for technical commands.");
        return true;
    }

    private boolean handleResetPriceCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /vtrade resetprice <profession> <trade_id>");
            sender.sendMessage("\u00a77Use \u00a7f/vtrade listtrades <profession> \u00a77to see available trades.");
            return true;
        }
        ValidationResult<String> professionResult = InputValidator.validateProfession(args[0]);
        if (professionResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + professionResult.getFirstError().orElse("Invalid profession"));
            return true;
        }
        ValidationResult<String> tradeIdResult = InputValidator.validateTradeIdForProfession(args[1], professionResult.getValue());
        if (tradeIdResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + tradeIdResult.getFirstError().orElse("Invalid trade ID"));
            sender.sendMessage("\u00a77Use \u00a7f/vtrade listtrades " + professionResult.getValue() + " \u00a77to see available trades.");
            return true;
        }
        String profession = professionResult.getValue();
        String tradeId = tradeIdResult.getValue();
        String priceKey = profession + "_" + tradeId;
        Integer removedPrice = this.tradeService.getCustomPrices().remove(priceKey);
        if (removedPrice != null) {
            try {
                this.tradeService.saveCustomPricesToFile(this.plugin.getPricesFile());
                String tradeDescription = TradeRegistry.getTradeDescription(tradeId);
                sender.sendMessage("\u00a7aReset price for \u00a77" + TradeRegistry.getProfessionDisplayName(profession) + " \u00a7f" + tradeDescription + " \u00a7ato default.");
            }
            catch (DatabaseException e) {
                sender.sendMessage("\u00a7cFailed to save price reset: " + e.getMessage());
                this.plugin.getLogger().severe("Failed to save price reset for " + profession + " " + tradeId + ": " + e.getMessage());
            }
        } else {
            sender.sendMessage("\u00a77No custom price was set for this trade.");
        }
        return true;
    }

    private List<String> getProfessionCompletions(String prefix) {
        List professions = TradeRegistry.getAllProfessions().stream().map(TradeRegistry::getProfessionDisplayName).collect(Collectors.toList());
        ArrayList<String> matches = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)prefix, professions, matches);
        Collections.sort(matches);
        return matches;
    }

    private List<String> getTradeCompletions(String profession, String prefix) {
        if (!TradeRegistry.isValidProfession(profession)) {
            return Collections.emptyList();
        }
        Set<String> simpleNames = SimpleTradeMapper.getSimpleNames(profession);
        ArrayList<String> matches = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)prefix, simpleNames, matches);
        Collections.sort(matches);
        return matches;
    }
}

