/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.commands.CommandHandler;
import com.alan.VillagerTradeManager.services.RestockService;
import com.alan.VillagerTradeManager.services.SettingsService;
import com.alan.VillagerTradeManager.validation.InputValidator;
import com.alan.VillagerTradeManager.validation.ValidationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class RestockCommandHandler
implements CommandHandler {
    private final RestockService restockService;
    private final SettingsService settingsService;

    public RestockCommandHandler(RestockService restockService, SettingsService settingsService) {
        this.restockService = restockService;
        this.settingsService = settingsService;
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        String subCommand = args[0].toLowerCase();
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (subCommand) {
            case "restock": {
                return this.handleRestockCommand(sender, subArgs);
            }
            case "restocktime": {
                return this.handleRestockTimeCommand(sender, subArgs);
            }
            case "restocklimit": {
                return this.handleRestockLimitCommand(sender, subArgs);
            }
            case "unlimitedrestock": {
                return this.handleUnlimitedRestockCommand(sender, subArgs);
            }
            case "instantrestock": {
                return this.handleInstantRestockCommand(sender, subArgs);
            }
        }
        return false;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 1) {
            List<String> completions = Arrays.asList("restock", "restocktime", "restocklimit", "unlimitedrestock", "instantrestock");
            ArrayList<String> matches = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[0], completions, matches);
            Collections.sort(matches);
            return matches;
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("restock") || args[0].equalsIgnoreCase("unlimitedrestock") || args[0].equalsIgnoreCase("instantrestock"))) {
            List<String> completions = Arrays.asList("on", "off", "status");
            ArrayList<String> matches = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[1], completions, matches);
            Collections.sort(matches);
            return matches;
        }
        return null;
    }

    private boolean handleRestockCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage("\u00a7cUsage: /villagertrade restock <on|off>");
            return true;
        }
        if (args[0].equalsIgnoreCase("on")) {
            this.restockService.setCustomRestockEnabled(true);
            this.settingsService.saveSettingToDatabase("custom_restock_enabled", "true");
            sender.sendMessage("\u00a7aCustom villager restock system enabled!");
            return true;
        }
        if (args[0].equalsIgnoreCase("off")) {
            this.restockService.setCustomRestockEnabled(false);
            this.settingsService.saveSettingToDatabase("custom_restock_enabled", "false");
            sender.sendMessage("\u00a7aCustom villager restock system disabled!");
            return true;
        }
        sender.sendMessage("\u00a7cUsage: /villagertrade restock <on|off>");
        return true;
    }

    private boolean handleRestockTimeCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage("\u00a7cUsage: /villagertrade restocktime <minutes>");
            sender.sendMessage("\u00a77Current restock time: \u00a7a" + this.restockService.getRestockIntervalMinutes() + " \u00a77minutes");
            return true;
        }
        ValidationResult<Integer> minutesResult = InputValidator.validateRestockMinutes(args[0]);
        if (minutesResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + minutesResult.getFirstError().orElse("Invalid restock time"));
            return true;
        }
        int minutes = minutesResult.getValue();
        this.restockService.setRestockIntervalMinutes(minutes);
        this.settingsService.saveSettingToDatabase("restock_interval_minutes", String.valueOf(minutes));
        sender.sendMessage("\u00a7aSet villager restock interval to \u00a7e" + minutes + " \u00a7aminutes.");
        return true;
    }

    private boolean handleRestockLimitCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage("\u00a7cUsage: /villagertrade restocklimit <count>");
            sender.sendMessage("\u00a77Current restock limit: \u00a7a" + this.restockService.getRestockLimitPerDay() + " \u00a77per day");
            return true;
        }
        ValidationResult<Integer> limitResult = InputValidator.validateRestockLimit(args[0]);
        if (limitResult.isInvalid()) {
            sender.sendMessage("\u00a7c" + limitResult.getFirstError().orElse("Invalid restock limit"));
            return true;
        }
        int limit = limitResult.getValue();
        this.restockService.setRestockLimitPerDay(limit);
        this.settingsService.saveSettingToDatabase("restock_limit_per_day", String.valueOf(limit));
        sender.sendMessage("\u00a7aSet villager restock limit to \u00a7e" + limit + " \u00a7aper day.");
        return true;
    }

    private boolean handleUnlimitedRestockCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage("\u00a7cUsage: /villagertrade unlimitedrestock <on|off>");
            return true;
        }
        if (args[0].equalsIgnoreCase("on")) {
            this.restockService.setUnlimitedRestock(true);
            this.settingsService.saveSettingToDatabase("unlimited_restock", "true");
            sender.sendMessage("\u00a7aUnlimited villager restock enabled!");
            return true;
        }
        if (args[0].equalsIgnoreCase("off")) {
            this.restockService.setUnlimitedRestock(false);
            this.settingsService.saveSettingToDatabase("unlimited_restock", "false");
            sender.sendMessage("\u00a7aUnlimited villager restock disabled!");
            return true;
        }
        sender.sendMessage("\u00a7cUsage: /villagertrade unlimitedrestock <on|off>");
        return true;
    }

    private boolean handleInstantRestockCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage("\u00a7cUsage: /villagertrade instantrestock <on|off>");
            return true;
        }
        if (args[0].equalsIgnoreCase("on")) {
            this.restockService.setInstantRestockEnabled(true);
            this.settingsService.saveSettingToDatabase("instant_restock_enabled", "true");
            sender.sendMessage("\u00a7aInstant villager restock enabled!");
            return true;
        }
        if (args[0].equalsIgnoreCase("off")) {
            this.restockService.setInstantRestockEnabled(false);
            this.settingsService.saveSettingToDatabase("instant_restock_enabled", "false");
            sender.sendMessage("\u00a7aInstant villager restock disabled!");
            return true;
        }
        sender.sendMessage("\u00a7cUsage: /villagertrade instantrestock <on|off>");
        return true;
    }
}

