/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.commands.CommandHandler;
import com.alan.VillagerTradeManager.services.TradeService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class TradeDataCommandHandler
implements CommandHandler {
    private final VillagerTradeManager plugin;
    private final TradeService tradeService;

    public TradeDataCommandHandler(VillagerTradeManager plugin, TradeService tradeService) {
        this.plugin = plugin;
        this.tradeService = tradeService;
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length == 0) {
            return false;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "exporttrades": {
                return this.handleExportTrades(sender, args);
            }
            case "importtrades": {
                return this.handleImportTrades(sender, args);
            }
            case "cleardynamictrades": {
                return this.handleClearDynamicTrades(sender, args);
            }
        }
        return false;
    }

    private boolean handleExportTrades(CommandSender sender, String[] args) {
        String format;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        String string = format = args.length > 1 ? args[1].toLowerCase() : "json";
        if (!format.equals("json") && !format.equals("yaml")) {
            sender.sendMessage("\u00a7cInvalid format! Use 'json' or 'yaml'.");
            return true;
        }
        try {
            File exportFile = new File(this.plugin.getDataFolder(), "trade_export_" + System.currentTimeMillis() + "." + format);
            HashMap<String, Object> exportData = new HashMap<String, Object>();
            exportData.put("export_timestamp", System.currentTimeMillis());
            exportData.put("plugin_version", this.plugin.getPluginMeta().getVersion());
            exportData.put("server_version", this.plugin.getServer().getVersion());
            exportData.put("custom_prices", this.tradeService.getCustomPrices());
            try {
                Map<String, Integer> dynamicStats = this.plugin.getDynamicTradeStorageService().getTradeStatistics().get();
                exportData.put("dynamic_trade_stats", dynamicStats);
            }
            catch (InterruptedException | ExecutionException e) {
                exportData.put("dynamic_trade_stats", "Export failed: " + e.getMessage());
            }
            try (FileWriter writer = new FileWriter(exportFile);){
                if (format.equals("json")) {
                    this.writeJsonExport(writer, exportData);
                } else {
                    this.writeYamlExport(writer, exportData);
                }
            }
            sender.sendMessage("\u00a7aTrade configuration exported to: \u00a7f" + exportFile.getName());
            sender.sendMessage("\u00a77File location: \u00a7f" + exportFile.getAbsolutePath());
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to export trade configuration: " + e.getMessage());
        }
        return true;
    }

    private void writeJsonExport(FileWriter writer, Map<String, Object> exportData) throws Exception {
        writer.write("{\n");
        writer.write("  \"export_info\": {\n");
        writer.write("    \"timestamp\": " + String.valueOf(exportData.get("export_timestamp")) + ",\n");
        writer.write("    \"plugin_version\": \"" + String.valueOf(exportData.get("plugin_version")) + "\",\n");
        writer.write("    \"server_version\": \"" + String.valueOf(exportData.get("server_version")) + "\"\n");
        writer.write("  },\n");
        writer.write("  \"custom_prices\": {\n");
        Map prices = (Map)exportData.get("custom_prices");
        int i = 0;
        for (Map.Entry entry : prices.entrySet()) {
            writer.write("    \"" + (String)entry.getKey() + "\": " + String.valueOf(entry.getValue()));
            if (i < prices.size() - 1) {
                writer.write(",");
            }
            writer.write("\n");
            ++i;
        }
        writer.write("  }\n");
        writer.write("}\n");
    }

    private void writeYamlExport(FileWriter writer, Map<String, Object> exportData) throws Exception {
        writer.write("# Villager Trade Manager Export\n");
        writer.write("# Generated: " + String.valueOf(new Date()) + "\n");
        writer.write("# Plugin Version: " + String.valueOf(exportData.get("plugin_version")) + "\n\n");
        writer.write("export_info:\n");
        writer.write("  timestamp: " + String.valueOf(exportData.get("export_timestamp")) + "\n");
        writer.write("  plugin_version: \"" + String.valueOf(exportData.get("plugin_version")) + "\"\n");
        writer.write("  server_version: \"" + String.valueOf(exportData.get("server_version")) + "\"\n\n");
        writer.write("custom_prices:\n");
        Map prices = (Map)exportData.get("custom_prices");
        for (Map.Entry entry : prices.entrySet()) {
            writer.write("  " + (String)entry.getKey() + ": " + String.valueOf(entry.getValue()) + "\n");
        }
    }

    private boolean handleImportTrades(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /vtrade importtrades <filename>");
            sender.sendMessage("\u00a77File should be in the plugin's data folder.");
            return true;
        }
        String filename = args[1];
        File importFile = new File(this.plugin.getDataFolder(), filename);
        if (!importFile.exists()) {
            sender.sendMessage("\u00a7cFile not found: \u00a7f" + filename);
            sender.sendMessage("\u00a77Files should be placed in: \u00a7f" + this.plugin.getDataFolder().getAbsolutePath());
            return true;
        }
        try {
            sender.sendMessage("\u00a76Importing trade configuration from: \u00a7f" + filename);
            String format = filename.toLowerCase().endsWith(".yaml") || filename.toLowerCase().endsWith(".yml") ? "yaml" : "json";
            Map<String, Object> importData = this.parseImportFile(importFile, format);
            if (importData == null) {
                sender.sendMessage("\u00a7cFailed to parse import file. Invalid format or corrupted file.");
                return true;
            }
            Map customPrices = (Map)importData.get("custom_prices");
            if (customPrices != null && !customPrices.isEmpty()) {
                this.tradeService.getCustomPrices().putAll(customPrices);
                sender.sendMessage("\u00a7aImported \u00a7f" + customPrices.size() + " \u00a7acustom prices.");
            } else {
                sender.sendMessage("\u00a77No custom prices found in import file.");
            }
            sender.sendMessage("\u00a7aTrade configuration imported successfully!");
            sender.sendMessage("\u00a77Imported by: \u00a7f" + sender.getName());
            sender.sendMessage("\u00a77Use \u00a7f/vtrade status \u00a77to verify the changes.");
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to import trade configuration: " + e.getMessage());
            this.plugin.getLogger().warning("Import error: " + e.getMessage());
        }
        return true;
    }

    private Map<String, Object> parseImportFile(File file, String format) throws Exception {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            if (format.equals("json")) {
                Map<String, Object> map = this.parseJsonImport(reader);
                return map;
            }
            Map<String, Object> map = this.parseYamlImport(reader);
            return map;
        }
    }

    private Map<String, Object> parseJsonImport(BufferedReader reader) throws Exception {
        String line;
        StringBuilder jsonContent = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            jsonContent.append(line);
        }
        String content = jsonContent.toString().trim();
        HashMap<String, Object> result = new HashMap<String, Object>();
        int pricesStart = content.indexOf("\"custom_prices\":");
        if (pricesStart != -1) {
            int braceStart = content.indexOf("{", pricesStart);
            int braceEnd = content.lastIndexOf("}");
            if (braceStart != -1 && braceEnd != -1 && braceEnd > braceStart) {
                String pricesSection = content.substring(braceStart + 1, braceEnd);
                Map<String, Integer> prices = this.parseJsonPrices(pricesSection);
                result.put("custom_prices", prices);
            }
        }
        return result;
    }

    private Map<String, Object> parseYamlImport(BufferedReader reader) throws Exception {
        String line;
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Integer> prices = new HashMap<String, Integer>();
        boolean inCustomPrices = false;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("custom_prices:")) {
                inCustomPrices = true;
                continue;
            }
            if (!inCustomPrices || line.isEmpty() || line.startsWith("#")) continue;
            if (line.startsWith("export_info:") || line.startsWith("dynamic_trade_stats:")) {
                inCustomPrices = false;
                continue;
            }
            int colonIndex = line.indexOf(":");
            if (colonIndex == -1) continue;
            String key = line.substring(0, colonIndex).trim();
            String valueStr = line.substring(colonIndex + 1).trim();
            try {
                int value = Integer.parseInt(valueStr);
                prices.put(key, value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        result.put("custom_prices", prices);
        return result;
    }

    private Map<String, Integer> parseJsonPrices(String pricesSection) {
        String[] entries;
        HashMap<String, Integer> prices = new HashMap<String, Integer>();
        for (String entry : entries = pricesSection.split(",")) {
            int colonIndex;
            if ((entry = entry.trim()).isEmpty() || (colonIndex = entry.indexOf(":")) == -1) continue;
            String key = entry.substring(0, colonIndex).trim();
            String valueStr = entry.substring(colonIndex + 1).trim();
            if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            try {
                int value = Integer.parseInt(valueStr);
                prices.put(key, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return prices;
    }

    private boolean handleClearDynamicTrades(CommandSender sender, String[] args) {
        sender.sendMessage("\u00a76=== Clearing Dynamic Trade Data ===");
        try {
            int clearedCount = this.plugin.getDynamicTradeStorageService().clearOldTrades(30).get();
            sender.sendMessage("\u00a7aCleared \u00a7f" + clearedCount + " \u00a7aold dynamic trade records.");
            this.plugin.getTradeCompletionService().refreshCache();
            sender.sendMessage("\u00a7aTrade completion cache refreshed.");
        }
        catch (InterruptedException | ExecutionException e) {
            sender.sendMessage("\u00a7cFailed to clear dynamic trade data: " + e.getMessage());
        }
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 2 && args[0].equalsIgnoreCase("exporttrades")) {
            List<String> completions = Arrays.asList("json", "yaml");
            ArrayList<String> matches = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[1], completions, matches);
            Collections.sort(matches);
            return matches;
        }
        return Collections.emptyList();
    }
}

