/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.commands.CommandHandler;
import com.alan.VillagerTradeManager.services.SettingsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class TradeDetectionCommandHandler
implements CommandHandler {
    private final SettingsService settingsService;

    public TradeDetectionCommandHandler(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /vtrade tradedetection <on|off|status>");
            boolean isEnabled = this.settingsService.getBooleanSetting("dynamic_trade_detection_enabled");
            sender.sendMessage("\u00a77Current status: " + (isEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
            return true;
        }
        String action = args[1].toLowerCase();
        if (action.equals("on")) {
            this.settingsService.saveSettingToDatabase("dynamic_trade_detection_enabled", "true");
            sender.sendMessage("\u00a7aDynamic trade detection enabled!");
        } else if (action.equals("off")) {
            this.settingsService.saveSettingToDatabase("dynamic_trade_detection_enabled", "false");
            sender.sendMessage("\u00a7aDynamic trade detection disabled!");
        } else if (action.equals("status")) {
            boolean isEnabled = this.settingsService.getBooleanSetting("dynamic_trade_detection_enabled");
            sender.sendMessage("\u00a77Dynamic trade detection is currently: " + (isEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        } else {
            sender.sendMessage("\u00a7cInvalid action! Use 'on', 'off', or 'status'.");
        }
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            List<String> completions = Arrays.asList("on", "off", "status");
            ArrayList<String> matches = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[1], completions, matches);
            Collections.sort(matches);
            return matches;
        }
        return Collections.emptyList();
    }
}

