/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.commands.AdminCommandHandler;
import com.alan.VillagerTradeManager.commands.AnalyzeTradesCommandHandler;
import com.alan.VillagerTradeManager.commands.BanItemCommandHandler;
import com.alan.VillagerTradeManager.commands.CommandRegistry;
import com.alan.VillagerTradeManager.commands.HelpCommandHandler;
import com.alan.VillagerTradeManager.commands.InspectVillagerCommandHandler;
import com.alan.VillagerTradeManager.commands.PriceCommandHandler;
import com.alan.VillagerTradeManager.commands.RestockCommandHandler;
import com.alan.VillagerTradeManager.commands.TradeDataCommandHandler;
import com.alan.VillagerTradeManager.commands.TradeDetectionCommandHandler;
import com.alan.VillagerTradeManager.commands.WanderingTraderCommandHandler;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import com.alan.VillagerTradeManager.services.RestockService;
import com.alan.VillagerTradeManager.services.SettingsService;
import com.alan.VillagerTradeManager.services.TradeService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;

public class VillagerTradeCommand
implements CommandExecutor,
TabCompleter {
    private final VillagerTradeManager plugin;
    private final SettingsService settingsService;
    private final TradeService tradeService;
    private final RestockService restockService;
    private final TaskScheduler taskScheduler;
    private final CommandRegistry commandRegistry;

    public VillagerTradeCommand(VillagerTradeManager plugin, SettingsService settingsService, TradeService tradeService, RestockService restockService, TaskScheduler taskScheduler) {
        this.plugin = plugin;
        this.settingsService = settingsService;
        this.tradeService = tradeService;
        this.restockService = restockService;
        this.taskScheduler = taskScheduler;
        this.commandRegistry = new CommandRegistry();
        this.registerCommandHandlers();
    }

    private void registerCommandHandlers() {
        this.commandRegistry.registerHandler("setprice", new PriceCommandHandler(this.plugin, this.tradeService));
        this.commandRegistry.registerHandler("listtrades", new PriceCommandHandler(this.plugin, this.tradeService));
        this.commandRegistry.registerHandler("resetprice", new PriceCommandHandler(this.plugin, this.tradeService));
        this.commandRegistry.registerHandler("restock", new RestockCommandHandler(this.restockService, this.settingsService));
        this.commandRegistry.registerHandler("restocktime", new RestockCommandHandler(this.restockService, this.settingsService));
        this.commandRegistry.registerHandler("restocklimit", new RestockCommandHandler(this.restockService, this.settingsService));
        this.commandRegistry.registerHandler("unlimitedrestock", new RestockCommandHandler(this.restockService, this.settingsService));
        this.commandRegistry.registerHandler("instantrestock", new RestockCommandHandler(this.restockService, this.settingsService));
        this.commandRegistry.registerHandler("on", new AdminCommandHandler(this.plugin, this.tradeService, this.restockService, this.settingsService));
        this.commandRegistry.registerHandler("off", new AdminCommandHandler(this.plugin, this.tradeService, this.restockService, this.settingsService));
        this.commandRegistry.registerHandler("status", new AdminCommandHandler(this.plugin, this.tradeService, this.restockService, this.settingsService));
        this.commandRegistry.registerHandler("memory", new AdminCommandHandler(this.plugin, this.tradeService, this.restockService, this.settingsService));
        this.commandRegistry.registerHandler("inspectvillager", new InspectVillagerCommandHandler(this.plugin, this.tradeService));
        this.commandRegistry.registerHandler("analyzetrades", new AnalyzeTradesCommandHandler(this.plugin, this.tradeService));
        TradeDataCommandHandler tradeDataHandler = new TradeDataCommandHandler(this.plugin, this.tradeService);
        this.commandRegistry.registerHandler("exporttrades", tradeDataHandler);
        this.commandRegistry.registerHandler("importtrades", tradeDataHandler);
        this.commandRegistry.registerHandler("cleardynamictrades", tradeDataHandler);
        this.commandRegistry.registerHandler("tradedetection", new TradeDetectionCommandHandler(this.settingsService));
        BanItemCommandHandler banItemHandler = new BanItemCommandHandler(this.settingsService);
        this.commandRegistry.registerHandler("banitem", banItemHandler);
        this.commandRegistry.registerHandler("unbanitem", banItemHandler);
        this.commandRegistry.registerHandler("listbanneditems", banItemHandler);
        this.commandRegistry.registerHandler("help", new HelpCommandHandler(this.plugin, this.taskScheduler));
        this.commandRegistry.registerHandler("wanderer", new WanderingTraderCommandHandler(this.plugin, this.plugin.getWanderingTraderService()));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /vtrade help");
            sender.sendMessage("\u00a77Current status: " + (this.tradeService.isTradeManagementEnabled() ? "\u00a7aActive" : "\u00a7cInactive"));
            return true;
        }
        String subCommand = args[0].toLowerCase();
        if (this.commandRegistry.isCommandRegistered(subCommand)) {
            return this.commandRegistry.handleCommand(sender, subCommand, args);
        }
        sender.sendMessage("\u00a7cUsage: /vtrade help");
        sender.sendMessage("\u00a77Current status: " + (this.tradeService.isTradeManagementEnabled() ? "\u00a7aActive" : "\u00a7cInactive"));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        List<String> completions;
        if (args.length == 1) {
            ArrayList<String> completions2 = new ArrayList<String>();
            List<String> commands = Arrays.asList("on", "off", "status", "setprice", "listtrades", "resetprice", "inspectvillager", "analyzetrades", "exporttrades", "importtrades", "cleardynamictrades", "tradedetection", "restock", "restocktime", "restocklimit", "unlimitedrestock", "instantrestock", "banitem", "unbanitem", "listbanneditems", "memory", "help", "wanderer");
            StringUtil.copyPartialMatches((String)args[0], commands, completions2);
            Collections.sort(completions2);
            return completions2;
        }
        String subCommand = args[0].toLowerCase();
        if (this.commandRegistry.isCommandRegistered(subCommand) && (completions = this.commandRegistry.getTabCompletions(sender, subCommand, args)) != null) {
            return completions;
        }
        return Collections.emptyList();
    }
}

