/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.commands;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.commands.CommandHandler;
import com.alan.VillagerTradeManager.exception.DatabaseException;
import com.alan.VillagerTradeManager.model.CustomTradeDefinition;
import com.alan.VillagerTradeManager.services.WanderingTraderService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class WanderingTraderCommandHandler
implements CommandHandler {
    private final VillagerTradeManager plugin;
    private final WanderingTraderService wanderingTraderService;

    public WanderingTraderCommandHandler(VillagerTradeManager plugin, WanderingTraderService wanderingTraderService) {
        this.plugin = plugin;
        this.wanderingTraderService = wanderingTraderService;
    }

    @Override
    public boolean handle(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length == 0 || !args[0].equalsIgnoreCase("wanderer")) {
            this.sendUsage(sender);
            return true;
        }
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        if (subArgs.length == 0) {
            this.sendUsage(sender);
            return true;
        }
        switch (subCommand = subArgs[0].toLowerCase()) {
            case "add": {
                return this.handleAdd(sender, Arrays.copyOfRange(subArgs, 1, subArgs.length));
            }
            case "list": {
                return this.handleList(sender);
            }
            case "remove": {
                return this.handleRemove(sender, Arrays.copyOfRange(subArgs, 1, subArgs.length));
            }
            case "clear": {
                return this.handleClear(sender);
            }
        }
        this.sendUsage(sender);
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        String prefix;
        if (args.length == 0) {
            return Collections.emptyList();
        }
        if (!args[0].equalsIgnoreCase("wanderer")) {
            return Collections.emptyList();
        }
        String string = prefix = args.length > 1 ? args[args.length - 1] : "";
        if (args.length == 1 || args.length == 2) {
            return this.getSubcommandCompletions(prefix);
        }
        String subCmd = args[1].toLowerCase();
        if (subCmd.equals("add")) {
            if (args.length == 3) {
                return this.getItemCompletions(prefix);
            }
            if (args.length == 4) {
                return Arrays.asList("1", "5", "10", "16", "32", "64");
            }
            if (args.length == 5) {
                return Arrays.asList("1", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "64");
            }
        } else if (subCmd.equals("remove") && args.length == 3) {
            return this.getExistingItemCompletions(prefix);
        }
        return Collections.emptyList();
    }

    private boolean handleAdd(CommandSender sender, String[] args) {
        int price;
        int quantity;
        if (args.length < 3) {
            sender.sendMessage("\u00a7cUsage: /vtrade wanderer add <item> <quantity> <price>");
            sender.sendMessage("\u00a77Example: /vtrade wanderer add diamond 5 32");
            return true;
        }
        String itemName = args[0];
        String quantityStr = args[1];
        String priceStr = args[2];
        Material material = Material.matchMaterial((String)itemName);
        if (material == null) {
            sender.sendMessage("\u00a7cInvalid item: " + itemName);
            sender.sendMessage("\u00a77Use tab completion to see valid items");
            return true;
        }
        try {
            quantity = Integer.parseInt(quantityStr);
            if (quantity <= 0 || quantity > 64) {
                sender.sendMessage("\u00a7cQuantity must be between 1 and 64");
                return true;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid quantity: " + quantityStr);
            return true;
        }
        try {
            price = Integer.parseInt(priceStr);
            if (price <= 0 || price > 64) {
                sender.sendMessage("\u00a7cPrice must be between 1 and 64 emeralds");
                return true;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid price: " + priceStr);
            return true;
        }
        try {
            this.wanderingTraderService.addTrade(material.name(), quantity, price);
            sender.sendMessage("\u00a7aAdded wandering trader trade: \u00a7f" + quantity + "x " + material.name() + " \u00a7afor \u00a7e" + price + " emeralds");
            sender.sendMessage("\u00a77This trade will apply to all future wandering traders");
        }
        catch (DatabaseException e) {
            sender.sendMessage("\u00a7cFailed to add trade: " + e.getMessage());
            this.plugin.getLogger().severe("Failed to add wandering trader trade: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage("\u00a7c" + e.getMessage());
        }
        return true;
    }

    private boolean handleList(CommandSender sender) {
        Collection<CustomTradeDefinition> trades = this.wanderingTraderService.getAllTrades();
        if (trades.isEmpty()) {
            sender.sendMessage("\u00a77No custom wandering trader trades defined");
            sender.sendMessage("\u00a77Use \u00a7f/vtrade wanderer add <item> <quantity> <price> \u00a77to add a trade");
            return true;
        }
        sender.sendMessage("\u00a76Wandering Trader Custom Trades \u00a77(" + trades.size() + "):");
        for (CustomTradeDefinition trade : trades) {
            sender.sendMessage("  \u00a7a" + trade.getQuantity() + "x " + trade.getItemType() + " \u00a77for \u00a7e" + trade.getEmeraldCost() + " emeralds");
        }
        sender.sendMessage("");
        sender.sendMessage("\u00a77Replace vanilla trades: " + (this.wanderingTraderService.isReplaceVanillaTrades() ? "\u00a7aYes" : "\u00a7cNo"));
        sender.sendMessage("\u00a77Max custom trades: \u00a7f" + this.wanderingTraderService.getMaxCustomTrades());
        return true;
    }

    private boolean handleRemove(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage("\u00a7cUsage: /vtrade wanderer remove <item>");
            sender.sendMessage("\u00a77Example: /vtrade wanderer remove diamond");
            return true;
        }
        String itemName = args[0];
        Material material = Material.matchMaterial((String)itemName);
        if (material == null) {
            sender.sendMessage("\u00a7cInvalid item: " + itemName);
            return true;
        }
        try {
            boolean removed = this.wanderingTraderService.removeTrade(material.name());
            if (removed) {
                sender.sendMessage("\u00a7aRemoved all trades for: \u00a7f" + material.name());
            } else {
                sender.sendMessage("\u00a77No trades found for: \u00a7f" + material.name());
            }
        }
        catch (DatabaseException e) {
            sender.sendMessage("\u00a7cFailed to remove trade: " + e.getMessage());
            this.plugin.getLogger().severe("Failed to remove wandering trader trade: " + e.getMessage());
        }
        return true;
    }

    private boolean handleClear(CommandSender sender) {
        try {
            int count = this.wanderingTraderService.clearAllTrades();
            if (count > 0) {
                sender.sendMessage("\u00a7aCleared " + count + " wandering trader trade(s)");
            } else {
                sender.sendMessage("\u00a77No trades to clear");
            }
        }
        catch (DatabaseException e) {
            sender.sendMessage("\u00a7cFailed to clear trades: " + e.getMessage());
            this.plugin.getLogger().severe("Failed to clear wandering trader trades: " + e.getMessage());
        }
        return true;
    }

    private void sendUsage(CommandSender sender) {
        sender.sendMessage("\u00a76Wandering Trader Commands:");
        sender.sendMessage("  \u00a7e/vtrade wanderer add <item> <quantity> <price> \u00a77- Add custom trade");
        sender.sendMessage("  \u00a7e/vtrade wanderer list \u00a77- List all custom trades");
        sender.sendMessage("  \u00a7e/vtrade wanderer remove <item> \u00a77- Remove trades for an item");
        sender.sendMessage("  \u00a7e/vtrade wanderer clear \u00a77- Remove all custom trades");
        sender.sendMessage("");
        sender.sendMessage("\u00a77Examples:");
        sender.sendMessage("  \u00a7f/vtrade wanderer add diamond 5 32");
        sender.sendMessage("  \u00a7f/vtrade wanderer add enchanted_book 1 45");
    }

    private List<String> getSubcommandCompletions(String prefix) {
        List<String> subcommands = Arrays.asList("add", "list", "remove", "clear");
        ArrayList<String> matches = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)prefix, subcommands, matches);
        Collections.sort(matches);
        return matches;
    }

    private List<String> getItemCompletions(String prefix) {
        List materials = Arrays.stream(Material.values()).filter(Material::isItem).map(m -> m.name().toLowerCase()).collect(Collectors.toList());
        ArrayList<String> matches = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)prefix, materials, matches);
        Collections.sort(matches);
        return matches.size() > 50 ? matches.subList(0, 50) : matches;
    }

    private List<String> getExistingItemCompletions(String prefix) {
        List existingItems = this.wanderingTraderService.getAllTrades().stream().map(t -> t.getItemType().toLowerCase()).distinct().collect(Collectors.toList());
        ArrayList<String> matches = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)prefix, existingItems, matches);
        Collections.sort(matches);
        return matches;
    }
}

