/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import com.alan.VillagerTradeManager.database.DatabaseException;
import com.alan.VillagerTradeManager.database.DatabaseType;
import org.bukkit.configuration.ConfigurationSection;

public class DatabaseConfig {
    private final DatabaseType type;
    private final SQLiteConfig sqliteConfig;
    private final SupabaseConfig supabaseConfig;
    private final PostgreSQLConfig postgresqlConfig;
    private final ConnectionPoolConfig connectionPoolConfig;

    public DatabaseConfig(ConfigurationSection config) throws DatabaseException {
        String typeString = config.getString("type", "sqlite").toLowerCase();
        try {
            this.type = DatabaseType.valueOf(typeString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new DatabaseException("Invalid database type: " + typeString + ". Supported types: sqlite, supabase, postgresql");
        }
        this.connectionPoolConfig = new ConnectionPoolConfig(config.getConfigurationSection("connection_pool"));
        switch (this.type) {
            case SQLITE: {
                this.sqliteConfig = new SQLiteConfig(config.getConfigurationSection("sqlite"));
                this.supabaseConfig = null;
                this.postgresqlConfig = null;
                break;
            }
            case SUPABASE: {
                this.supabaseConfig = new SupabaseConfig(config.getConfigurationSection("supabase"));
                this.sqliteConfig = null;
                this.postgresqlConfig = null;
                break;
            }
            case POSTGRESQL: {
                this.postgresqlConfig = new PostgreSQLConfig(config.getConfigurationSection("postgresql"));
                this.sqliteConfig = null;
                this.supabaseConfig = null;
                break;
            }
            default: {
                throw new DatabaseException("Unsupported database type: " + String.valueOf((Object)this.type));
            }
        }
    }

    public DatabaseType getType() {
        return this.type;
    }

    public SQLiteConfig getSqliteConfig() {
        return this.sqliteConfig;
    }

    public SupabaseConfig getSupabaseConfig() {
        return this.supabaseConfig;
    }

    public PostgreSQLConfig getPostgreSQLConfig() {
        return this.postgresqlConfig;
    }

    public ConnectionPoolConfig getConnectionPoolConfig() {
        return this.connectionPoolConfig;
    }

    public void validate() throws DatabaseException {
        if (this.connectionPoolConfig != null) {
            this.connectionPoolConfig.validate();
        }
        switch (this.type) {
            case SQLITE: {
                if (this.sqliteConfig == null) break;
                this.sqliteConfig.validate();
                break;
            }
            case SUPABASE: {
                if (this.supabaseConfig == null) break;
                this.supabaseConfig.validate();
                break;
            }
            case POSTGRESQL: {
                if (this.postgresqlConfig == null) break;
                this.postgresqlConfig.validate();
            }
        }
    }

    public static class ConnectionPoolConfig {
        private final int maximumPoolSize;
        private final int minimumIdle;
        private final long connectionTimeout;
        private final long idleTimeout;
        private final long maxLifetime;
        private final String poolName;

        public ConnectionPoolConfig(ConfigurationSection config) {
            if (config == null) {
                this.maximumPoolSize = 10;
                this.minimumIdle = 2;
                this.connectionTimeout = 30000L;
                this.idleTimeout = 600000L;
                this.maxLifetime = 1800000L;
                this.poolName = "VillagerTradeManagerPool";
            } else {
                this.maximumPoolSize = config.getInt("maximum_pool_size", 10);
                this.minimumIdle = config.getInt("minimum_idle", 2);
                this.connectionTimeout = config.getLong("connection_timeout", 30000L);
                this.idleTimeout = config.getLong("idle_timeout", 600000L);
                this.maxLifetime = config.getLong("max_lifetime", 1800000L);
                this.poolName = config.getString("pool_name", "VillagerTradeManagerPool");
            }
        }

        public int getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public int getMinimumIdle() {
            return this.minimumIdle;
        }

        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public long getIdleTimeout() {
            return this.idleTimeout;
        }

        public long getMaxLifetime() {
            return this.maxLifetime;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public void validate() throws DatabaseException {
            if (this.maximumPoolSize <= 0) {
                throw new DatabaseException("Maximum pool size must be positive");
            }
            if (this.minimumIdle < 0) {
                throw new DatabaseException("Minimum idle cannot be negative");
            }
            if (this.minimumIdle > this.maximumPoolSize) {
                throw new DatabaseException("Minimum idle cannot be greater than maximum pool size");
            }
            if (this.connectionTimeout <= 0L) {
                throw new DatabaseException("Connection timeout must be positive");
            }
            if (this.idleTimeout <= 0L) {
                throw new DatabaseException("Idle timeout must be positive");
            }
            if (this.maxLifetime <= 0L) {
                throw new DatabaseException("Max lifetime must be positive");
            }
        }
    }

    public static class SQLiteConfig {
        private final String file;

        public SQLiteConfig(ConfigurationSection config) {
            this.file = config == null ? "plugins/VillagerTradeManager/villager_data.db" : config.getString("file", "plugins/VillagerTradeManager/villager_data.db");
        }

        public String getFile() {
            return this.file;
        }

        public void validate() throws DatabaseException {
            if (this.file == null || this.file.trim().isEmpty()) {
                throw new DatabaseException("SQLite database file path cannot be empty");
            }
        }
    }

    public static class SupabaseConfig {
        private final String url;
        private final String apiKey;
        private final String serviceKey;
        private final String schema;

        public SupabaseConfig(ConfigurationSection config) throws DatabaseException {
            if (config == null) {
                throw new DatabaseException("Supabase configuration section is required when using supabase database type");
            }
            this.url = config.getString("url");
            this.apiKey = config.getString("apiKey");
            this.serviceKey = config.getString("serviceKey");
            this.schema = config.getString("schema", "public");
        }

        public String getUrl() {
            return this.url;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public String getServiceKey() {
            return this.serviceKey;
        }

        public String getSchema() {
            return this.schema;
        }

        public void validate() throws DatabaseException {
            if (this.url == null || this.url.trim().isEmpty()) {
                throw new DatabaseException("Supabase URL is required");
            }
            if (!this.url.startsWith("https://")) {
                throw new DatabaseException("Supabase URL must use HTTPS");
            }
            if (this.apiKey == null || this.apiKey.trim().isEmpty()) {
                throw new DatabaseException("Supabase API key is required");
            }
            if (this.serviceKey == null || this.serviceKey.trim().isEmpty()) {
                throw new DatabaseException("Supabase service key is required");
            }
            if (this.schema == null || this.schema.trim().isEmpty()) {
                throw new DatabaseException("Supabase schema cannot be empty");
            }
        }
    }

    public static class PostgreSQLConfig {
        private final String host;
        private final int port;
        private final String database;
        private final String username;
        private final String password;

        public PostgreSQLConfig(ConfigurationSection config) throws DatabaseException {
            if (config == null) {
                throw new DatabaseException("PostgreSQL configuration section is required when using postgresql database type");
            }
            this.host = config.getString("host");
            this.port = config.getInt("port", 5432);
            this.database = config.getString("database");
            this.username = config.getString("username");
            this.password = config.getString("password");
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getConnectionString() {
            return "jdbc:postgresql://" + this.host + ":" + this.port + "/" + this.database;
        }

        public void validate() throws DatabaseException {
            if (this.host == null || this.host.trim().isEmpty()) {
                throw new DatabaseException("PostgreSQL host is required");
            }
            if (this.port <= 0 || this.port > 65535) {
                throw new DatabaseException("PostgreSQL port must be between 1 and 65535");
            }
            if (this.database == null || this.database.trim().isEmpty()) {
                throw new DatabaseException("PostgreSQL database name is required");
            }
            if (this.username == null || this.username.trim().isEmpty()) {
                throw new DatabaseException("PostgreSQL username is required");
            }
            if (this.password == null) {
                throw new DatabaseException("PostgreSQL password is required");
            }
        }
    }
}

