/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import com.alan.VillagerTradeManager.database.DatabaseCapabilities;
import com.alan.VillagerTradeManager.database.DatabaseConfig;
import com.alan.VillagerTradeManager.database.DatabaseProvider;
import com.alan.VillagerTradeManager.database.DatabaseType;
import com.alan.VillagerTradeManager.database.PostgreSQLDatabaseProvider;
import com.alan.VillagerTradeManager.database.SQLiteDatabaseProvider;
import com.alan.VillagerTradeManager.database.SupabaseDatabaseProvider;
import com.alan.VillagerTradeManager.exception.DatabaseException;
import java.sql.Connection;
import java.util.concurrent.CompletableFuture;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class DatabaseManager {
    private final Plugin plugin;
    private DatabaseConfig config;
    private DatabaseProvider provider;
    private boolean initialized = false;

    public DatabaseManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public void initialize(ConfigurationSection databaseConfig) throws DatabaseException {
        if (this.initialized) {
            throw new DatabaseException("Database manager is already initialized");
        }
        try {
            this.config = new DatabaseConfig(databaseConfig);
            this.config.validate();
            this.provider = this.createProvider();
            boolean connectionTest = this.provider.testConnection().join();
            if (!connectionTest) {
                throw new DatabaseException("Failed to establish database connection during initialization");
            }
            this.initialized = true;
            if (this.plugin.getConfig().getBoolean("logging.startup_verbose", false)) {
                this.plugin.getLogger().info("Database manager initialized successfully with " + this.provider.getType().getDisplayName() + " provider");
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to initialize database manager: " + e.getMessage());
            throw new DatabaseException("Database initialization failed", e);
        }
    }

    private DatabaseProvider createProvider() throws DatabaseException {
        switch (this.config.getType()) {
            case SQLITE: {
                return new SQLiteDatabaseProvider(this.config);
            }
            case SUPABASE: {
                return new SupabaseDatabaseProvider(this.config.getSupabaseConfig());
            }
            case POSTGRESQL: {
                return new PostgreSQLDatabaseProvider(this.config);
            }
        }
        throw new DatabaseException("Unsupported database type: " + String.valueOf((Object)this.config.getType()));
    }

    public CompletableFuture<Connection> getConnection() {
        this.checkInitialized();
        return this.provider.getConnection();
    }

    public boolean isConnected() {
        return this.initialized && this.provider != null && this.provider.isConnected();
    }

    public DatabaseType getDatabaseType() {
        this.checkInitialized();
        return this.provider.getType();
    }

    public DatabaseCapabilities getCapabilities() {
        this.checkInitialized();
        return this.provider.getCapabilities();
    }

    public CompletableFuture<Boolean> testConnection() {
        this.checkInitialized();
        return this.provider.testConnection();
    }

    public String getConnectionString() {
        this.checkInitialized();
        return this.provider.getConnectionString();
    }

    public void shutdown() {
        if (this.provider != null) {
            this.provider.close();
        }
        this.initialized = false;
    }

    public DatabaseProvider getProvider() {
        this.checkInitialized();
        return this.provider;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Database manager is not initialized. Call initialize() first.");
        }
    }

    public DatabaseConfig getConfig() {
        return this.config;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

