/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import com.alan.VillagerTradeManager.database.DatabaseCapabilities;
import com.alan.VillagerTradeManager.database.DatabaseConfig;
import com.alan.VillagerTradeManager.database.DatabaseProvider;
import com.alan.VillagerTradeManager.database.DatabaseType;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;

public class PostgreSQLDatabaseProvider
implements DatabaseProvider {
    private final String connectionString;
    private final String username;
    private final String password;
    private HikariDataSource dataSource;

    public PostgreSQLDatabaseProvider(DatabaseConfig config) {
        DatabaseConfig.PostgreSQLConfig pgConfig = config.getPostgreSQLConfig();
        this.connectionString = pgConfig.getConnectionString();
        this.username = pgConfig.getUsername();
        this.password = pgConfig.getPassword();
        this.initializeDataSource(config.getConnectionPoolConfig());
    }

    private void initializeDataSource(DatabaseConfig.ConnectionPoolConfig poolConfig) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(this.connectionString);
        config.setUsername(this.username);
        config.setPassword(this.password);
        config.setDriverClassName("org.postgresql.Driver");
        config.setMaximumPoolSize(poolConfig.getMaximumPoolSize());
        config.setMinimumIdle(poolConfig.getMinimumIdle());
        config.setConnectionTimeout(poolConfig.getConnectionTimeout());
        config.setIdleTimeout(poolConfig.getIdleTimeout());
        config.setMaxLifetime(poolConfig.getMaxLifetime());
        config.setConnectionTestQuery("SELECT 1");
        config.setPoolName(poolConfig.getPoolName() + "_PostgreSQL");
        config.addDataSourceProperty("statement_timeout", (Object)"30000");
        config.addDataSourceProperty("idle_in_transaction_session_timeout", (Object)"30000");
        this.dataSource = new HikariDataSource(config);
    }

    @Override
    public DatabaseType getType() {
        return DatabaseType.POSTGRESQL;
    }

    @Override
    public CompletableFuture<Connection> getConnection() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to get PostgreSQL connection from pool", e);
            }
        });
    }

    @Override
    public boolean isConnected() {
        return this.dataSource != null && !this.dataSource.isClosed();
    }

    @Override
    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    @Override
    public String getConnectionString() {
        return this.connectionString;
    }

    @Override
    public CompletableFuture<Boolean> testConnection() {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block8: {
                Connection conn = this.dataSource.getConnection();
                try {
                    bl = conn.isValid(5);
                    if (conn == null) break block8;
                }
                catch (Throwable t$) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable x2) {
                                t$.addSuppressed(x2);
                            }
                        }
                        throw t$;
                    }
                    catch (SQLException e) {
                        return false;
                    }
                }
                conn.close();
            }
            return bl;
        });
    }

    @Override
    public DatabaseCapabilities getCapabilities() {
        return DatabaseCapabilities.postgresql();
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("PostgreSQL JDBC driver not found", e);
        }
    }
}

