/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import com.alan.VillagerTradeManager.exception.DatabaseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SupabaseClient {
    private final OkHttpClient httpClient;
    private final String baseUrl;
    private final String apiKey;
    private final String serviceKey;
    private final String schema;
    private final ObjectMapper objectMapper;

    public SupabaseClient(String baseUrl, String apiKey, String serviceKey, String schema) {
        this.baseUrl = baseUrl.replaceAll("/$", "");
        this.apiKey = apiKey;
        this.serviceKey = serviceKey;
        this.schema = schema;
        this.objectMapper = new ObjectMapper();
        this.httpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).addInterceptor((Interceptor)new SupabaseAuthInterceptor(apiKey)).build();
    }

    public CompletableFuture<SupabaseResponse> select(String table, Map<String, Object> filters) {
        Object url = this.buildUrl(table);
        if (filters != null && !filters.isEmpty()) {
            url = (String)url + this.buildQueryString(filters);
        }
        Request request = new Request.Builder().url((String)url).get().build();
        return this.executeRequest(request);
    }

    public CompletableFuture<SupabaseResponse> insert(String table, Object data) {
        return this.executeMutation("POST", table, data);
    }

    public CompletableFuture<SupabaseResponse> update(String table, Object data, Map<String, Object> filters) {
        Object url = this.buildUrl(table);
        if (filters != null && !filters.isEmpty()) {
            url = (String)url + this.buildQueryString(filters);
        }
        return this.executeMutation("PATCH", (String)url, data);
    }

    public CompletableFuture<SupabaseResponse> delete(String table, Map<String, Object> filters) {
        Object url = this.buildUrl(table);
        if (filters != null && !filters.isEmpty()) {
            url = (String)url + this.buildQueryString(filters);
        }
        Request request = new Request.Builder().url((String)url).delete().build();
        return this.executeRequest(request);
    }

    private CompletableFuture<SupabaseResponse> executeMutation(String method, String tableOrUrl, Object data) {
        try {
            String jsonData = this.objectMapper.writeValueAsString(data);
            RequestBody body = RequestBody.create((String)jsonData, (MediaType)MediaType.parse((String)"application/json"));
            Request.Builder builder = new Request.Builder();
            if (tableOrUrl.startsWith("http")) {
                builder.url(tableOrUrl);
            } else {
                builder.url(this.buildUrl(tableOrUrl));
            }
            Request request = builder.method(method, body).build();
            return this.executeRequest(request);
        }
        catch (Exception e) {
            CompletableFuture<SupabaseResponse> future = new CompletableFuture<SupabaseResponse>();
            future.completeExceptionally(new DatabaseException("Failed to serialize request data", "executeMutation", e));
            return future;
        }
    }

    private CompletableFuture<SupabaseResponse> executeRequest(Request request) {
        return CompletableFuture.supplyAsync(() -> {
            SupabaseResponse supabaseResponse;
            block8: {
                Response response = this.httpClient.newCall(request).execute();
                try {
                    String responseBody = response.body() != null ? response.body().string() : "";
                    supabaseResponse = new SupabaseResponse(response.code(), responseBody, response.headers());
                    if (response == null) break block8;
                }
                catch (Throwable t$) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable x2) {
                                t$.addSuppressed(x2);
                            }
                        }
                        throw t$;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(new DatabaseException("HTTP request failed", "executeRequest", e));
                    }
                }
                response.close();
            }
            return supabaseResponse;
        });
    }

    private String buildUrl(String table) {
        Object urlBase = this.baseUrl;
        if (!this.baseUrl.contains("/rest/v1/")) {
            urlBase = this.baseUrl + "/rest/v1";
        }
        return String.format("%s/%s?select=*", urlBase, table);
    }

    private String buildQueryString(Map<String, Object> filters) {
        StringBuilder query = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Object> entry : filters.entrySet()) {
            if (first) {
                query.append("&");
                first = false;
            } else {
                query.append("&");
            }
            query.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return query.toString();
    }

    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    private static class SupabaseAuthInterceptor
    implements Interceptor {
        private final String apiKey;

        public SupabaseAuthInterceptor(String apiKey) {
            this.apiKey = apiKey;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request().newBuilder().addHeader("apikey", this.apiKey).addHeader("Authorization", "Bearer " + this.apiKey).addHeader("Content-Type", "application/json").addHeader("Prefer", "return=representation").build();
            return chain.proceed(request);
        }
    }

    public static class SupabaseResponse {
        private final int statusCode;
        private final String body;
        private final Headers headers;

        public SupabaseResponse(int statusCode, String body, Headers headers) {
            this.statusCode = statusCode;
            this.body = body;
            this.headers = headers;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getBody() {
            return this.body;
        }

        public Headers getHeaders() {
            return this.headers;
        }

        public boolean isSuccessful() {
            return this.statusCode >= 200 && this.statusCode < 300;
        }
    }
}

