/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.database;

import com.alan.VillagerTradeManager.database.DatabaseCapabilities;
import com.alan.VillagerTradeManager.database.DatabaseConfig;
import com.alan.VillagerTradeManager.database.DatabaseProvider;
import com.alan.VillagerTradeManager.database.DatabaseType;
import com.alan.VillagerTradeManager.database.SupabaseClient;
import com.alan.VillagerTradeManager.exception.DatabaseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class SupabaseDatabaseProvider
implements DatabaseProvider {
    private final SupabaseClient supabaseClient;
    private final String connectionString;
    private final ObjectMapper objectMapper;
    private boolean connected = false;

    public SupabaseDatabaseProvider(DatabaseConfig.SupabaseConfig config) {
        this.supabaseClient = new SupabaseClient(config.getUrl(), config.getApiKey(), config.getServiceKey(), config.getSchema());
        this.connectionString = config.getUrl();
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public DatabaseType getType() {
        return DatabaseType.SUPABASE;
    }

    @Override
    public CompletableFuture<Connection> getConnection() {
        return CompletableFuture.completedFuture(new SupabaseConnection(this));
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void close() {
        this.supabaseClient.close();
        this.connected = false;
    }

    @Override
    public String getConnectionString() {
        return this.connectionString;
    }

    @Override
    public CompletableFuture<Boolean> testConnection() {
        return ((CompletableFuture)this.supabaseClient.select("settings", null).thenApply(response -> {
            boolean success;
            this.connected = success = response.isSuccessful();
            return success;
        })).exceptionally(throwable -> {
            this.connected = false;
            return false;
        });
    }

    @Override
    public DatabaseCapabilities getCapabilities() {
        return DatabaseCapabilities.supabase();
    }

    public CompletableFuture<SupabaseResultSet> executeQuery(String table, Map<String, Object> filters) {
        return this.supabaseClient.select(table, filters).thenApply(response -> {
            if (!response.isSuccessful()) {
                throw new RuntimeException(new DatabaseException("Query failed with status: " + response.getStatusCode(), "executeQuery"));
            }
            try {
                JsonNode jsonNode = this.objectMapper.readTree(response.getBody());
                return new SupabaseResultSet(jsonNode);
            }
            catch (Exception e) {
                throw new RuntimeException(new DatabaseException("Failed to parse response", "executeQuery", e));
            }
        });
    }

    public CompletableFuture<Integer> executeInsert(String table, Map<String, Object> data) {
        return this.supabaseClient.insert(table, data).thenApply(response -> {
            if (!response.isSuccessful()) {
                throw new RuntimeException(new DatabaseException("Insert failed with status: " + response.getStatusCode(), "executeInsert"));
            }
            return 1;
        });
    }

    public CompletableFuture<Integer> executeUpdate(String table, Map<String, Object> data, Map<String, Object> filters) {
        return this.supabaseClient.update(table, data, filters).thenApply(response -> {
            if (!response.isSuccessful()) {
                throw new RuntimeException(new DatabaseException("Update failed with status: " + response.getStatusCode(), "executeUpdate"));
            }
            try {
                JsonNode jsonNode = this.objectMapper.readTree(response.getBody());
                return jsonNode.size();
            }
            catch (Exception e) {
                return 1;
            }
        });
    }

    public CompletableFuture<Integer> executeDelete(String table, Map<String, Object> filters) {
        return this.supabaseClient.delete(table, filters).thenApply(response -> {
            if (!response.isSuccessful()) {
                throw new RuntimeException(new DatabaseException("Delete failed with status: " + response.getStatusCode(), "executeDelete"));
            }
            return 1;
        });
    }

    private static class SupabaseConnection
    implements Connection {
        private final SupabaseDatabaseProvider provider;

        public SupabaseConnection(SupabaseDatabaseProvider provider) {
            this.provider = provider;
        }

        @Override
        public Statement createStatement() {
            throw new UnsupportedOperationException("Supabase doesn't support JDBC Statement");
        }

        @Override
        public PreparedStatement prepareStatement(String sql) {
            throw new UnsupportedOperationException("Supabase doesn't support JDBC PreparedStatement");
        }

        @Override
        public void close() {
            this.provider.close();
        }

        @Override
        public boolean isClosed() {
            return !this.provider.isConnected();
        }

        @Override
        public boolean isValid(int timeout) {
            return this.provider.isConnected();
        }

        @Override
        public void setAutoCommit(boolean autoCommit) {
        }

        @Override
        public boolean getAutoCommit() {
            return true;
        }

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public Savepoint setSavepoint() {
            return null;
        }

        @Override
        public Savepoint setSavepoint(String name) {
            return null;
        }

        @Override
        public void rollback(Savepoint savepoint) {
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) {
        }

        @Override
        public CallableStatement prepareCall(String sql) {
            return null;
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) {
            return null;
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
            return null;
        }

        @Override
        public String nativeSQL(String sql) {
            return sql;
        }

        @Override
        public void setReadOnly(boolean readOnly) {
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public void setCatalog(String catalog) {
        }

        @Override
        public String getCatalog() {
            return null;
        }

        @Override
        public void setTransactionIsolation(int level) {
        }

        @Override
        public int getTransactionIsolation() {
            return 0;
        }

        @Override
        public SQLWarning getWarnings() {
            return null;
        }

        @Override
        public void clearWarnings() {
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) {
            return null;
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
            return null;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) {
            return null;
        }

        @Override
        public Clob createClob() {
            return null;
        }

        @Override
        public Blob createBlob() {
            return null;
        }

        @Override
        public NClob createNClob() {
            return null;
        }

        @Override
        public SQLXML createSQLXML() {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return null;
        }

        @Override
        public DatabaseMetaData getMetaData() {
            return null;
        }

        @Override
        public void setSchema(String schema) {
        }

        @Override
        public String getSchema() {
            return null;
        }

        @Override
        public void abort(Executor executor) {
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) {
        }

        @Override
        public int getNetworkTimeout() {
            return 0;
        }

        @Override
        public void setClientInfo(String name, String value) {
        }

        @Override
        public void setClientInfo(Properties properties) {
        }

        @Override
        public String getClientInfo(String name) {
            return null;
        }

        @Override
        public Properties getClientInfo() {
            return null;
        }

        @Override
        public int getHoldability() {
            return 1;
        }

        @Override
        public void setHoldability(int holdability) {
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) {
        }

        @Override
        public Map<String, Class<?>> getTypeMap() {
            return null;
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) {
            return null;
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) {
            return null;
        }
    }

    public static class SupabaseResultSet {
        private final JsonNode data;
        private int currentIndex = -1;

        public SupabaseResultSet(JsonNode data) {
            this.data = data;
        }

        public boolean next() {
            ++this.currentIndex;
            return this.currentIndex < this.data.size();
        }

        public String getString(String columnLabel) {
            if (this.currentIndex >= 0 && this.currentIndex < this.data.size()) {
                JsonNode row = this.data.get(this.currentIndex);
                JsonNode value = row.get(columnLabel);
                return value != null ? value.asText() : null;
            }
            return null;
        }

        public int getInt(String columnLabel) {
            if (this.currentIndex >= 0 && this.currentIndex < this.data.size()) {
                JsonNode row = this.data.get(this.currentIndex);
                JsonNode value = row.get(columnLabel);
                return value != null ? value.asInt() : 0;
            }
            return 0;
        }

        public long getLong(String columnLabel) {
            if (this.currentIndex >= 0 && this.currentIndex < this.data.size()) {
                JsonNode row = this.data.get(this.currentIndex);
                JsonNode value = row.get(columnLabel);
                return value != null ? value.asLong() : 0L;
            }
            return 0L;
        }

        public int size() {
            return this.data.size();
        }
    }
}

