/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.exception;

import com.alan.VillagerTradeManager.exception.VillagerTradeException;

public class DatabaseException
extends VillagerTradeException {
    private final String tableName;
    private final String queryType;

    public DatabaseException(String message) {
        super(message, "Database", null, false);
        this.tableName = null;
        this.queryType = null;
    }

    public DatabaseException(String message, Throwable cause) {
        super(message, "Database", null, false, cause);
        this.tableName = null;
        this.queryType = null;
    }

    public DatabaseException(String message, String operation) {
        super(message, "Database", operation, false);
        this.tableName = null;
        this.queryType = null;
    }

    public DatabaseException(String message, String operation, Throwable cause) {
        super(message, "Database", operation, false, cause);
        this.tableName = null;
        this.queryType = null;
    }

    public DatabaseException(String message, String operation, String tableName) {
        super(message, "Database", operation, false);
        this.tableName = tableName;
        this.queryType = null;
    }

    public DatabaseException(String message, String operation, String tableName, Throwable cause) {
        super(message, "Database", operation, false, cause);
        this.tableName = tableName;
        this.queryType = null;
    }

    public DatabaseException(String message, String operation, String tableName, String queryType) {
        super(message, "Database", operation, false);
        this.tableName = tableName;
        this.queryType = queryType;
    }

    public DatabaseException(String message, String operation, String tableName, String queryType, Throwable cause) {
        super(message, "Database", operation, false, cause);
        this.tableName = tableName;
        this.queryType = queryType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getQueryType() {
        return this.queryType;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        if (this.tableName != null) {
            sb.append(" [Table: ").append(this.tableName).append("]");
        }
        if (this.queryType != null) {
            sb.append(" [Query Type: ").append(this.queryType).append("]");
        }
        return sb.toString();
    }
}

