/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.exception;

public class VillagerTradeException
extends Exception {
    private final String component;
    private final String operation;
    private final boolean recoverable;

    public VillagerTradeException(String message) {
        super(message);
        this.component = null;
        this.operation = null;
        this.recoverable = false;
    }

    public VillagerTradeException(String message, Throwable cause) {
        super(message, cause);
        this.component = null;
        this.operation = null;
        this.recoverable = false;
    }

    public VillagerTradeException(String message, String component, String operation) {
        super(message);
        this.component = component;
        this.operation = operation;
        this.recoverable = false;
    }

    public VillagerTradeException(String message, String component, String operation, Throwable cause) {
        super(message, cause);
        this.component = component;
        this.operation = operation;
        this.recoverable = false;
    }

    public VillagerTradeException(String message, String component, String operation, boolean recoverable) {
        super(message);
        this.component = component;
        this.operation = operation;
        this.recoverable = recoverable;
    }

    public VillagerTradeException(String message, String component, String operation, boolean recoverable, Throwable cause) {
        super(message, cause);
        this.component = component;
        this.operation = operation;
        this.recoverable = recoverable;
    }

    public String getComponent() {
        return this.component;
    }

    public String getOperation() {
        return this.operation;
    }

    public boolean isRecoverable() {
        return this.recoverable;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        if (this.component != null) {
            sb.append(" [Component: ").append(this.component).append("]");
        }
        if (this.operation != null) {
            sb.append(" [Operation: ").append(this.operation).append("]");
        }
        if (this.recoverable) {
            sb.append(" [Recoverable: true]");
        }
        return sb.toString();
    }
}

