/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.hooks;

import org.bukkit.entity.Villager;

public class LevelUpEventData {
    private final Villager villager;
    private final int oldLevel;
    private final int newLevel;
    private final int xpEarned;
    private final int totalXpEarned;
    private final long timestamp;

    public LevelUpEventData(Villager villager, int oldLevel, int newLevel, int xpEarned, int totalXpEarned) {
        this.villager = villager;
        this.oldLevel = oldLevel;
        this.newLevel = newLevel;
        this.xpEarned = xpEarned;
        this.totalXpEarned = totalXpEarned;
        this.timestamp = System.currentTimeMillis();
    }

    public Villager getVillager() {
        return this.villager;
    }

    public int getOldLevel() {
        return this.oldLevel;
    }

    public int getNewLevel() {
        return this.newLevel;
    }

    public int getXpEarned() {
        return this.xpEarned;
    }

    public int getTotalXpEarned() {
        return this.totalXpEarned;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getVillagerProfession() {
        if (this.villager.getProfession() == null) {
            return "none";
        }
        try {
            return this.villager.getProfession().getKey().getKey().toLowerCase();
        }
        catch (Exception e) {
            return this.villager.getProfession().toString().toLowerCase();
        }
    }

    public String getVillagerId() {
        return this.villager.getUniqueId().toString();
    }
}

