/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.hooks;

import org.bukkit.entity.Villager;

public class StockEventData {
    private final Villager villager;
    private final String profession;
    private final String tradeId;
    private final int oldStock;
    private final int newStock;
    private final String changeReason;
    private final long timestamp;

    public StockEventData(Villager villager, String profession, String tradeId, int oldStock, int newStock, String changeReason) {
        this.villager = villager;
        this.profession = profession;
        this.tradeId = tradeId;
        this.oldStock = oldStock;
        this.newStock = newStock;
        this.changeReason = changeReason;
        this.timestamp = System.currentTimeMillis();
    }

    public Villager getVillager() {
        return this.villager;
    }

    public String getProfession() {
        return this.profession;
    }

    public String getTradeId() {
        return this.tradeId;
    }

    public int getOldStock() {
        return this.oldStock;
    }

    public int getNewStock() {
        return this.newStock;
    }

    public int getStockChange() {
        return this.newStock - this.oldStock;
    }

    public String getChangeReason() {
        return this.changeReason;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getVillagerId() {
        return this.villager.getUniqueId().toString();
    }

    public boolean isStockIncrease() {
        return this.newStock > this.oldStock;
    }

    public boolean isStockDecrease() {
        return this.newStock < this.oldStock;
    }

    public boolean isOutOfStock() {
        return this.newStock <= 0;
    }
}

