/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.hooks;

import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class TradeEventData {
    private final Player player;
    private final Villager villager;
    private final MerchantRecipe recipe;
    private final ItemStack result;
    private final int tradeTier;
    private final double xpAwarded;
    private final long timestamp;

    public TradeEventData(Player player, Villager villager, MerchantRecipe recipe, ItemStack result, int tradeTier, double xpAwarded) {
        this.player = player;
        this.villager = villager;
        this.recipe = recipe;
        this.result = result.clone();
        this.tradeTier = tradeTier;
        this.xpAwarded = xpAwarded;
        this.timestamp = System.currentTimeMillis();
    }

    public Player getPlayer() {
        return this.player;
    }

    public Villager getVillager() {
        return this.villager;
    }

    public MerchantRecipe getRecipe() {
        return this.recipe;
    }

    public ItemStack getResult() {
        return this.result.clone();
    }

    public int getTradeTier() {
        return this.tradeTier;
    }

    public double getXpAwarded() {
        return this.xpAwarded;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getVillagerProfession() {
        if (this.villager.getProfession() == null) {
            return "none";
        }
        try {
            return this.villager.getProfession().getKey().getKey().toLowerCase();
        }
        catch (Exception e) {
            return this.villager.getProfession().toString().toLowerCase();
        }
    }

    public int getVillagerLevel() {
        return this.villager.getVillagerLevel();
    }
}

