/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.hooks;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.hooks.LevelUpEventData;
import com.alan.VillagerTradeManager.hooks.StockEventData;
import com.alan.VillagerTradeManager.hooks.TradeEventData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class TradeHookManager {
    private final VillagerTradeManager plugin;
    private final List<Consumer<TradeEventData>> tradeHooks;
    private final List<Consumer<LevelUpEventData>> levelUpHooks;
    private final List<Consumer<StockEventData>> stockHooks;

    public TradeHookManager(VillagerTradeManager plugin) {
        this.plugin = plugin;
        this.tradeHooks = new ArrayList<Consumer<TradeEventData>>();
        this.levelUpHooks = new ArrayList<Consumer<LevelUpEventData>>();
        this.stockHooks = new ArrayList<Consumer<StockEventData>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTradeHook(Consumer<TradeEventData> hook) {
        List<Consumer<TradeEventData>> list = this.tradeHooks;
        synchronized (list) {
            this.tradeHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLevelUpHook(Consumer<LevelUpEventData> hook) {
        List<Consumer<LevelUpEventData>> list = this.levelUpHooks;
        synchronized (list) {
            this.levelUpHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStockHook(Consumer<StockEventData> hook) {
        List<Consumer<StockEventData>> list = this.stockHooks;
        synchronized (list) {
            this.stockHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTradeHook(Consumer<TradeEventData> hook) {
        List<Consumer<TradeEventData>> list = this.tradeHooks;
        synchronized (list) {
            this.tradeHooks.remove(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterLevelUpHook(Consumer<LevelUpEventData> hook) {
        List<Consumer<LevelUpEventData>> list = this.levelUpHooks;
        synchronized (list) {
            this.levelUpHooks.remove(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterStockHook(Consumer<StockEventData> hook) {
        List<Consumer<StockEventData>> list = this.stockHooks;
        synchronized (list) {
            this.stockHooks.remove(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTradeEvent(Player player, Villager villager, MerchantRecipe recipe, ItemStack result, int tradeTier, double xpAwarded) {
        ArrayList<Consumer<TradeEventData>> hooksCopy;
        TradeEventData eventData = new TradeEventData(player, villager, recipe, result, tradeTier, xpAwarded);
        List<Consumer<TradeEventData>> list = this.tradeHooks;
        synchronized (list) {
            hooksCopy = new ArrayList<Consumer<TradeEventData>>(this.tradeHooks);
        }
        for (Consumer consumer : hooksCopy) {
            try {
                consumer.accept(eventData);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Exception in trade hook: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireLevelUpEvent(Villager villager, int oldLevel, int newLevel, int xpEarned, int totalXpEarned) {
        ArrayList<Consumer<LevelUpEventData>> hooksCopy;
        LevelUpEventData eventData = new LevelUpEventData(villager, oldLevel, newLevel, xpEarned, totalXpEarned);
        List<Consumer<LevelUpEventData>> list = this.levelUpHooks;
        synchronized (list) {
            hooksCopy = new ArrayList<Consumer<LevelUpEventData>>(this.levelUpHooks);
        }
        for (Consumer consumer : hooksCopy) {
            try {
                consumer.accept(eventData);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Exception in level up hook: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStockEvent(Villager villager, String profession, String tradeId, int oldStock, int newStock, String changeReason) {
        ArrayList<Consumer<StockEventData>> hooksCopy;
        StockEventData eventData = new StockEventData(villager, profession, tradeId, oldStock, newStock, changeReason);
        List<Consumer<StockEventData>> list = this.stockHooks;
        synchronized (list) {
            hooksCopy = new ArrayList<Consumer<StockEventData>>(this.stockHooks);
        }
        for (Consumer consumer : hooksCopy) {
            try {
                consumer.accept(eventData);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Exception in stock hook: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTradeHookCount() {
        List<Consumer<TradeEventData>> list = this.tradeHooks;
        synchronized (list) {
            return this.tradeHooks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLevelUpHookCount() {
        List<Consumer<LevelUpEventData>> list = this.levelUpHooks;
        synchronized (list) {
            return this.levelUpHooks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStockHookCount() {
        List<Consumer<StockEventData>> list = this.stockHooks;
        synchronized (list) {
            return this.stockHooks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllHooks() {
        List<Consumer<Object>> list = this.tradeHooks;
        synchronized (list) {
            this.tradeHooks.clear();
        }
        list = this.levelUpHooks;
        synchronized (list) {
            this.levelUpHooks.clear();
        }
        list = this.stockHooks;
        synchronized (list) {
            this.stockHooks.clear();
        }
    }
}

