/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.listeners;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.events.VillagerLevelUpEvent;
import com.alan.VillagerTradeManager.events.VillagerTradeEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;

public class CustomEventListener
implements Listener {
    private final VillagerTradeManager plugin;

    public CustomEventListener(VillagerTradeManager plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        MerchantRecipe selectedRecipe;
        if (!(event.getInventory() instanceof MerchantInventory)) {
            return;
        }
        MerchantInventory merchantInv = (MerchantInventory)event.getInventory();
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Villager villager = (Villager)merchantInv.getHolder();
        if (villager == null) {
            return;
        }
        if (event.getSlotType() == InventoryType.SlotType.RESULT && (selectedRecipe = merchantInv.getSelectedRecipe()) != null) {
            this.fireVillagerTradeEvent(player, villager, selectedRecipe);
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (this.hasRecentVillagerInteraction(player)) {
            this.plugin.getLogger().fine("Player " + player.getName() + " picked up item that might be a trade result");
        }
    }

    private void fireVillagerTradeEvent(Player player, Villager villager, MerchantRecipe recipe) {
        try {
            int tradeTier = Math.min(villager.getVillagerLevel(), 5);
            int xpAwarded = this.calculateXpForTrade(recipe, tradeTier);
            VillagerTradeEvent tradeEvent = new VillagerTradeEvent(player, villager, recipe, recipe.getResult(), tradeTier, xpAwarded);
            Bukkit.getPluginManager().callEvent((Event)tradeEvent);
            if (this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
                this.plugin.getLogger().fine("Fired VillagerTradeEvent for player " + player.getName() + " with villager " + String.valueOf(villager.getUniqueId()));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to fire villager trade event: " + e.getMessage());
        }
    }

    private boolean hasRecentVillagerInteraction(Player player) {
        return player.getNearbyEntities(10.0, 10.0, 10.0).stream().anyMatch(entity -> entity instanceof Villager);
    }

    private int calculateXpForTrade(MerchantRecipe recipe, int tradeTier) {
        int baseXp = switch (tradeTier) {
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
            case 4 -> 5;
            case 5 -> 8;
            default -> 1;
        };
        long emeraldCost = recipe.getIngredients().stream().filter(item -> item.getType().toString().contains("EMERALD")).mapToLong(item -> item.getAmount()).sum();
        return baseXp + (int)(emeraldCost / 2L);
    }

    public void fireVillagerLevelUpEvent(Villager villager, int oldLevel, int newLevel, int xpEarned, int totalXpEarned) {
        try {
            VillagerLevelUpEvent levelUpEvent = new VillagerLevelUpEvent(villager, oldLevel, newLevel, xpEarned, totalXpEarned);
            Bukkit.getPluginManager().callEvent((Event)levelUpEvent);
            if (this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
                this.plugin.getLogger().fine("Fired VillagerLevelUpEvent for villager " + String.valueOf(villager.getUniqueId()) + " from level " + oldLevel + " to " + newLevel);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to fire villager level up event: " + e.getMessage());
        }
    }
}

