/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.listeners;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.platform.PlatformService;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import com.alan.VillagerTradeManager.services.ReputationService;
import com.alan.VillagerTradeManager.services.RestockService;
import com.alan.VillagerTradeManager.services.TradeService;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.potion.PotionEffectType;

public class VillagerTradeListener
implements Listener {
    private final VillagerTradeManager plugin;
    private final TradeService tradeService;
    private final RestockService restockService;
    private final PlatformService platformService;
    private final ReputationService reputationService;

    public VillagerTradeListener(VillagerTradeManager plugin, TradeService tradeService, RestockService restockService, PlatformService platformService, ReputationService reputationService) {
        this.plugin = plugin;
        this.tradeService = tradeService;
        this.restockService = restockService;
        this.platformService = platformService;
        this.reputationService = reputationService;
    }

    @EventHandler
    public void onVillagerInteract(PlayerInteractEntityEvent event) {
        if (!this.tradeService.isTradeManagementEnabled()) {
            return;
        }
        if (event.getRightClicked().getType() == EntityType.VILLAGER) {
            Player player = event.getPlayer();
            this.tradeService.removeHeroEffect(player);
            Villager villager = (Villager)event.getRightClicked();
            if (this.restockService.isInstantRestockEnabled()) {
                TaskScheduler taskScheduler = this.plugin.getTaskScheduler();
                this.platformService.executeRegionSafeForEntity(taskScheduler, (Entity)villager, () -> this.restockService.handleInstantRestock(villager, this.platformService, taskScheduler));
            }
        }
    }

    @EventHandler
    public void onVillagerTransform(EntityTransformEvent event) {
        if (!this.tradeService.isTradeManagementEnabled()) {
            return;
        }
        if (event.getEntity().getType() == EntityType.VILLAGER && event.getTransformReason() == EntityTransformEvent.TransformReason.CURED) {
            Villager villager = (Villager)event.getEntity();
        }
    }

    @EventHandler
    public void onVillagerDeath(EntityDeathEvent event) {
        EntityDamageByEntityEvent damageEvent;
        Villager villager;
        if (!this.tradeService.isTradeManagementEnabled()) {
            return;
        }
        if (event.getEntity().getType() == EntityType.VILLAGER && (villager = (Villager)event.getEntity()).hasPotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE) && event.getEntity().getLastDamageCause() instanceof EntityDamageByEntityEvent && (damageEvent = (EntityDamageByEntityEvent)event.getEntity().getLastDamageCause()).getDamager() instanceof Player) {
            Player killer = (Player)damageEvent.getDamager();
            this.reputationService.recordHeroVillagerKill(killer.getUniqueId());
        }
    }

    @EventHandler
    public void onRaidFinish(RaidFinishEvent event) {
        if (!this.tradeService.isTradeManagementEnabled() || !this.tradeService.hasRaidEvents()) {
            return;
        }
        for (Player player : event.getWinners()) {
            this.reputationService.recordRaidParticipation(player.getUniqueId());
            if (!this.tradeService.hasHeroOfTheVillageEffect()) continue;
            this.tradeService.removeHeroEffect(player);
        }
    }

    public void cleanup() {
        this.plugin.getLogger().fine("VillagerTradeListener cleanup completed - event handlers will be unregistered automatically by Bukkit");
    }
}

