/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.listeners;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import com.alan.VillagerTradeManager.services.WanderingTraderService;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;

public class WanderingTraderListener
implements Listener {
    private final VillagerTradeManager plugin;
    private final WanderingTraderService wanderingTraderService;
    private final TaskScheduler taskScheduler;

    public WanderingTraderListener(VillagerTradeManager plugin, WanderingTraderService wanderingTraderService, TaskScheduler taskScheduler) {
        this.plugin = plugin;
        this.wanderingTraderService = wanderingTraderService;
        this.taskScheduler = taskScheduler;
    }

    @EventHandler
    public void onWanderingTraderSpawn(CreatureSpawnEvent event) {
        if (event.getEntity().getType() != EntityType.WANDERING_TRADER) {
            return;
        }
        if (!this.wanderingTraderService.isEnabled()) {
            return;
        }
        WanderingTrader trader = (WanderingTrader)event.getEntity();
        this.taskScheduler.runSyncLater(() -> {
            this.wanderingTraderService.applyCustomTrades(trader);
            if (this.plugin.getConfig().getBoolean("logging.debug_trades", false)) {
                this.plugin.getLogger().fine("Applied custom trades to wandering trader at " + trader.getLocation().getBlockX() + ", " + trader.getLocation().getBlockY() + ", " + trader.getLocation().getBlockZ());
            }
        }, 1L);
    }

    @EventHandler
    public void onPlayerInteractWanderingTrader(PlayerInteractEntityEvent event) {
        boolean needsCustomTrades;
        if (event.getRightClicked().getType() != EntityType.WANDERING_TRADER) {
            return;
        }
        if (!this.wanderingTraderService.isEnabled()) {
            return;
        }
        WanderingTrader trader = (WanderingTrader)event.getRightClicked();
        boolean bl = needsCustomTrades = trader.getRecipes().isEmpty() || !this.wanderingTraderService.isReplaceVanillaTrades();
        if (needsCustomTrades) {
            this.wanderingTraderService.applyCustomTrades(trader);
        }
    }
}

