/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.platform;

import com.alan.VillagerTradeManager.scheduler.BukkitSchedulerWrapper;
import com.alan.VillagerTradeManager.scheduler.FoliaScheduler;
import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class PlatformService {
    private final Plugin plugin;
    private PlatformType detectedPlatform;
    private TaskScheduler scheduler;

    public PlatformService(Plugin plugin) {
        this.plugin = plugin;
        this.detectPlatform();
        this.initializeScheduler();
    }

    private void detectPlatform() {
        String serverName = Bukkit.getName();
        String version = Bukkit.getVersion();
        if (this.plugin.getConfig().getBoolean("logging.startup_verbose", false)) {
            this.plugin.getLogger().info("Server Name: " + (serverName != null ? serverName : "null"));
            this.plugin.getLogger().info("Server Version: " + (version != null ? version : "null"));
        }
        if (this.isFolia()) {
            this.detectedPlatform = PlatformType.FOLIA;
            if (this.plugin.getConfig().getBoolean("logging.startup_verbose", false)) {
                this.plugin.getLogger().info("Platform Detected: Folia (Region Threaded)");
            }
            return;
        }
        if (this.isPurpur()) {
            this.detectedPlatform = PlatformType.PURPUR;
            if (this.plugin.getConfig().getBoolean("logging.startup_verbose", false)) {
                this.plugin.getLogger().info("Platform Detected: Purpur");
            }
            return;
        }
        if (this.isPaper()) {
            this.detectedPlatform = PlatformType.PAPER;
            if (this.plugin.getConfig().getBoolean("logging.startup_verbose", false)) {
                this.plugin.getLogger().info("Platform Detected: Paper");
            }
            return;
        }
        this.detectedPlatform = PlatformType.SPIGOT;
        if (this.plugin.getConfig().getBoolean("logging.startup_verbose", false)) {
            this.plugin.getLogger().info("Platform Detected: Spigot/Bukkit");
        }
    }

    private boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            String serverName = Bukkit.getName();
            if (serverName != null && serverName.contains("Folia")) {
                return true;
            }
            String version = Bukkit.getVersion();
            return version != null && version.contains("Folia");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isPaper() {
        String serverName = Bukkit.getName();
        String version = Bukkit.getVersion();
        boolean hasPaper = serverName != null && serverName.contains("Paper");
        boolean noFolia = serverName == null || !serverName.contains("Folia");
        boolean versionNoFolia = version == null || !version.contains("Folia");
        return hasPaper && noFolia && versionNoFolia;
    }

    private boolean isPurpur() {
        String serverName = Bukkit.getName();
        String version = Bukkit.getVersion();
        return serverName != null && serverName.contains("Purpur") || version != null && version.contains("Purpur");
    }

    private void initializeScheduler() {
        switch (this.detectedPlatform.ordinal()) {
            case 0: {
                try {
                    this.scheduler = new FoliaScheduler(this.plugin);
                    if (!this.plugin.getConfig().getBoolean("logging.startup_verbose", false)) break;
                    this.plugin.getLogger().info("Scheduler: Folia RegionScheduler initialized");
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to initialize Folia scheduler, falling back to Bukkit: " + e.getMessage());
                    this.scheduler = new BukkitSchedulerWrapper(this.plugin);
                    if (!this.plugin.getConfig().getBoolean("logging.startup_verbose", false)) break;
                    this.plugin.getLogger().info("Scheduler: BukkitScheduler fallback initialized");
                }
                break;
            }
            default: {
                this.scheduler = new BukkitSchedulerWrapper(this.plugin);
                if (!this.plugin.getConfig().getBoolean("logging.startup_verbose", false)) break;
                this.plugin.getLogger().info("Scheduler: BukkitScheduler initialized");
            }
        }
    }

    public PlatformType getDetectedPlatform() {
        return this.detectedPlatform;
    }

    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    public boolean isFoliaPlatform() {
        return this.detectedPlatform == PlatformType.FOLIA;
    }

    public void executeRegionSafe(TaskScheduler taskScheduler, Location location, Runnable runnable) {
        if (this.isFoliaPlatform() && location != null) {
            taskScheduler.runSyncAtLocation(location, runnable);
        } else {
            runnable.run();
        }
    }

    public void executeRegionSafeForEntity(TaskScheduler taskScheduler, Entity entity, Runnable runnable) {
        if (this.isFoliaPlatform() && entity != null) {
            taskScheduler.runSyncForEntity(entity, runnable);
        } else {
            runnable.run();
        }
    }

    public static enum PlatformType {
        FOLIA,
        PAPER,
        PURPUR,
        SPIGOT;

    }
}

