/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.scheduler;

import com.alan.VillagerTradeManager.scheduler.TaskScheduler;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class FoliaScheduler
implements TaskScheduler {
    private final Plugin plugin;

    public FoliaScheduler(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be null");
        }
        this.plugin = plugin;
    }

    @Override
    public void runSync(Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        try {
            Bukkit.getGlobalRegionScheduler().execute(this.plugin, task);
        }
        catch (Exception e) {
            try {
                Bukkit.getScheduler().runTask(this.plugin, task);
            }
            catch (Exception fallbackException) {
                this.plugin.getLogger().warning("Failed to schedule sync task: " + fallbackException.getMessage());
            }
        }
    }

    @Override
    public void runSyncLater(Runnable task, long delayTicks) {
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        if (delayTicks < 0L) {
            throw new IllegalArgumentException("Delay ticks cannot be negative");
        }
        try {
            Bukkit.getGlobalRegionScheduler().runDelayed(this.plugin, scheduledTask -> task.run(), delayTicks);
        }
        catch (Exception e) {
            try {
                Bukkit.getScheduler().runTaskLater(this.plugin, task, delayTicks);
            }
            catch (Exception fallbackException) {
                this.plugin.getLogger().warning("Failed to schedule delayed sync task: " + fallbackException.getMessage());
            }
        }
    }

    @Override
    public void runSyncRepeating(Runnable task, long delayTicks, long periodTicks) {
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        if (delayTicks < 0L) {
            throw new IllegalArgumentException("Delay ticks cannot be negative");
        }
        if (periodTicks <= 0L) {
            throw new IllegalArgumentException("Period ticks must be positive");
        }
        try {
            Bukkit.getGlobalRegionScheduler().runAtFixedRate(this.plugin, scheduledTask -> task.run(), delayTicks, periodTicks);
        }
        catch (Exception e) {
            try {
                Bukkit.getScheduler().runTaskTimer(this.plugin, task, delayTicks, periodTicks);
            }
            catch (Exception fallbackException) {
                this.plugin.getLogger().warning("Failed to schedule repeating sync task: " + fallbackException.getMessage());
            }
        }
    }

    @Override
    public void runAsync(Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        try {
            Bukkit.getAsyncScheduler().runNow(this.plugin, scheduledTask -> task.run());
        }
        catch (Exception e) {
            try {
                Bukkit.getScheduler().runTaskAsynchronously(this.plugin, task);
            }
            catch (Exception fallbackException) {
                this.plugin.getLogger().warning("Failed to schedule async task: " + fallbackException.getMessage());
            }
        }
    }

    @Override
    public void runAsyncLater(Runnable task, long delayTicks) {
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        if (delayTicks < 0L) {
            throw new IllegalArgumentException("Delay ticks cannot be negative");
        }
        long delayMillis = delayTicks * 50L;
        try {
            Bukkit.getAsyncScheduler().runDelayed(this.plugin, scheduledTask -> task.run(), delayMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            try {
                Bukkit.getScheduler().runTaskLaterAsynchronously(this.plugin, task, delayTicks);
            }
            catch (Exception fallbackException) {
                this.plugin.getLogger().warning("Failed to schedule async delayed task: " + fallbackException.getMessage());
            }
        }
    }

    @Override
    public void runAsyncRepeating(Runnable task, long delayTicks, long periodTicks) {
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        if (delayTicks < 0L) {
            throw new IllegalArgumentException("Delay ticks cannot be negative");
        }
        if (periodTicks <= 0L) {
            throw new IllegalArgumentException("Period ticks must be positive");
        }
        long delayMillis = delayTicks * 50L;
        long periodMillis = periodTicks * 50L;
        try {
            Bukkit.getAsyncScheduler().runAtFixedRate(this.plugin, scheduledTask -> task.run(), delayMillis, periodMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            try {
                Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, task, delayTicks, periodTicks);
            }
            catch (Exception fallbackException) {
                this.plugin.getLogger().warning("Failed to schedule async repeating task: " + fallbackException.getMessage());
            }
        }
    }

    @Override
    public void runSyncForEntity(Entity entity, Runnable task) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        try {
            entity.getScheduler().run(this.plugin, scheduledTask -> task.run(), null);
        }
        catch (Exception e) {
            try {
                this.runSync(task);
            }
            catch (Exception fallbackException) {
                this.plugin.getLogger().warning("Failed to schedule sync task for entity: " + fallbackException.getMessage());
            }
        }
    }

    @Override
    public void runSyncLaterForEntity(Entity entity, Runnable task, long delayTicks) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        if (delayTicks < 0L) {
            throw new IllegalArgumentException("Delay ticks cannot be negative");
        }
        try {
            entity.getScheduler().runDelayed(this.plugin, scheduledTask -> task.run(), null, delayTicks);
        }
        catch (Exception e) {
            try {
                this.runSyncLater(task, delayTicks);
            }
            catch (Exception fallbackException) {
                this.plugin.getLogger().warning("Failed to schedule delayed sync task for entity: " + fallbackException.getMessage());
            }
        }
    }

    @Override
    public void runSyncAtLocation(Location location, Runnable task) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        try {
            Bukkit.getRegionScheduler().run(this.plugin, location, scheduledTask -> task.run());
        }
        catch (Exception e) {
            try {
                this.runSync(task);
            }
            catch (Exception fallbackException) {
                this.plugin.getLogger().warning("Failed to schedule sync task at location: " + fallbackException.getMessage());
            }
        }
    }

    @Override
    public void runSyncLaterAtLocation(Location location, Runnable task, long delayTicks) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        if (delayTicks < 0L) {
            throw new IllegalArgumentException("Delay ticks cannot be negative");
        }
        try {
            Bukkit.getRegionScheduler().runDelayed(this.plugin, location, scheduledTask -> task.run(), delayTicks);
        }
        catch (Exception e) {
            try {
                this.runSyncLater(task, delayTicks);
            }
            catch (Exception fallbackException) {
                this.plugin.getLogger().warning("Failed to schedule delayed sync task at location: " + fallbackException.getMessage());
            }
        }
    }

    @Override
    public void cancelAllTasks() {
        try {
            Bukkit.getGlobalRegionScheduler().cancelTasks(this.plugin);
            Bukkit.getAsyncScheduler().cancelTasks(this.plugin);
        }
        catch (Exception e) {
            Bukkit.getScheduler().cancelTasks(this.plugin);
        }
    }

    @Override
    public String getSchedulerName() {
        return "FoliaRegionScheduler";
    }
}

