/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.services.PerformanceMonitorService;
import com.alan.VillagerTradeManager.services.SimpleTradeMapper;
import com.alan.VillagerTradeManager.services.TradeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class DynamicTradeDetector {
    private final TradeRegistry tradeRegistry;
    private final SimpleTradeMapper simpleTradeMapper;
    private final PerformanceMonitorService performanceMonitor;
    private final Logger logger;
    private final Map<String, String> hashCache = new ConcurrentHashMap<String, String>();
    private static final int MAX_CACHE_SIZE = 10000;
    private final Map<String, DetectedTrade> tradeCache = new ConcurrentHashMap<String, DetectedTrade>();
    private final Map<String, Long> cacheTimestamps = new ConcurrentHashMap<String, Long>();
    private static final long CACHE_TTL_MS = 300000L;

    public DynamicTradeDetector(TradeRegistry tradeRegistry, SimpleTradeMapper simpleTradeMapper, PerformanceMonitorService performanceMonitor, Logger logger) {
        this.tradeRegistry = tradeRegistry;
        this.simpleTradeMapper = simpleTradeMapper;
        this.performanceMonitor = performanceMonitor;
        this.logger = logger;
    }

    public void cleanupExpiredCache() {
        long currentTime = System.currentTimeMillis();
        this.cacheTimestamps.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 300000L);
        this.tradeCache.keySet().removeIf(tradeId -> !this.cacheTimestamps.containsKey(tradeId));
        if (this.hashCache.size() > 10000) {
            int toRemove = this.hashCache.size() / 5;
            this.hashCache.keySet().stream().limit(toRemove).forEach(this.hashCache::remove);
        }
    }

    public List<DetectedTrade> scanVillagerTrades(Villager villager) {
        ArrayList<DetectedTrade> detectedTrades;
        block3: {
            detectedTrades = new ArrayList<DetectedTrade>();
            try {
                List recipes = villager.getRecipes();
                for (MerchantRecipe recipe : recipes) {
                    DetectedTrade detectedTrade = this.analyzeTrade(recipe, villager);
                    if (detectedTrade == null) continue;
                    detectedTrades.add(detectedTrade);
                }
            }
            catch (Exception e) {
                if (this.logger == null) break block3;
                this.logger.warning("Error scanning villager trades: " + e.getMessage());
            }
        }
        return detectedTrades;
    }

    public DetectedTrade detectTrade(Villager villager, MerchantRecipe recipe) {
        return this.analyzeTrade(recipe, villager);
    }

    private DetectedTrade analyzeTrade(MerchantRecipe recipe, Villager villager) {
        try {
            List ingredients = recipe.getIngredients();
            ItemStack result = recipe.getResult();
            if (ingredients.isEmpty() || result == null) {
                return null;
            }
            if (villager.getProfession() == null) {
                return null;
            }
            String professionKey = null;
            try {
                if (villager.getProfession().getKey() != null) {
                    professionKey = villager.getProfession().getKey().getKey().toLowerCase();
                }
            }
            catch (Exception e) {
                if (this.logger != null) {
                    this.logger.warning("Failed to get profession key: " + e.getMessage());
                }
                return null;
            }
            if (professionKey == null) {
                return null;
            }
            String tradeId = this.generateTradeId(professionKey, villager.getVillagerLevel(), ingredients, result);
            String knownTradeId = TradeRegistry.identifyTrade(professionKey, result, ingredients);
            boolean isKnown = knownTradeId != null;
            String simpleName = this.generateSimpleName(professionKey, result, ingredients, tradeId);
            return new DetectedTrade(tradeId, professionKey, villager.getVillagerLevel(), ingredients, result, recipe.getUses(), recipe.getMaxUses(), isKnown, knownTradeId, simpleName);
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.warning("Error analyzing trade: " + e.getMessage());
            }
            return null;
        }
    }

    private String generateTradeId(String profession, int level, List<ItemStack> ingredients, ItemStack result) {
        StringBuilder content = new StringBuilder(256);
        content.append(profession).append("_").append(level).append("_");
        ingredients.stream().map(this::itemToString).sorted().forEach(s -> content.append((String)s).append(","));
        content.append("_");
        content.append(this.itemToString(result));
        String hash = this.generateHash(content.toString());
        return profession + "_l" + level + "_" + hash;
    }

    private String itemToString(ItemStack item) {
        if (item == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(item.getType().name().toLowerCase());
        sb.append(":").append(item.getAmount());
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (item.getType() == Material.ENCHANTED_BOOK && meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)meta;
                esm.getStoredEnchants().forEach((ench, level) -> sb.append("_").append(ench.getKey().getKey()).append(":").append(level));
            } else if (meta.hasEnchants()) {
                meta.getEnchants().forEach((ench, level) -> sb.append("_").append(ench.getKey().getKey()).append(":").append(level));
            }
        }
        return sb.toString();
    }

    private String generateHash(String content) {
        String hash;
        String cachedHash = this.hashCache.get(content);
        if (cachedHash != null) {
            if (this.performanceMonitor != null) {
                this.performanceMonitor.recordHashComputation(true);
            }
            return cachedHash;
        }
        if (this.performanceMonitor != null) {
            this.performanceMonitor.recordHashComputation(false);
        }
        if ((hash = Integer.toHexString(content.hashCode())).length() < 8) {
            hash = String.format("%8s", hash).replace(' ', '0');
        } else if (hash.length() > 8) {
            hash = hash.substring(0, 8);
        }
        if (this.hashCache.size() < 10000) {
            this.hashCache.put(content, hash);
        }
        return hash;
    }

    private String generateSimpleName(String profession, ItemStack result, List<ItemStack> ingredients, String tradeId) {
        String existingName = SimpleTradeMapper.getSimpleName(profession, tradeId);
        if (existingName != null) {
            return existingName;
        }
        Object baseName = result.getType().name().toLowerCase().replace("_", "");
        if (result.hasItemMeta()) {
            ItemMeta meta = result.getItemMeta();
            if (result.getType() == Material.ENCHANTED_BOOK && meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)meta;
                if (esm.hasStoredEnchants()) {
                    Map.Entry firstEnchant = esm.getStoredEnchants().entrySet().iterator().next();
                    baseName = ((Enchantment)firstEnchant.getKey()).getKey().getKey().toLowerCase() + "_" + String.valueOf(firstEnchant.getValue());
                }
            } else if (meta.hasEnchants()) {
                Map.Entry firstEnchant = meta.getEnchants().entrySet().iterator().next();
                baseName = (String)baseName + "_" + ((Enchantment)firstEnchant.getKey()).getKey().getKey().toLowerCase() + "_" + String.valueOf(firstEnchant.getValue());
            }
        }
        if (SimpleTradeMapper.hasSimpleName(profession, (String)baseName)) {
            baseName = (String)baseName + "_" + tradeId.substring(tradeId.length() - 4);
        }
        return baseName;
    }

    public static class DetectedTrade {
        private final String tradeId;
        private final String profession;
        private final int level;
        private final List<ItemStack> ingredients;
        private final ItemStack result;
        private final int uses;
        private final int maxUses;
        private final boolean isKnown;
        private final String knownTradeId;
        private final String simpleName;

        public DetectedTrade(String tradeId, String profession, int level, List<ItemStack> ingredients, ItemStack result, int uses, int maxUses, boolean isKnown, String knownTradeId, String simpleName) {
            this.tradeId = tradeId;
            this.profession = profession;
            this.level = level;
            this.ingredients = new ArrayList<ItemStack>(ingredients);
            this.result = result.clone();
            this.uses = uses;
            this.maxUses = maxUses;
            this.isKnown = isKnown;
            this.knownTradeId = knownTradeId;
            this.simpleName = simpleName;
        }

        public String getTradeId() {
            return this.tradeId;
        }

        public String getProfession() {
            return this.profession;
        }

        public int getLevel() {
            return this.level;
        }

        public List<ItemStack> getIngredients() {
            return new ArrayList<ItemStack>(this.ingredients);
        }

        public ItemStack getResult() {
            return this.result.clone();
        }

        public int getUses() {
            return this.uses;
        }

        public int getMaxUses() {
            return this.maxUses;
        }

        public boolean isKnown() {
            return this.isKnown;
        }

        public String getKnownTradeId() {
            return this.knownTradeId;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public String toString() {
            return String.format("DetectedTrade{id=%s, profession=%s, level=%d, result=%s, known=%s, simpleName=%s}", this.tradeId, this.profession, this.level, this.result.getType().name(), this.isKnown, this.simpleName);
        }
    }
}

