/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.database.DatabaseProvider;
import com.alan.VillagerTradeManager.exception.DatabaseException;
import com.alan.VillagerTradeManager.services.DatabaseService;
import com.alan.VillagerTradeManager.services.DynamicTradeDetector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class DynamicTradeStorageService {
    private final VillagerTradeManager plugin;
    private final DatabaseProvider databaseProvider;
    private final DatabaseService databaseService;

    public DynamicTradeStorageService(VillagerTradeManager plugin, DatabaseProvider databaseProvider, DatabaseService databaseService) {
        this.plugin = plugin;
        this.databaseProvider = databaseProvider;
        this.databaseService = databaseService;
    }

    public CompletableFuture<Void> storeDetectedTrade(DynamicTradeDetector.DetectedTrade detectedTrade) {
        return this.databaseService.executeAsync(() -> {
            try {
                this.databaseService.executeUpdate("INSERT OR REPLACE INTO dynamic_trades (trade_id, profession, level, input_item, input_amount, output_item, output_amount, simple_name, detected_at, last_seen, custom_price) VALUES (?, ?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, ?)", pstmt -> {
                    pstmt.setString(1, detectedTrade.getTradeId());
                    pstmt.setString(2, detectedTrade.getProfession());
                    pstmt.setInt(3, detectedTrade.getLevel());
                    pstmt.setString(4, this.itemToStorageString(detectedTrade.getIngredients().get(0)));
                    pstmt.setInt(5, detectedTrade.getIngredients().get(0).getAmount());
                    pstmt.setString(6, this.itemToStorageString(detectedTrade.getResult()));
                    pstmt.setInt(7, detectedTrade.getResult().getAmount());
                    pstmt.setString(8, detectedTrade.getSimpleName());
                    Integer customPrice = this.getCustomPriceForTrade(detectedTrade.getTradeId());
                    if (customPrice != null) {
                        pstmt.setInt(9, customPrice);
                    } else {
                        pstmt.setNull(9, 4);
                    }
                }, "storeDetectedTrade");
                if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                    this.plugin.getLogger().fine("Stored dynamic trade: " + detectedTrade.getTradeId());
                }
                return null;
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }, "storeDetectedTrade");
    }

    public CompletableFuture<Void> storeDetectedTradesBatch(List<DynamicTradeDetector.DetectedTrade> detectedTrades) {
        if (detectedTrades.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.databaseService.executeAsync(() -> {
            try {
                this.databaseService.executeInTransaction(conn -> {
                    String sql = "INSERT OR REPLACE INTO dynamic_trades (trade_id, profession, level, input_item, input_amount, output_item, output_amount, simple_name, detected_at, last_seen, custom_price) VALUES (?, ?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, ?)";
                    try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                        int batchSize = 0;
                        int MAX_BATCH_SIZE = 50;
                        for (DynamicTradeDetector.DetectedTrade detectedTrade : detectedTrades) {
                            pstmt.setString(1, detectedTrade.getTradeId());
                            pstmt.setString(2, detectedTrade.getProfession());
                            pstmt.setInt(3, detectedTrade.getLevel());
                            pstmt.setString(4, this.itemToStorageString(detectedTrade.getIngredients().get(0)));
                            pstmt.setInt(5, detectedTrade.getIngredients().get(0).getAmount());
                            pstmt.setString(6, this.itemToStorageString(detectedTrade.getResult()));
                            pstmt.setInt(7, detectedTrade.getResult().getAmount());
                            pstmt.setString(8, detectedTrade.getSimpleName());
                            Integer customPrice = this.getCustomPriceForTrade(detectedTrade.getTradeId());
                            if (customPrice != null) {
                                pstmt.setInt(9, customPrice);
                            } else {
                                pstmt.setNull(9, 4);
                            }
                            pstmt.addBatch();
                            if (++batchSize < 50) continue;
                            pstmt.executeBatch();
                            batchSize = 0;
                        }
                        if (batchSize > 0) {
                            pstmt.executeBatch();
                        }
                        if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                            this.plugin.getLogger().fine("Batch stored " + detectedTrades.size() + " dynamic trades");
                        }
                    }
                }, "storeDetectedTradesBatch");
                return null;
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }, "storeDetectedTradesBatch");
    }

    public CompletableFuture<Void> updateTradeLastSeen(String tradeId) {
        return this.databaseService.executeAsync(() -> {
            try {
                this.databaseService.executeUpdate("UPDATE dynamic_trades SET last_seen = CURRENT_TIMESTAMP WHERE trade_id = ?", pstmt -> pstmt.setString(1, tradeId), "updateTradeLastSeen");
                return null;
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }, "updateTradeLastSeen");
    }

    public CompletableFuture<Map<String, DynamicTradeDetector.DetectedTrade>> loadAllDynamicTrades() {
        return this.databaseService.executeAsync(() -> {
            HashMap trades = new HashMap();
            try {
                this.databaseService.executeQuery("SELECT * FROM dynamic_trades ORDER BY profession, level", rs -> {
                    while (rs.next()) {
                        DynamicTradeDetector.DetectedTrade trade = this.resultSetToDetectedTrade(rs);
                        if (trade == null) continue;
                        trades.put(trade.getTradeId(), trade);
                    }
                    return null;
                }, "loadAllDynamicTrades");
                this.plugin.getLogger().info("Loaded " + trades.size() + " dynamic trades from database");
                return trades;
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }, "loadAllDynamicTrades");
    }

    public CompletableFuture<List<DynamicTradeDetector.DetectedTrade>> loadTradesForProfession(String profession) {
        return this.databaseService.executeAsync(() -> {
            try {
                return this.databaseService.executeQuery("SELECT * FROM dynamic_trades WHERE profession = ? ORDER BY level, detected_at", rs -> {
                    ArrayList<DynamicTradeDetector.DetectedTrade> trades = new ArrayList<DynamicTradeDetector.DetectedTrade>();
                    while (rs.next()) {
                        DynamicTradeDetector.DetectedTrade trade = this.resultSetToDetectedTrade(rs);
                        if (trade == null) continue;
                        trades.add(trade);
                    }
                    return trades;
                }, "loadTradesForProfession");
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }, "loadTradesForProfession");
    }

    public CompletableFuture<Boolean> tradeExists(String tradeId) {
        return this.databaseService.executeAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, "tradeExists");
    }

    public CompletableFuture<Void> setCustomPrice(String tradeId, int price) {
        return this.databaseService.executeAsync(() -> {
            try {
                this.databaseService.executeUpdate("UPDATE dynamic_trades SET custom_price = ? WHERE trade_id = ?", pstmt -> {
                    pstmt.setInt(1, price);
                    pstmt.setString(2, tradeId);
                }, "setCustomPrice");
                if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                    this.plugin.getLogger().fine("Set custom price for dynamic trade: " + tradeId + " = " + price);
                }
                return null;
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }, "setCustomPrice");
    }

    public CompletableFuture<Void> removeCustomPrice(String tradeId) {
        return this.databaseService.executeAsync(() -> {
            try {
                this.databaseService.executeUpdate("UPDATE dynamic_trades SET custom_price = NULL WHERE trade_id = ?", pstmt -> pstmt.setString(1, tradeId), "removeCustomPrice");
                if (this.plugin.getConfig().getBoolean("logging.debug_database", false)) {
                    this.plugin.getLogger().fine("Removed custom price for dynamic trade: " + tradeId);
                }
                return null;
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }, "removeCustomPrice");
    }

    public CompletableFuture<Integer> cleanupOldTrades(int daysOld) {
        return this.databaseService.executeAsync(() -> {
            try {
                int deleted = this.databaseService.executeUpdate("DELETE FROM dynamic_trades WHERE last_seen < datetime('now', '-' || ? || ' days')", pstmt -> pstmt.setInt(1, daysOld), "cleanupOldTrades");
                if (deleted > 0) {
                    this.plugin.getLogger().info("Cleaned up " + deleted + " old dynamic trades (" + daysOld + " days old)");
                }
                return deleted;
            }
            catch (DatabaseException e) {
                this.plugin.getLogger().severe("Failed to cleanup old trades: " + e.getMessage());
                return 0;
            }
        }, "cleanupOldTrades");
    }

    public CompletableFuture<Map<String, Integer>> getTradeStatistics() {
        return this.databaseService.executeAsync(() -> {
            HashMap stats = new HashMap();
            try {
                this.databaseService.executeQuery("SELECT profession, COUNT(*) as count FROM dynamic_trades GROUP BY profession", rs -> {
                    while (rs.next()) {
                        stats.put(rs.getString("profession"), rs.getInt("count"));
                    }
                    return null;
                }, "getTradeStatistics");
                this.databaseService.executeQuery("SELECT COUNT(*) as total FROM dynamic_trades", rs -> {
                    if (rs.next()) {
                        stats.put("total", rs.getInt("total"));
                    }
                    return null;
                }, "getTradeStatistics");
                return stats;
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }, "getTradeStatistics");
    }

    private DynamicTradeDetector.DetectedTrade resultSetToDetectedTrade(ResultSet rs) throws SQLException {
        try {
            String tradeId = rs.getString("trade_id");
            String profession = rs.getString("profession");
            int level = rs.getInt("level");
            ItemStack inputItem = this.storageStringToItem(rs.getString("input_item"), rs.getInt("input_amount"));
            List<ItemStack> ingredients = Arrays.asList(inputItem);
            ItemStack result = this.storageStringToItem(rs.getString("output_item"), rs.getInt("output_amount"));
            String simpleName = rs.getString("simple_name");
            return new DynamicTradeDetector.DetectedTrade(tradeId, profession, level, ingredients, result, 0, 12, false, null, simpleName);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to convert ResultSet to DetectedTrade: " + e.getMessage());
            return null;
        }
    }

    private String itemToStorageString(ItemStack item) {
        if (item == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(item.getType().name().toLowerCase());
        if (!item.hasItemMeta() || item.getType().name().equals("ENCHANTED_BOOK")) {
            // empty if block
        }
        return sb.toString();
    }

    private ItemStack storageStringToItem(String storageString, int amount) {
        if (storageString == null || storageString.equals("null")) {
            return new ItemStack(Material.AIR, amount);
        }
        try {
            Material material = Material.valueOf((String)storageString.toUpperCase());
            return new ItemStack(material, amount);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Unknown material in storage string: " + storageString);
            return new ItemStack(Material.AIR, amount);
        }
    }

    public CompletableFuture<DynamicTradeDetector.DetectedTrade> getDetectedTrade(String profession, ItemStack result, List<ItemStack> ingredients) {
        return this.databaseService.executeAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, "getDetectedTrade");
    }

    public CompletableFuture<Integer> clearOldTrades(int daysOld) {
        return this.databaseService.executeAsync(() -> {
            try {
                int deleted = this.databaseService.executeUpdate("DELETE FROM dynamic_trades WHERE last_seen < datetime('now', '-' || ? || ' days')", pstmt -> pstmt.setInt(1, daysOld), "clearOldTrades");
                if (deleted > 0) {
                    this.plugin.getLogger().info("Cleared " + deleted + " old dynamic trade records (" + daysOld + " days old)");
                }
                return deleted;
            }
            catch (DatabaseException e) {
                this.plugin.getLogger().severe("Failed to clear old trades: " + e.getMessage());
                return 0;
            }
        }, "clearOldTrades");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer getCustomPriceForTrade(String tradeId) {
        try {
            Connection conn = this.databaseProvider.getConnection().get();
            String sql = "SELECT price FROM custom_prices WHERE trade_id = ?";
            try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                pstmt.setString(1, tradeId);
                try (ResultSet rs = pstmt.executeQuery();){
                    if (!rs.next()) return null;
                    Integer n = rs.getInt("price");
                    return n;
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get custom price for trade " + tradeId + ": " + e.getMessage());
        }
        return null;
    }
}

