/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class GroqApiService {
    private static final String GROQ_API_URL = "https://api.groq.com/openai/v1/chat/completions";
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private final VillagerTradeManager plugin;
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final String apiKey;
    private final String model;
    private final int maxTokens;
    private final double temperature;
    private final int timeoutSeconds;
    private final boolean includePluginContext;
    private final boolean enableFunctionAnalysis;

    public GroqApiService(VillagerTradeManager plugin) {
        this.plugin = plugin;
        this.apiKey = "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";
        this.model = "llama-3.1-8b-instant";
        this.maxTokens = plugin.getConfig().getInt("ai_assistant.groq.max_tokens", 500);
        this.temperature = plugin.getConfig().getDouble("ai_assistant.groq.temperature", 0.3);
        this.timeoutSeconds = plugin.getConfig().getInt("ai_assistant.groq.timeout_seconds", 10);
        this.includePluginContext = plugin.getConfig().getBoolean("ai_assistant.groq.include_plugin_context", true);
        this.enableFunctionAnalysis = plugin.getConfig().getBoolean("ai_assistant.groq.enable_function_analysis", true);
        this.httpClient = new OkHttpClient.Builder().connectTimeout((long)this.timeoutSeconds, TimeUnit.SECONDS).readTimeout((long)this.timeoutSeconds, TimeUnit.SECONDS).writeTimeout((long)this.timeoutSeconds, TimeUnit.SECONDS).build();
        this.objectMapper = new ObjectMapper();
    }

    public boolean isAvailable() {
        return !this.apiKey.isEmpty() && !"your-groq-api-key-here".equals(this.apiKey);
    }

    public CompletableFuture<String> generateResponse(String question) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (!this.isAvailable()) {
                    return "Groq API is not configured. Please set a valid API key in config.yml.";
                }
                String systemPrompt = this.buildSystemPrompt();
                String userPrompt = this.buildUserPrompt(question);
                String requestBody = this.buildRequestBody(systemPrompt, userPrompt);
                Request request = new Request.Builder().url(GROQ_API_URL).addHeader("Authorization", "Bearer " + this.apiKey).addHeader("Content-Type", "application/json").post(RequestBody.create((String)requestBody, (MediaType)JSON)).build();
                try (Response response = this.httpClient.newCall(request).execute();){
                    if (!response.isSuccessful()) {
                        this.plugin.getLogger().warning("Groq API request failed with code: " + response.code());
                        String string = "Sorry, I'm unable to provide an AI response right now. Please try again later.";
                        return string;
                    }
                    ResponseBody responseBody = response.body();
                    if (responseBody == null) {
                        String string = "Sorry, I received an empty response from the AI service.";
                        return string;
                    }
                    String responseJson = responseBody.string();
                    String string = this.parseResponse(responseJson);
                    return string;
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("Error communicating with Groq API: " + e.getMessage());
                    return "Sorry, I'm unable to connect to the AI service right now. Please try again later.";
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Unexpected error in Groq API service: " + e.getMessage());
                return "Sorry, an unexpected error occurred while processing your request.";
            }
        });
    }

    private String buildSystemPrompt() {
        StringBuilder prompt = new StringBuilder();
        prompt.append("You are an AI assistant for the Villager Trade Manager Minecraft plugin.\n\n");
        if (this.enableFunctionAnalysis) {
            prompt.append("FUNCTION ANALYSIS CAPABILITIES:\n");
            prompt.append("You can analyze plugin functions and provide insights about:\n");
            prompt.append("- Command handlers and their parameters\n");
            prompt.append("- Service classes and their methods\n");
            prompt.append("- Database operations and queries\n");
            prompt.append("- Event listeners and their triggers\n");
            prompt.append("- Configuration options and their effects\n\n");
        }
        prompt.append("RESPONSE GUIDELINES:\n");
        prompt.append("- Be concise but comprehensive\n");
        prompt.append("- Use clear, step-by-step instructions when explaining procedures\n");
        prompt.append("- Include specific commands and examples when relevant\n");
        prompt.append("- Mention configuration file locations when discussing settings\n");
        prompt.append("- If unsure about something, admit it and suggest checking documentation\n");
        prompt.append("- Always prioritize accuracy over completeness\n\n");
        prompt.append("Remember: You're helping Minecraft server administrators manage their villager trading systems effectively.");
        return prompt.toString();
    }

    private String buildUserPrompt(String question) {
        StringBuilder prompt = new StringBuilder();
        prompt.append("User Question: ").append(question).append("\n\n");
        if (this.enableFunctionAnalysis) {
            prompt.append("If this question relates to plugin functionality, consider analyzing relevant methods or features.\n");
        }
        prompt.append("Please provide a helpful, accurate answer based on your knowledge of the Villager Trade Manager plugin.");
        return prompt.toString();
    }

    private String buildRequestBody(String systemPrompt, String userPrompt) {
        try {
            GroqMessage[] messages = new GroqMessage[]{new GroqMessage("system", systemPrompt), new GroqMessage("user", userPrompt)};
            return this.objectMapper.writeValueAsString((Object)new GroqRequest(this.model, messages, this.maxTokens, this.temperature));
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error building Groq API request: " + e.getMessage());
            return "{}";
        }
    }

    private String parseResponse(String responseJson) {
        try {
            JsonNode firstChoice;
            JsonNode message;
            String content;
            JsonNode root = this.objectMapper.readTree(responseJson);
            JsonNode choices = root.path("choices");
            if (choices.isArray() && choices.size() > 0 && (content = (message = (firstChoice = choices.get(0)).path("message")).path("content").asText()) != null && !content.trim().isEmpty()) {
                return content.trim();
            }
            return "Sorry, I received an incomplete response from the AI service.";
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error parsing Groq API response: " + e.getMessage());
            return "Sorry, I couldn't understand the response from the AI service.";
        }
    }

    private static class GroqMessage {
        public String role;
        public String content;

        public GroqMessage(String role, String content) {
            this.role = role;
            this.content = content;
        }
    }

    private static class GroqRequest {
        public String model;
        public GroqMessage[] messages;
        public int max_tokens;
        public double temperature;

        public GroqRequest(String model, GroqMessage[] messages, int maxTokens, double temperature) {
            this.model = model;
            this.messages = messages;
            this.max_tokens = maxTokens;
            this.temperature = temperature;
        }
    }
}

