/*
 * Decompiled with CFR 0.152.
 */
package com.alan.VillagerTradeManager.services;

import com.alan.VillagerTradeManager.VillagerTradeManager;
import com.alan.VillagerTradeManager.services.DatabaseService;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;

public class PluginContextService {
    private final VillagerTradeManager plugin;

    public PluginContextService(VillagerTradeManager plugin) {
        this.plugin = plugin;
    }

    public Map<String, Object> gatherPluginContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("plugin_version", this.plugin.getPluginMeta().getVersion());
        context.put("plugin_name", this.plugin.getPluginMeta().getName());
        context.put("plugin_enabled", this.plugin.isEnabled());
        context.put("server_version", Bukkit.getVersion());
        context.put("bukkit_version", Bukkit.getBukkitVersion());
        context.put("server_name", Bukkit.getServer().getName());
        context.put("online_players", Bukkit.getOnlinePlayers().size());
        context.put("max_players", Bukkit.getMaxPlayers());
        context.put("worlds", this.gatherWorldInformation());
        context.put("database_type", this.plugin.getConfig().getString("database.type", "sqlite"));
        context.put("database_status", this.getDatabaseStatus());
        context.put("trade_management_enabled", this.plugin.getConfig().getBoolean("core.trade_management_enabled", true));
        context.put("dynamic_trades_enabled", this.plugin.getConfig().getBoolean("dynamic_trades.enabled", true));
        context.put("trade_enhancements_enabled", this.plugin.getConfig().getBoolean("trade_enhancements.enabled", true));
        context.put("metrics_enabled", this.plugin.getConfig().getBoolean("metrics.enabled", false));
        context.put("performance_metrics", this.gatherPerformanceMetrics());
        context.put("villager_statistics", this.gatherVillagerStatistics());
        context.put("ai_assistant_enabled", this.plugin.getConfig().getBoolean("ai_assistant.enabled", true));
        context.put("groq_enabled", this.plugin.getConfig().getBoolean("ai_assistant.groq.enabled", true));
        return context;
    }

    private Map<String, Object> gatherWorldInformation() {
        HashMap<String, Object> worldsInfo = new HashMap<String, Object>();
        for (World world : Bukkit.getWorlds()) {
            HashMap<String, Object> worldData = new HashMap<String, Object>();
            worldData.put("name", world.getName());
            worldData.put("environment", world.getEnvironment().name());
            worldData.put("difficulty", world.getDifficulty().name());
            worldData.put("loaded_chunks", world.getLoadedChunks().length);
            worldData.put("entities", world.getEntities().size());
            worldsInfo.put(world.getName(), worldData);
        }
        return worldsInfo;
    }

    private String getDatabaseStatus() {
        try {
            DatabaseService databaseService = this.plugin.getDatabaseService();
            if (databaseService != null) {
                return "Connected";
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error checking database status: " + e.getMessage());
        }
        return "Unknown";
    }

    private Map<String, Object> gatherPerformanceMetrics() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapUsage = memoryBean.getHeapMemoryUsage();
        metrics.put("heap_used_mb", heapUsage.getUsed() / 1024L / 1024L);
        metrics.put("heap_max_mb", heapUsage.getMax() / 1024L / 1024L);
        metrics.put("heap_percentage", (double)heapUsage.getUsed() / (double)heapUsage.getMax() * 100.0);
        try {
            double[] tps = Bukkit.getServer().getTPS();
            metrics.put("server_tps_1m", String.format("%.2f", tps[0]));
            metrics.put("server_tps_5m", String.format("%.2f", tps[1]));
            metrics.put("server_tps_15m", String.format("%.2f", tps[2]));
        }
        catch (Exception e) {
            metrics.put("server_tps", "Unavailable");
        }
        if (this.plugin.getConfig().getBoolean("metrics.enabled", false)) {
            metrics.put("plugin_cache_hit_rate", "Available via /metrics endpoint");
            metrics.put("database_query_count", "Available via /metrics endpoint");
        }
        return metrics;
    }

    private Map<String, Object> gatherVillagerStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        AtomicInteger totalVillagers = new AtomicInteger(0);
        AtomicInteger tradingVillagers = new AtomicInteger(0);
        HashMap<String, Integer> professionCounts = new HashMap<String, Integer>();
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!(entity instanceof Villager)) continue;
                Villager villager = (Villager)entity;
                totalVillagers.incrementAndGet();
                if (villager.getProfession() != null) {
                    String profession = villager.getProfession().getKey().asString();
                    professionCounts.put(profession, professionCounts.getOrDefault(profession, 0) + 1);
                }
                if (villager.getRecipes().isEmpty()) continue;
                tradingVillagers.incrementAndGet();
            }
        }
        stats.put("total_villagers", totalVillagers.get());
        stats.put("trading_villagers", tradingVillagers.get());
        stats.put("profession_distribution", professionCounts);
        return stats;
    }

    public String analyzeFunction(String functionName) {
        if (functionName == null || functionName.trim().isEmpty()) {
            return this.getGeneralPluginCapabilities();
        }
        String lowerFunction = functionName.toLowerCase().trim();
        if (lowerFunction.contains("command") || lowerFunction.contains("handler")) {
            return this.analyzeCommandHandlers(lowerFunction);
        }
        if (lowerFunction.contains("service")) {
            return this.analyzeServices(lowerFunction);
        }
        if (lowerFunction.contains("database") || lowerFunction.contains("db")) {
            return this.analyzeDatabaseCapabilities(lowerFunction);
        }
        if (lowerFunction.contains("trade")) {
            return this.analyzeTradeCapabilities(lowerFunction);
        }
        if (lowerFunction.contains("config")) {
            return this.analyzeConfigurationCapabilities(lowerFunction);
        }
        return this.getGeneralPluginCapabilities();
    }

    private String analyzeCommandHandlers(String query) {
        return "The plugin features a comprehensive command system with specialized handlers for:\n\u2022 Trade Management: setprice, listtrades, resetprice\n\u2022 Villager Inspection: inspectvillager, analyzetrades\n\u2022 Stock Control: restock, stock management commands\n\u2022 Administration: banitem, exporttrades, importtrades\n\u2022 Help System: AI-powered assistance with askquestion\nEach handler includes proper permission checking, tab completion, and error handling.";
    }

    private String analyzeServices(String query) {
        return "Core services include:\n\u2022 TradeService: Manages villager trade operations and pricing\n\u2022 DatabaseService: Handles all database operations with connection pooling\n\u2022 PriceCalculationService: Dynamic pricing with reputation and demand factors\n\u2022 StockService: Manages trade stock levels and restocking\n\u2022 MetricsService: Performance monitoring and health checks\n\u2022 ConfigurationService: Dynamic configuration management\nAll services implement proper error handling and resource management.";
    }

    private String analyzeDatabaseCapabilities(String query) {
        return "Database capabilities:\n\u2022 Multi-platform support: SQLite, PostgreSQL, Supabase\n\u2022 Connection pooling with HikariCP\n\u2022 Prepared statements for security\n\u2022 Transaction management\n\u2022 Schema versioning and migrations\n\u2022 Query optimization and indexing\n\u2022 Backup and restore functionality";
    }

    private String analyzeTradeCapabilities(String query) {
        return "Trade system features:\n\u2022 Dynamic trade detection and learning\n\u2022 Custom pricing by profession and item\n\u2022 Trade enhancement chains and prerequisites\n\u2022 Stock management with automatic restocking\n\u2022 Wandering trader support\n\u2022 Biome and dimension modifiers\n\u2022 Reputation-based pricing adjustments";
    }

    private String analyzeConfigurationCapabilities(String query) {
        return "Configuration system:\n\u2022 Hierarchical YAML configuration\n\u2022 Runtime configuration reloading\n\u2022 Validation with detailed error messages\n\u2022 Environment-specific settings\n\u2022 Database-persisted overrides\n\u2022 Comprehensive documentation\n\u2022 Backup and restore capabilities";
    }

    private String getGeneralPluginCapabilities() {
        return "Villager Trade Manager is a comprehensive Minecraft plugin that provides:\n\n\ud83c\udfaf CORE FEATURES:\n\u2022 Complete villager trade management and customization\n\u2022 Dynamic pricing system with reputation and demand factors\n\u2022 Advanced stock management with automatic restocking\n\u2022 Trade enhancement system with chains and prerequisites\n\u2022 Wandering trader support and tracking\n\n\ud83d\udee0\ufe0f TECHNICAL CAPABILITIES:\n\u2022 Multi-database support (SQLite, PostgreSQL, Supabase)\n\u2022 High-performance caching with adaptive strategies\n\u2022 Comprehensive metrics and monitoring\n\u2022 Async operations for optimal server performance\n\u2022 Folia compatibility for modern servers\n\n\ud83e\udd16 AI ASSISTANT:\n\u2022 Intelligent help system with Groq API integration\n\u2022 Plugin-specific context awareness\n\u2022 Function analysis capabilities\n\u2022 Comprehensive knowledge base";
    }
}

